/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.renderer;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredientRenderer;
import modulardiversity.jei.JEIHelpers;
import modulardiversity.jei.ingredients.HotAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RendererHotAir
implements IIngredientRenderer<HotAir> {
    private IDrawableStatic hot_air_empty;
    private IDrawableStatic hot_air_fill;

    private void registerDrawables() {
        if (this.hot_air_empty == null) {
            this.hot_air_empty = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 0, 73, 10, 15);
        }
        if (this.hot_air_fill == null) {
            this.hot_air_fill = JEIHelpers.GUI_HELPER.createDrawable(JEIHelpers.TEXTURE, 10, 73, 10, 15);
        }
    }

    public List<String> getTooltip(Minecraft minecraft, HotAir ingredient, ITooltipFlag tooltipFlag) {
        return Lists.newArrayList((Object[])new String[]{(int)ingredient.getTempRequired() + "\u00c2\u00b0C Hot Air"});
    }

    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable HotAir hotair) {
        this.registerDrawables();
        GlStateManager.func_179141_d();
        Color color = new Color(Color.HSBtoRGB(0.18f, 0.18f, 0.5f));
        int airTemp = (int)(hotair != null ? hotair.getTempRequired() : 0.0f);
        this.renderFullOfHotAir(minecraft, xPosition, yPosition, color.getRGB(), (float)(Math.sin((double)System.currentTimeMillis() / 800.0) + 1.0) / 8.0f + 0.75f, airTemp, 400);
        GlStateManager.func_179118_c();
    }

    public void renderFullOfHotAir(Minecraft minecraft, int x, int y, int color, float alpha, int airTemp, int maxTemp) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.hot_air_empty.draw(minecraft, x, y);
        int tempPercent = Math.max(0, (int)((double)airTemp / (double)maxTemp * 12.0));
        this.hot_air_fill.draw(minecraft, x, y);
        Color color_ = new Color(color);
        GL11.glColor4ub((byte)((byte)color_.getRed()), (byte)((byte)color_.getGreen()), (byte)((byte)color_.getBlue()), (byte)((byte)(255.0f * alpha)));
        this.hot_air_fill.draw(minecraft, x, y, 0, MathHelper.func_76125_a((int)tempPercent, (int)2, (int)16), 0, 0);
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
    }
}

