/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.renderer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import modulardiversity.jei.ingredients.Reservoir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;

public class RendererReservoir
implements IIngredientRenderer<Reservoir> {
    private void registerDrawables() {
    }

    public void render(Minecraft minecraft, int i, int i1, @Nullable Reservoir ingredient) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.registerDrawables();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    public List<String> getTooltip(Minecraft minecraft, Reservoir ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(ingredient.getDisplayName());
        if (ingredient.getFluidMax() < Integer.MAX_VALUE || ingredient.getFluidMin() > 0) {
            tooltip.add(I18n.func_135052_a((String)this.getAmountKey(ingredient), (Object[])new Object[]{ingredient.getFluidMin(), ingredient.getFluidMax()}));
        }
        if (ingredient.getResidualMax() < Integer.MAX_VALUE || ingredient.getResidualMin() > 0) {
            tooltip.add(I18n.func_135052_a((String)this.getResidualKey(ingredient), (Object[])new Object[]{ingredient.getResidualMin(), ingredient.getResidualMax()}));
        }
        tooltip.add(I18n.func_135052_a((String)this.getResultKey(ingredient), (Object[])new Object[]{ingredient.getAmount()}));
        return tooltip;
    }

    private String getResidualKey(Reservoir ingredient) {
        if (ingredient.getResidualMin() <= 0) {
            return "tooltip.reservoir.residual.less";
        }
        if (ingredient.getResidualMax() >= Integer.MAX_VALUE) {
            return "tooltip.reservoir.residual.greater";
        }
        if (ingredient.getResidualMax() == ingredient.getResidualMin()) {
            return "tooltip.reservoir.residual.exact";
        }
        return "tooltip.reservoir.residual";
    }

    private String getAmountKey(Reservoir ingredient) {
        if (ingredient.getFluidMin() <= 0) {
            return "tooltip.reservoir.amount.less";
        }
        if (ingredient.getFluidMax() >= Integer.MAX_VALUE) {
            return "tooltip.reservoir.amount.greater";
        }
        if (ingredient.getFluidMax() == ingredient.getFluidMin()) {
            return "tooltip.reservoir.amount.exact";
        }
        return "tooltip.reservoir.amount";
    }

    private String getResultKey(Reservoir ingredient) {
        if (ingredient.getAmount() > 0) {
            return "tooltip.reservoir.result.fill";
        }
        if (ingredient.getAmount() < 0) {
            return "tooltip.reservoir.result.deplete";
        }
        return "tooltip.reservoir.result.none";
    }
}

