/*
 * Decompiled with CFR 0.152.
 */
package pw.aaron1011.servermonitor.sponge;

import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import pw.aaron1011.servermonitor.sponge.ServerStatus;
import pw.aaron1011.servermonitor.sponge.data.ConfigFileManager;
import pw.aaron1011.servermonitor.sponge.data.SignData;
import pw.aaron1011.servermonitor.sponge.data.SignInstance;

@Plugin(id="servermonitor", name="ServerMonitor", description="Monitors BungeeCord servers", version="1.0.0", authors={"Aaron1011"})
public class ServerMonitorSponge {
    public static ServerMonitorSponge INSTANCE;
    @Inject
    public Logger logger;
    public ConfigFileManager<SignData> signFileManager;
    private ChannelBinding.RawDataChannel channel;
    private ChannelBinding.RawDataChannel bungeeCordChannel;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    private HoconConfigurationLoader signDataLoader;
    private ConfigurationOptions signOptions = ConfigurationOptions.defaults();
    private static final String SIGN_PERM = "servermonitor.sign";
    private Map<String, ServerStatus> serverStatus = new HashMap<String, ServerStatus>();

    @Listener
    public void onPreInit(GamePreInitializationEvent event) {
        INSTANCE = this;
        this.configDir.toFile().mkdirs();
        this.channel = Sponge.getChannelRegistrar().createRawChannel((Object)this, "ServerMonitor");
        this.channel.addListener(Platform.Type.SERVER, (data, connection, side) -> {
            byte id = data.readByte();
            if (id == 0) {
                byte status = data.readByte();
                short numPlayers = data.readShort();
                String serverName = data.readUTF();
                String broadcastMessage = data.readUTF();
                boolean online = status == 1;
                Sponge.getScheduler().createTaskBuilder().delayTicks(0L).execute(() -> {
                    this.logger.info("Got server status: " + status + " " + serverName + " #" + numPlayers);
                    this.serverStatus.put(serverName, new ServerStatus(online, numPlayers));
                    this.updateServerSigns(serverName);
                    if (!broadcastMessage.isEmpty()) {
                        MessageChannel.TO_ALL.send(TextSerializers.FORMATTING_CODE.deserialize(broadcastMessage));
                    }
                }).submit((Object)this);
            }
        });
        this.bungeeCordChannel = Sponge.getChannelRegistrar().createRawChannel((Object)this, "BungeeCord");
        this.signDataLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.configDir.resolve("signs.conf"))).build();
        this.signFileManager = new ConfigFileManager<SignData>((ConfigurationLoader<CommentedConfigurationNode>)this.signDataLoader, this.signOptions, SignData.class);
        this.signFileManager.reload(false);
        this.signFileManager.getPluginConfig().rebuildCache();
    }

    private void updateServerSign(SignInstance instance) {
        TextColor line1Color;
        LiteralText line2;
        ServerStatus status = this.serverStatus.get(instance.serverName);
        if (status == null) {
            line2 = Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "UNKNOWN"});
            line1Color = TextColors.DARK_GRAY;
        } else if (status.online) {
            line2 = Text.of((Object[])new Object[]{Text.of((String)("Online " + status.players))});
            line1Color = TextColors.LIGHT_PURPLE;
        } else {
            line2 = Text.of((String)"Offline");
            line1Color = TextColors.RED;
        }
        Optional te = instance.locationData.getLocation().getTileEntity();
        if (!te.isPresent()) {
            this.logger.error("Expected sign at location " + instance.locationData.getLocation() + " but found " + instance.locationData.getLocation().getBlock());
            return;
        }
        List lines = (List)((TileEntity)te.get()).require(Keys.SIGN_LINES);
        lines.set(0, ((Text)lines.get(0)).toBuilder().color(line1Color).build());
        lines.set(2, line2);
        ((TileEntity)te.get()).offer(Keys.SIGN_LINES, (Object)lines);
    }

    private void updateServerSigns(String name) {
        List<SignInstance> instances = this.signFileManager.getPluginConfig().getInstances(name);
        if (instances == null) {
            return;
        }
        for (SignInstance instance : instances) {
            this.updateServerSign(instance);
        }
    }

    @Listener
    public void onMakeSign(ChangeSignEvent event, @First Player player) {
        List lines = (List)event.getText().lines().get();
        if (!((Text)lines.get(0)).toPlain().equals("[Server]")) {
            return;
        }
        if (!player.hasPermission(SIGN_PERM)) {
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to create server signs!"}));
            return;
        }
        String name = ((Text)lines.get(1)).toPlain();
        lines.set(0, ((Text)lines.get(0)).toBuilder().color(TextColors.LIGHT_PURPLE).build());
        event.getText().set(Keys.SIGN_LINES, (Object)lines);
        SignInstance instance = new SignInstance(name, (Location<World>)event.getTargetTile().getLocation());
        this.signFileManager.getPluginConfig().addInstance(instance);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully created sign for server " + name}));
        Sponge.getScheduler().createTaskBuilder().delayTicks(0L).execute(() -> this.updateServerSigns(name)).submit((Object)this);
    }

    @Listener
    public void onClick(InteractBlockEvent.Secondary event, @First Player player) {
        Optional<SignInstance> instance;
        BlockType type = event.getTargetBlock().getState().getType();
        if ((type.equals(BlockTypes.STANDING_SIGN) || type.equals(BlockTypes.WALL_SIGN)) && (instance = this.signFileManager.getPluginConfig().getInstance((Location<World>)((Location)event.getTargetBlock().getLocation().get()))).isPresent()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Sending you to server " + instance.get().serverName}));
            this.bungeeCordChannel.sendTo(player, buf -> {
                buf.writeUTF("Connect");
                buf.writeUTF(((SignInstance)instance.get()).serverName);
            });
        }
    }

    @Listener
    public void onBreakSign(ChangeBlockEvent.Break event, @First Player player) {
        for (Transaction transaction : event.getTransactions()) {
            Optional<SignInstance> instance;
            if (!((BlockSnapshot)transaction.getOriginal()).getState().getType().equals(BlockTypes.WALL_SIGN) && !((BlockSnapshot)transaction.getOriginal()).getState().getType().equals(BlockTypes.STANDING_SIGN) || !(instance = this.signFileManager.getPluginConfig().getInstance((Location<World>)((Location)((BlockSnapshot)transaction.getOriginal()).getLocation().get()))).isPresent()) continue;
            if (player.hasPermission(SIGN_PERM)) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Sucessfully destroyed sign for server " + instance.get().serverName}));
                this.signFileManager.getPluginConfig().removeInstance(instance.get());
                break;
            }
            event.setCancelled(true);
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to break server signs!"}));
            return;
        }
    }
}

