/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.wrapper;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import leviathan143.loottweaker.common.darkmagic.LootTableAccessors;
import leviathan143.loottweaker.common.lib.LootTableFinder;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootPoolWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootTable")
public class ZenLootTableWrapper {
    private final ResourceLocation id;
    private final List<LootTableTweaker> tweaks = new ArrayList<LootTableTweaker>();
    private final Map<String, ZenLootPoolWrapper> tweakedPools = new HashMap<String, ZenLootPoolWrapper>();
    private final LootTweakerContext context;

    public ZenLootTableWrapper(LootTweakerContext context, ResourceLocation id) {
        this.context = context;
        this.id = id;
    }

    @ZenMethod
    public ZenLootPoolWrapper getPool(String poolName) {
        if (this.tweakedPools.containsKey(poolName)) {
            return this.tweakedPools.get(poolName);
        }
        ZenLootPoolWrapper pool = this.context.wrapPool(poolName, this.id);
        this.tweakedPools.put(poolName, pool);
        this.enqueueTweaker(table -> {
            LootPool targetPool = table.getPool(poolName);
            if (targetPool != null) {
                if (!targetPool.isFrozen()) {
                    pool.tweak(targetPool);
                } else {
                    CraftTweakerAPI.logInfo((String)String.format("Skipped modifying pool %s of table %s because it is frozen", poolName, this.id));
                }
            } else {
                this.context.getErrorHandler().error("No loot pool with name %s exists in table %s!", poolName, this.id);
            }
        }, "Retrieved pool %s from table %s", poolName, this.id);
        return pool;
    }

    @ZenMethod
    public ZenLootPoolWrapper addPool(String poolName, int minRolls, int maxRolls, int minBonusRolls, int maxBonusRolls) {
        ZenLootPoolWrapper pool = this.context.createPoolWrapper(poolName, this.id);
        this.enqueueTweaker(pool, "Queued pool %s for addition to table %s", poolName, this.id);
        pool.setRolls(minRolls, maxRolls);
        pool.setBonusRolls(minBonusRolls, maxBonusRolls);
        return pool;
    }

    @ZenMethod
    public void removePool(String poolName) {
        this.enqueueTweaker(table -> {
            if (table.getPool(poolName) == null) {
                this.context.getErrorHandler().error("No loot pool with name %s exists in table %s!", poolName, this.id);
                return;
            }
            table.removePool(poolName);
        }, "Queued pool %s of table %s for removal", poolName, this.id);
    }

    @ZenMethod
    public void clear() {
        this.enqueueTweaker(table -> LootTableAccessors.getPools(table).clear(), "Queued all pools of table %s for removal", this.id);
    }

    private void enqueueTweaker(LootTableTweaker tweaker, String format, Object ... args) {
        this.tweaks.add(tweaker);
        CraftTweakerAPI.logInfo((String)String.format(format, args));
    }

    public void applyTweakers(LootTable table) {
        for (LootTableTweaker tweaker : this.tweaks) {
            tweaker.tweak(table);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isValid() {
        return LootTableFinder.DEFAULT.exists(this.id) || LootTableList.func_186374_a().contains(this.id);
    }

    @FunctionalInterface
    public static interface LootTableTweaker {
        public void tweak(LootTable var1);
    }
}

