/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates;

import com.codehusky.huskycrates.Registry;
import com.codehusky.huskycrates.command.BalanceCommand;
import com.codehusky.huskycrates.command.BlockCommand;
import com.codehusky.huskycrates.command.CommandRegister;
import com.codehusky.huskycrates.command.KeyCommand;
import com.codehusky.huskycrates.crate.listeners.CrateListeners;
import com.codehusky.huskycrates.crate.listeners.SQLUpdateListener;
import com.codehusky.huskycrates.crate.physical.EffectInstance;
import com.codehusky.huskycrates.crate.physical.PhysicalCrate;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Key;
import com.codehusky.huskycrates.event.CrateInjectionEvent;
import com.codehusky.huskycrates.exception.ConfigParseError;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Plugin(id="huskycrates", name="HuskyCrates", version="2.0.0RC3", description="A Crate Plugin for Sponge!", dependencies={@Dependency(id="huskyui", version="0.6.0PRE4"), @Dependency(id="placeholderapi", optional=true)})
public class HuskyCrates {
    public Logger logger;
    @Inject
    public PluginContainer pC;
    @Inject
    @ConfigDir(sharedRoot=false)
    public Path configDir;
    @Inject
    @DefaultConfig(sharedRoot=false)
    public ConfigurationLoader<CommentedConfigurationNode> config;
    public CommentedConfigurationNode mainConfig;
    public Path crateDirectoryPath;
    public ConfigurationLoader<CommentedConfigurationNode> crateLoop;
    public Path keyConfigPath;
    public ConfigurationLoader<CommentedConfigurationNode> keyConfig;
    public CommentedConfigurationNode keys;
    public Path generatedItemConfigPath;
    public ConfigurationLoader<CommentedConfigurationNode> generatedItemConfig;
    public Path generatedInventoryConfigPath;
    public ConfigurationLoader<CommentedConfigurationNode> generatedInventoryConfig;
    public static Path dupeLogPath;
    public static Path storageDirectoryPath;
    public Cause genericCause;
    public static HuskyCrates instance;
    public static Registry registry;
    public boolean inErrorState = false;
    private CrateListeners crateListeners;
    public static boolean KEY_SECURITY;
    public static boolean FORCE_CRATE_CMD;
    private static boolean firstBoot;
    public static KeyCommand.Messages keyCommandMessages;
    public static BlockCommand.Messages blockCommandMessages;
    public static BalanceCommand.Messages balanceCommandMessages;
    public static Crate.Messages crateMessages;
    private static ScriptEngineManager mgr;
    public static ScriptEngine jsengine;
    public boolean virtualKeyDB = false;
    private float cumulative = 0.0f;
    private int iterations = 0;
    private long lastMessage = 0L;
    public static final String generalDefaultConfig = "# To configure HuskyCrates, please reference the documentation, use the \"/hc generatecrate\" command, or use the HuskyConfigurator!\n\n# For more information: https://discord.gg/FSETtcx";

    @Listener
    public void gameInit(GamePreInitializationEvent event) {
        registry = new Registry();
        this.logger = LoggerFactory.getLogger((String)this.pC.getName());
        instance = this;
        storageDirectoryPath = this.configDir.resolve("storage/");
        dupeLogPath = this.configDir.resolve("storage/dupealert.log");
        this.generatedItemConfigPath = this.configDir.resolve("storage/generateditems.conf");
        this.generatedInventoryConfigPath = this.configDir.resolve("storage/generatedinventorys.conf");
        this.crateDirectoryPath = this.configDir.resolve("crates/");
        this.keyConfigPath = this.configDir.resolve("crates/keys.conf");
        this.keyConfig = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.keyConfigPath)).build();
        this.generatedItemConfig = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.generatedItemConfigPath)).build();
        this.generatedInventoryConfig = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.generatedInventoryConfigPath)).build();
        Path crateMigrationPath = this.configDir.resolve("crates.conf");
        Path keysMigrationPath = this.configDir.resolve("keys.conf");
        Path dbMigrationPath = this.configDir.resolve("data.mv.db");
        Path genItemMigrationPath = this.configDir.resolve("generateditems.conf");
        this.migrateConfigs(crateMigrationPath, "/crates/crates.crate");
        this.migrateConfigs(keysMigrationPath, "/crates/keys.conf");
        this.migrateConfigs(dbMigrationPath, "/storage/data.mv.db");
        this.migrateConfigs(genItemMigrationPath, "/storage/generateditems.conf");
    }

    @Listener
    public void gamePostInit(GamePreInitializationEvent event) {
        this.crateListeners = new CrateListeners();
        Sponge.getEventManager().registerListeners((Object)this, (Object)this.crateListeners);
    }

    private void migrateConfigs(Path n, String name) {
        Path conf = Paths.get(this.configDir.toString() + name, new String[0]);
        if (n.toFile().exists()) {
            this.checkOrInitalizeDirectory(this.crateDirectoryPath);
            this.checkOrInitalizeDirectory(storageDirectoryPath);
            try {
                Files.move(n, conf, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("Failed to migrate a config to newer path!");
            }
        }
    }

    public void loadConfig() {
        if (this.checkOrInitalizeDirectory(this.crateDirectoryPath) && this.checkOrInitalizeDirectory(storageDirectoryPath) && this.checkOrInitalizeConfig(this.keyConfigPath, generalDefaultConfig)) {
            this.checkOrInitalizeConfig(dupeLogPath, "#Here you'll find a log of information stored after an instance duplication detection!\n#File will not be read, is simply a log");
            this.checkOrInitalizeConfig(this.generatedItemConfigPath, "# This config contains generated item objects that you create in-game. This file will not be read by the plugin.\n# With the admin permission, try /hc genitem with an item in your hand, then check back here.");
            this.checkOrInitalizeConfig(this.generatedInventoryConfigPath, "# This config contains generated inventory sets that you create in-game. This file will not be read by the plugin.\n# With the admin permission, try /hc geninvent with an inventory full of items, then check back here.");
            try {
                this.mainConfig = (CommentedConfigurationNode)this.config.load();
                this.virtualKeyDB = this.mainConfig.getNode(new Object[]{"virtualkeydatabase"}).getNode(new Object[]{"useRemoteDatabase"}).getBoolean();
                this.keys = (CommentedConfigurationNode)this.keyConfig.load();
                if (this.virtualKeyDB) {
                    Sponge.getEventManager().registerListeners((Object)this, (Object)new SQLUpdateListener());
                }
                for (CommentedConfigurationNode node : this.keys.getChildrenMap().values()) {
                    Key thisKey = new Key((ConfigurationNode)node);
                    registry.registerKey(thisKey);
                }
                File folder = new File(this.crateDirectoryPath.toString());
                File[] files = folder.listFiles();
                ArrayList<File> crateFiles = new ArrayList<File>();
                for (File file : files) {
                    if (!file.getName().endsWith(".crate")) continue;
                    crateFiles.add(file);
                }
                if (crateFiles.size() == 0) {
                    HuskyCrates.instance.logger.debug("The crate directory contains no crates, pushing example config!");
                    if (Sponge.getAssetManager().getAsset((Object)this.pC, "example.crate").isPresent()) {
                        ((Asset)Sponge.getAssetManager().getAsset((Object)this.pC, "example.crate").get()).copyToFile(this.crateDirectoryPath.resolve("example.crate"));
                    } else {
                        HuskyCrates.instance.logger.error("Failed to read asset to copy file from!");
                    }
                }
                for (File file : files) {
                    if (!file.isFile() || !file.getPath().endsWith(".crate") || file.length() <= 0L) continue;
                    this.crateLoop = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file.toPath())).build();
                    CommentedConfigurationNode crateThing = (CommentedConfigurationNode)this.crateLoop.load();
                    if (!crateThing.getNode(new Object[]{"secureKeys"}).isVirtual() && !crateThing.getNode(new Object[]{"secureKeys"}).hasMapChildren()) {
                        throw new ConfigParseError("\"secureKeys\" must be removed from \"" + file.getName() + "\"!", crateThing.getNode(new Object[]{"secureKeys"}).getPath());
                    }
                    for (CommentedConfigurationNode node : crateThing.getChildrenMap().values()) {
                        Crate thisCrate = new Crate((ConfigurationNode)node);
                        registry.registerCrate(thisCrate);
                    }
                    this.logger.debug("Crate Config File \"" + file.getName() + "\" Has been loaded!");
                }
                if (this.mainConfig.getNode(new Object[]{"virtualkeydatabase"}).isVirtual()) {
                    CommentedConfigurationNode db = this.mainConfig.getNode(new Object[]{"virtualkeydatabase"});
                    db.getNode(new Object[]{"useRemoteDatabase"}).setValue((Object)false);
                    db.getNode(new Object[]{"type"}).setValue((Object)"mysql");
                    db.getNode(new Object[]{"host"}).setValue((Object)"127.0.0.1");
                    db.getNode(new Object[]{"port"}).setValue((Object)3306);
                    db.getNode(new Object[]{"database"}).setValue((Object)"huskycrates");
                    db.getNode(new Object[]{"username"}).setValue((Object)"root");
                    db.getNode(new Object[]{"password"}).setValue((Object)"");
                }
                if (!this.mainConfig.getNode(new Object[]{"crates"}).isVirtual()) {
                    throw new ConfigParseError("HuskyCrates.conf contains 1.x config data! Please update it using the Config Converter application!", this.mainConfig.getNode(new Object[]{"crates"}).getPath());
                }
                if (this.mainConfig.getNode(new Object[]{"secureKeys"}).isVirtual()) {
                    this.mainConfig.getNode(new Object[]{"secureKeys"}).setValue((Object)KEY_SECURITY);
                } else {
                    KEY_SECURITY = this.mainConfig.getNode(new Object[]{"secureKeys"}).getBoolean(true);
                }
                if (this.mainConfig.getNode(new Object[]{"forceCrateCMD"}).isVirtual()) {
                    this.mainConfig.getNode(new Object[]{"forceCrateCMD"}).setValue((Object)FORCE_CRATE_CMD);
                } else if (firstBoot && this.mainConfig.getNode(new Object[]{"forceCrateCMD"}).getBoolean(true) != FORCE_CRATE_CMD) {
                    this.logger.error("!!!!!! CRITICAL ERROR !!!!!!");
                    this.logger.error("forceCrateCMD changes require a server reboot to apply!");
                    this.logger.error("Please reboot immediately!");
                    this.logger.error("!!!!!! CRITICAL ERROR !!!!!!");
                    this.inErrorState = true;
                } else {
                    FORCE_CRATE_CMD = this.mainConfig.getNode(new Object[]{"forceCrateCMD"}).getBoolean(true);
                }
                firstBoot = true;
                keyCommandMessages = new KeyCommand.Messages((ConfigurationNode)this.mainConfig.getNode(new Object[]{"messages", "keyCommand"}));
                blockCommandMessages = new BlockCommand.Messages((ConfigurationNode)this.mainConfig.getNode(new Object[]{"messages", "blockCommand"}));
                balanceCommandMessages = new BalanceCommand.Messages((ConfigurationNode)this.mainConfig.getNode(new Object[]{"messages", "balanceCommand"}));
                crateMessages = new Crate.Messages((ConfigurationNode)this.mainConfig.getNode(new Object[]{"messages", "crate"}), null);
                this.config.save((ConfigurationNode)this.mainConfig);
                Sponge.getEventManager().post((Event)new CrateInjectionEvent());
            }
            catch (Exception e) {
                this.inErrorState = true;
                e.printStackTrace();
                this.logger.error("Failed to register crates and keys. Please review the errors printed above.");
            }
        } else {
            this.logger.error("Config initialization experienced an error. Please report this to the developer for help.");
        }
    }

    private boolean checkOrInitalizeConfig(Path path, String defaultContent) {
        if (!path.toFile().exists()) {
            try {
                boolean success = path.toFile().createNewFile();
                if (!success) {
                    this.logger.error("Failed to create new config at " + path.toAbsolutePath().toString());
                    return false;
                }
                PrintWriter pw = new PrintWriter(path.toFile());
                pw.println(defaultContent);
                pw.close();
                return true;
            }
            catch (IOException e) {
                this.inErrorState = true;
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean checkOrInitalizeDirectory(Path path) {
        if (!path.toFile().exists() && !path.toFile().mkdirs()) {
            this.logger.error("Failed to create new directory at " + path.toAbsolutePath().toString());
            return false;
        }
        return true;
    }

    @Listener
    public void gameStarted(GameStartedServerEvent event) {
        this.logger.info("Loading Crates...");
        this.loadConfig();
        Sponge.getScheduler().createTaskBuilder().execute((Consumer)new Consumer<Task>(){

            @Override
            public void accept(Task task) {
                try {
                    long startTime = System.nanoTime();
                    int particles = 0;
                    for (Location<World> location : registry.getPhysicalCrates().keySet()) {
                        PhysicalCrate pcrate = registry.getPhysicalCrate(location);
                        if (pcrate.getIdleEffect() == null) continue;
                        pcrate.getIdleEffect().tick();
                        particles += pcrate.getIdleEffect().getEffect().getParticleCount();
                    }
                    long endTime = System.nanoTime();
                    HuskyCrates.this.cumulative = HuskyCrates.this.cumulative + (float)(endTime - startTime);
                    HuskyCrates.this.iterations++;
                    if (HuskyCrates.this.lastMessage + 1000L < System.currentTimeMillis()) {
                        HuskyCrates.this.lastMessage = System.currentTimeMillis();
                        float avg = HuskyCrates.this.cumulative / (float)HuskyCrates.this.iterations;
                        HuskyCrates.this.iterations = 0;
                        HuskyCrates.this.cumulative = 0.0f;
                    }
                    ArrayList<EffectInstance> nuke = new ArrayList<EffectInstance>();
                    for (EffectInstance inst : registry.getEffects()) {
                        inst.tick();
                        if (!inst.getEffect().isFinished()) continue;
                        nuke.add(inst);
                    }
                    for (EffectInstance inst : nuke) {
                        inst.resetEffect();
                        registry.removeEffect(inst);
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }).intervalTicks(1L).async().submit((Object)this);
        Sponge.getScheduler().createTaskBuilder().execute(registry::pushDirty).interval(1L, TimeUnit.MINUTES).submit((Object)this);
        registry.loadFromDatabase();
        CommandRegister.register(this);
        if (this.inErrorState) {
            this.logger.error("Crates has started with errors. Please review the issue(s) above.");
        } else {
            this.logger.info("Crates has started successfully.");
        }
        if (((String)this.pC.getVersion().get()).contains("PRE")) {
            this.logger.warn("You are currently running a pre-release build!");
            this.logger.warn("This is an unstable version of HuskyCrates and, as such,");
            this.logger.warn("  it has not been tested thoroughly and will have bugs!");
            this.logger.warn("Report all issues to codeHusky on the support discord!");
            this.logger.warn("For help configuring, please consult the SRC or the discord.");
            this.logger.warn("Thanks! - codeHusky");
        }
        this.logger.info("Running HuskyCrates v" + (String)this.pC.getVersion().get());
    }

    public void reload() {
        this.inErrorState = false;
        registry.pushDirty();
        registry.clearRegistry();
        this.loadConfig();
        if (!this.inErrorState) {
            registry.loadFromDatabase();
        }
        if (this.inErrorState) {
            this.logger.error("Crates has reloaded with errors. Please review the issue(s) above.");
        } else {
            this.logger.info("Crates has reloaded successfully.");
        }
    }

    @Listener
    public void gameReloaded(GameReloadEvent event) {
        this.reload();
    }

    @Listener
    public void gameShutdown(GameStoppingServerEvent event) {
        registry.pushDirty();
        this.logger.info("HuskyCrates has shut down.");
    }

    static {
        KEY_SECURITY = true;
        FORCE_CRATE_CMD = true;
        firstBoot = false;
        mgr = new ScriptEngineManager();
        jsengine = mgr.getEngineByName("JavaScript");
    }
}

