/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.physical.EffectInstance;
import com.codehusky.huskycrates.crate.physical.HologramInstance;
import com.codehusky.huskycrates.crate.physical.PhysicalCrate;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Key;
import com.codehusky.huskycrates.crate.virtual.Slot;
import com.codehusky.huskycrates.crate.virtual.effects.Effect;
import com.codehusky.huskycrates.exception.DoubleRegistrationError;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.sql.DataSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class Registry {
    private HashMap<String, Key> keys = new HashMap();
    private HashMap<String, Crate> crates = new HashMap();
    private HashMap<UUID, HashMap<String, Integer>> virtualKeys = new HashMap();
    private HashMap<UUID, HashSet<String>> dirtyVirtualKeys = new HashMap();
    private HashMap<UUID, Map.Entry<String, Integer>> keysInCirculation = new HashMap();
    private HashSet<UUID> dirtyKeysInCirculation = new HashSet();
    private HashMap<UUID, HashMap<String, Long>> lastCrateUse = new HashMap();
    private HashMap<UUID, HashSet<String>> dirtyLastCrateUse = new HashMap();
    private HashMap<Location<World>, PhysicalCrate> physicalCrates = new HashMap();
    private HashSet<Location<World>> dirtyPhysicalCrates = new HashSet();
    private ArrayList<EffectInstance> effects = new ArrayList();

    public String stats() {
        int items = 0;
        for (Crate crate : this.crates.values()) {
            items += crate.getSlots().size();
        }
        return "keys: " + this.keys.size() + "\ncrates: " + this.crates.size() + "\nslot sum: " + items + "\nphysicalCrates: " + this.physicalCrates.size() + "\nrunningEffects: " + this.effects.size();
    }

    public Key getKey(String id) {
        if (!this.isKey(id)) {
            return null;
        }
        if (id.indexOf("LOCALKEY_") == 0) {
            return this.crates.get(id.replace("LOCALKEY_", "")).getLocalKey();
        }
        return this.keys.get(id);
    }

    public Crate getCrate(String id) {
        if (!this.isCrate(id)) {
            return null;
        }
        return this.crates.get(id);
    }

    public PhysicalCrate getPhysicalCrate(Location<World> location) {
        if (!this.isPhysicalCrate(location)) {
            return null;
        }
        return this.physicalCrates.get(location);
    }

    public HashMap<Location<World>, PhysicalCrate> getPhysicalCrates() {
        return this.physicalCrates;
    }

    public boolean isSecureKey(String keyID, UUID uuid) {
        return this.keysInCirculation.containsKey(uuid) && this.keysInCirculation.get(uuid).getKey().equals(keyID) && this.keysInCirculation.get(uuid).getValue() > 0;
    }

    public UUID generateSecureKey(String keyID) {
        return this.generateSecureKey(keyID, 1);
    }

    public UUID generateSecureKey(String keyID, int amount) {
        if (!this.isKey(keyID)) {
            return null;
        }
        UUID uuid = UUID.randomUUID();
        this.keysInCirculation.put(uuid, new AbstractMap.SimpleEntry<String, Integer>(keyID, amount));
        this.dirtyKeysInCirculation.add(uuid);
        return uuid;
    }

    public boolean validateSecureKey(ItemStack stack, int amount) {
        String keyID = Key.extractKeyId(stack);
        UUID keyUUID = Key.extractKeyUUID(stack);
        if (!this.isKey(keyID)) {
            return false;
        }
        return this.keysInCirculation.containsKey(keyUUID) && this.keysInCirculation.get(keyUUID).getKey().equals(keyID) && this.keysInCirculation.get(keyUUID).getValue() >= amount;
    }

    public boolean consumeSecureKey(ItemStack stack, int amount) {
        String keyID = Key.extractKeyId(stack);
        UUID keyUUID = Key.extractKeyUUID(stack);
        if (!this.isKey(keyID)) {
            return false;
        }
        if (this.keysInCirculation.containsKey(keyUUID) && this.keysInCirculation.get(keyUUID).getKey().equals(keyID) && this.keysInCirculation.get(keyUUID).getValue() >= amount) {
            if (this.keysInCirculation.get(keyUUID).getValue() == amount) {
                this.keysInCirculation.remove(keyUUID);
            } else {
                this.keysInCirculation.put(keyUUID, new AbstractMap.SimpleEntry<String, Integer>(keyID, this.keysInCirculation.get(keyUUID).getValue() - amount));
            }
            this.dirtyKeysInCirculation.add(keyUUID);
            return true;
        }
        return false;
    }

    public void runEffect(Effect effect, Location<World> location) {
        this.effects.add(new EffectInstance(effect, location));
    }

    public void runClientEffect(Effect effect, Location<World> location, Player player) {
        this.effects.add(new EffectInstance(effect, location, player));
    }

    public ArrayList<EffectInstance> getEffects() {
        return this.effects;
    }

    public void removeEffect(EffectInstance instance) {
        this.effects.remove(instance);
    }

    public boolean isKey(String id) {
        if (id.indexOf("LOCALKEY_") == 0 && this.crates.containsKey(id.replace("LOCALKEY_", ""))) {
            return this.crates.get(id.replace("LOCALKEY_", "")).hasLocalKey();
        }
        return this.keys.containsKey(id);
    }

    public boolean isCrate(String id) {
        return this.crates.containsKey(id);
    }

    public boolean isPhysicalCrate(Location<World> location) {
        return this.physicalCrates.containsKey(location);
    }

    public HashMap<String, Key> getAllKeys() {
        HashMap<String, Key> lkeys = this.getKeys();
        lkeys.putAll(this.getLocalKeys());
        return lkeys;
    }

    public HashMap<String, Key> getLocalKeys() {
        HashMap<String, Key> lkeys = new HashMap<String, Key>();
        for (Crate crate : this.crates.values()) {
            if (!crate.hasLocalKey()) continue;
            lkeys.put(crate.getLocalKey().getId(), crate.getLocalKey());
        }
        return lkeys;
    }

    public HashMap<String, Key> getKeys() {
        return this.keys;
    }

    public HashMap<String, Crate> getCrates() {
        return this.crates;
    }

    public void registerCrate(Crate crate) {
        if (this.isCrate(crate.getId())) {
            throw new DoubleRegistrationError("Crate with id " + crate.getId() + " already is registered");
        }
        this.crates.put(crate.getId(), crate);
    }

    public void registerKey(Key key) {
        if (this.isKey(key.getId())) {
            throw new DoubleRegistrationError("Key with id " + key.getId() + " already is registered");
        }
        this.keys.put(key.getId(), key);
    }

    public void registerPhysicalCrate(PhysicalCrate physicalCrate) {
        if (this.physicalCrates.containsKey(physicalCrate.getLocation())) {
            throw new DoubleRegistrationError("Crate is already located at " + physicalCrate.getLocation().toString());
        }
        this.physicalCrates.put(physicalCrate.getLocation(), physicalCrate);
        this.dirtyPhysicalCrates.add(physicalCrate.getLocation());
    }

    public void unregisterPhysicalCrate(Location<World> location) {
        this.physicalCrates.remove(location);
        this.dirtyPhysicalCrates.add(location);
    }

    public Long getLastUse(String crateID, UUID playerUUID) {
        if (this.lastCrateUse.containsKey(playerUUID) && this.lastCrateUse.get(playerUUID).containsKey(crateID)) {
            return this.lastCrateUse.get(playerUUID).get(crateID);
        }
        return null;
    }

    public boolean addVirtualKeys(UUID playerUUID, String keyID, Integer amount) {
        if (this.isKey(keyID)) {
            HashMap<String, Integer> balances;
            balances.put(keyID, (balances = this.virtualKeys.getOrDefault(playerUUID, new HashMap())).containsKey(keyID) ? amount + (Integer)balances.get(keyID) : amount);
            this.virtualKeys.put(playerUUID, balances);
            HashSet<String> ud = this.dirtyVirtualKeys.getOrDefault(playerUUID, new HashSet());
            ud.add(keyID);
            this.dirtyVirtualKeys.put(playerUUID, ud);
            return true;
        }
        return false;
    }

    public boolean removeVirtualKeys(UUID playerUUID, String keyID, Integer amount) {
        return this.addVirtualKeys(playerUUID, keyID, -amount.intValue());
    }

    public boolean setVirtualKeysNoDirty(UUID playerUUID, String keyID, Integer amount) {
        if (this.isKey(keyID)) {
            HashMap<String, Integer> balances = this.virtualKeys.getOrDefault(playerUUID, new HashMap());
            balances.put(keyID, amount);
            this.virtualKeys.put(playerUUID, balances);
            return true;
        }
        return false;
    }

    public boolean setVirtualKeys(UUID playerUUID, String keyID, Integer amount) {
        if (this.isKey(keyID)) {
            HashMap<String, Integer> balances = this.virtualKeys.getOrDefault(playerUUID, new HashMap());
            balances.put(keyID, amount);
            this.virtualKeys.put(playerUUID, balances);
            HashSet<String> ud = this.dirtyVirtualKeys.getOrDefault(playerUUID, new HashSet());
            ud.add(keyID);
            this.dirtyVirtualKeys.put(playerUUID, ud);
            return true;
        }
        return false;
    }

    public Integer getVirtualKeyBalance(UUID playerUUID, String keyID) {
        if (this.virtualKeys.containsKey(playerUUID) && this.virtualKeys.get(playerUUID).containsKey(keyID)) {
            return this.virtualKeys.get(playerUUID).get(keyID);
        }
        return 0;
    }

    public HashMap<String, Integer> getVirtualKeyBalances(UUID playerUUID) {
        if (this.virtualKeys.containsKey(playerUUID)) {
            return this.virtualKeys.get(playerUUID);
        }
        return new HashMap<String, Integer>();
    }

    public void updateLastUse(String crateID, UUID playerUUID) {
        HashMap<String, Long> userData = new HashMap<String, Long>();
        if (this.lastCrateUse.containsKey(playerUUID)) {
            userData = this.lastCrateUse.get(playerUUID);
        }
        userData.put(crateID, System.currentTimeMillis());
        this.lastCrateUse.put(playerUUID, userData);
        HashSet<String> modified = this.dirtyLastCrateUse.get(playerUUID);
        if (modified == null) {
            modified = new HashSet();
        }
        modified.add(crateID);
        this.dirtyLastCrateUse.put(playerUUID, modified);
    }

    public HashSet<Location<World>> getDirtyPhysicalCrates() {
        return this.dirtyPhysicalCrates;
    }

    public boolean cleanPhysicalCrate(Location<World> location) {
        return this.dirtyPhysicalCrates.remove(location);
    }

    public void cleanAll() {
        this.dirtyPhysicalCrates.clear();
        this.dirtyVirtualKeys.clear();
        this.dirtyKeysInCirculation.clear();
        this.dirtyLastCrateUse.clear();
    }

    public void clearRegistry() {
        this.clearConfigRegistry();
        this.clearDBRegistry();
        this.effects.forEach(effect -> effect.resetEffect());
        this.effects.clear();
    }

    public void clearConfigRegistry() {
        this.crates.clear();
        this.keys.clear();
    }

    public void clearDBRegistry() {
        this.physicalCrates.forEach((location, physicalCrate) -> physicalCrate.cleanup());
        this.physicalCrates.clear();
        this.dirtyPhysicalCrates.clear();
        this.keysInCirculation.clear();
        this.dirtyKeysInCirculation.clear();
        this.virtualKeys.clear();
        this.dirtyVirtualKeys.clear();
        this.lastCrateUse.clear();
        this.dirtyLastCrateUse.clear();
    }

    public void injectSlot(String crateID, Slot slot) {
        this.crates.get(crateID).injectSlot(slot);
    }

    public void postInjection() {
        this.crates.forEach((id, crate) -> crate.postInjectionChecks());
    }

    private Connection getConnection() {
        DataSource dbSource = null;
        try {
            dbSource = ((SqlService)Sponge.getServiceManager().provide(SqlService.class).get()).getDataSource("jdbc:h2:" + HuskyCrates.instance.configDir.resolve("storage/data"));
            Connection connection = dbSource.getConnection();
            boolean cP = connection.getMetaData().getTables(null, null, "CRATELOCATIONS", null).next();
            boolean cKU = connection.getMetaData().getTables(null, null, "VALIDKEYS", null).next();
            boolean kB = connection.getMetaData().getTables(null, null, "KEYBALANCES", null).next();
            boolean cD = connection.getMetaData().getTables(null, null, "LASTUSED", null).next();
            if (!cP) {
                connection.prepareStatement("CREATE TABLE CRATELOCATIONS (ID INTEGER NOT NULL AUTO_INCREMENT, X DOUBLE, Y DOUBLE, Z DOUBLE, worldUUID CHARACTER, isEntityCrate BOOLEAN, crateID CHARACTER,  PRIMARY KEY(ID))").executeUpdate();
            }
            if (!cKU) {
                connection.prepareStatement("CREATE TABLE VALIDKEYS (keyUUID CHARACTER, crateID CHARACTER, amount INTEGER )").executeUpdate();
            }
            if (!kB) {
                connection.prepareStatement("CREATE TABLE KEYBALANCES (userUUID CHARACTER, keyID CHARACTER, amount INTEGER)").executeUpdate();
            }
            if (!cD) {
                connection.prepareStatement("CREATE TABLE LASTUSED (userUUID CHARACTER, crateID CHARACTER, lastUsed BIGINT)").executeUpdate();
            }
            return connection;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Connection getVirtualKeySQLConnection() {
        DataSource dbSource = null;
        try {
            dbSource = ((SqlService)Sponge.getServiceManager().provide(SqlService.class).get()).getDataSource((Object)HuskyCrates.instance, Objects.requireNonNull(Util.getJDBC()));
            Connection connection = dbSource.getConnection();
            boolean kB = connection.getMetaData().getTables(null, null, "KEYBALANCES", null).next();
            if (!kB) {
                connection.prepareStatement("CREATE TABLE KEYBALANCES (userUUID CHAR(36), keyID CHAR(100), amount INT)").executeUpdate();
            }
            return connection;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Connection getAppropriateVirtualKeyConnection() {
        if (HuskyCrates.instance.virtualKeyDB) {
            return this.getVirtualKeySQLConnection();
        }
        return this.getConnection();
    }

    public void loadFromDatabase() {
        Connection connection = this.getConnection();
        Connection virtualKeyConnection = this.getAppropriateVirtualKeyConnection();
        if (connection == null || virtualKeyConnection == null) {
            HuskyCrates.instance.logger.error("SQL LOAD FAILURE");
            return;
        }
        HuskyCrates.instance.logger.info("Begin Database Load...");
        try {
            HuskyCrates.registry.clearDBRegistry();
            ResultSet physicalCrates = connection.prepareStatement("SELECT * FROM CRATELOCATIONS").executeQuery();
            while (physicalCrates.next()) {
                Location loco;
                World world;
                int id = physicalCrates.getInt("ID");
                double x = physicalCrates.getDouble("X");
                double y = physicalCrates.getDouble("Y");
                double z = physicalCrates.getDouble("Z");
                UUID worldUUID = UUID.fromString(physicalCrates.getString("worldUUID"));
                boolean entityCrate = physicalCrates.getBoolean("isEntityCrate");
                String crateID = physicalCrates.getString("crateID");
                if (Sponge.getServer().getWorld(worldUUID).isPresent() && this.isCrate(crateID)) {
                    world = (World)Sponge.getServer().getWorld(worldUUID).get();
                    loco = new Location((Extent)world, x, y, z);
                    if (loco.getBlock().getType().equals(BlockTypes.AIR)) {
                        this.dirtyPhysicalCrates.add((Location<World>)loco);
                        HuskyCrates.instance.logger.warn("CrateLocation #" + id + " provides a location where there is not a block. Flagging for removal.");
                        HologramInstance.cleanup((Location<World>)loco);
                        continue;
                    }
                    this.registerPhysicalCrate(new PhysicalCrate((Location<World>)loco, crateID, entityCrate));
                    HuskyCrates.instance.logger.info("Loaded " + crateID + " @ " + x + "," + y + "," + z + (entityCrate ? " (ENTITY CRATE)" : ""));
                    continue;
                }
                if (!this.isCrate(crateID) && Sponge.getServer().getWorld(worldUUID).isPresent()) {
                    world = (World)Sponge.getServer().getWorld(worldUUID).get();
                    loco = new Location((Extent)world, x, y, z);
                    HologramInstance.cleanup((Location<World>)loco);
                }
                HuskyCrates.instance.logger.warn("CrateLocation #" + id + " provides an invalid world UUID or invalid crate ID. Removing from table.");
                Statement removal = connection.createStatement();
                removal.executeQuery("SELECT  * FROM CRATELOCATIONS WHERE ID='" + id + "'");
                removal.executeUpdate("DELETE FROM CRATELOCATIONS");
                removal.close();
            }
            ResultSet crateKeyUUIDs = connection.prepareStatement("SELECT * FROM VALIDKEYS").executeQuery();
            while (crateKeyUUIDs.next()) {
                UUID keyUUID = UUID.fromString(crateKeyUUIDs.getString("keyUUID"));
                String crateID = crateKeyUUIDs.getString("crateID");
                int amount = crateKeyUUIDs.getInt("amount");
                if (this.isCrate(crateID) || this.isKey(crateID)) {
                    this.keysInCirculation.put(keyUUID, new AbstractMap.SimpleEntry<String, Integer>(crateID, amount));
                    continue;
                }
                HuskyCrates.instance.logger.warn("ValidKeys " + keyUUID + " provides an invalid crate ID. Removing from table.");
                Statement removal = connection.createStatement();
                removal.executeQuery("SELECT  * FROM VALIDKEYS WHERE KEYUUID='" + keyUUID.toString() + "'");
                removal.executeUpdate("DELETE FROM VALIDKEYS");
                removal.close();
            }
            ResultSet keyBalances = virtualKeyConnection.prepareStatement("SELECT * FROM KEYBALANCES").executeQuery();
            while (keyBalances.next()) {
                UUID userUUID = UUID.fromString(keyBalances.getString("userUUID"));
                String keyID = keyBalances.getString("keyID");
                int amount = keyBalances.getInt("amount");
                if (this.isKey(keyID)) {
                    HashMap<String, Integer> t = new HashMap<String, Integer>();
                    if (this.virtualKeys.containsKey(userUUID)) {
                        t = this.virtualKeys.get(userUUID);
                    }
                    t.put(keyID, amount);
                    this.virtualKeys.put(userUUID, t);
                    continue;
                }
                HuskyCrates.instance.logger.warn("A Key Balance for UUID " + userUUID + " provides an invalid key ID. Removing from table.");
                Statement removal = virtualKeyConnection.createStatement();
                removal.executeQuery("SELECT  * FROM KEYBALANCES WHERE USERUUID='" + userUUID.toString() + "'");
                removal.executeUpdate("DELETE FROM KEYBALANCES");
                removal.close();
            }
            ResultSet lastUses = connection.prepareStatement("SELECT * FROM LASTUSED").executeQuery();
            while (lastUses.next()) {
                UUID userUUID = UUID.fromString(lastUses.getString("userUUID"));
                String crateID = lastUses.getString("crateID");
                long lastUsed = lastUses.getLong("lastUsed");
                if (this.isCrate(crateID)) {
                    HashMap<String, Long> plu = this.lastCrateUse.containsKey(userUUID) ? this.lastCrateUse.get(userUUID) : new HashMap<String, Long>();
                    plu.put(crateID, lastUsed);
                    this.lastCrateUse.put(userUUID, plu);
                    continue;
                }
                HuskyCrates.instance.logger.warn("KeyBalances for UUID " + userUUID + " provides an invalid crate ID. Removing from table.");
                Statement removal = connection.createStatement();
                removal.executeQuery("SELECT  * FROM LASTUSED WHERE userUUID='" + userUUID.toString() + "' AND crateID='" + crateID + "'");
                removal.executeUpdate("DELETE FROM LASTUSED");
                removal.close();
            }
            connection.close();
            virtualKeyConnection.close();
            this.cleanAll();
            HuskyCrates.instance.logger.info("End Database Load.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            HuskyCrates.instance.logger.error("SQL LOAD QUERY FAILURE");
            try {
                connection.close();
                virtualKeyConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void pushDirtyVirtualKeys() {
        Connection virtualKeyConnection = this.getAppropriateVirtualKeyConnection();
        if (virtualKeyConnection == null) {
            HuskyCrates.instance.logger.error("SQL DIRTY PUSH FAILURE");
            return;
        }
        try {
            for (Map.Entry<UUID, HashSet<String>> entry : this.dirtyVirtualKeys.entrySet()) {
                UUID playerUUID = entry.getKey();
                for (String keyID : entry.getValue()) {
                    PreparedStatement statement = virtualKeyConnection.prepareStatement("SELECT * FROM KEYBALANCES WHERE userUUID = ? AND keyID = ?");
                    statement.setString(1, playerUUID.toString());
                    statement.setString(2, keyID);
                    ResultSet results = statement.executeQuery();
                    boolean exists = results.next();
                    if (!exists) {
                        PreparedStatement insertStatement = virtualKeyConnection.prepareStatement("INSERT INTO KEYBALANCES(userUUID,keyID,amount) VALUES(?,?,?)");
                        insertStatement.setString(1, playerUUID.toString());
                        insertStatement.setString(2, keyID);
                        insertStatement.setInt(3, this.virtualKeys.get(playerUUID).get(keyID));
                        insertStatement.executeUpdate();
                        continue;
                    }
                    PreparedStatement uState = virtualKeyConnection.prepareStatement("UPDATE KEYBALANCES SET amount = ? WHERE userUUID = ? AND keyID = ?");
                    uState.setInt(1, this.virtualKeys.get(playerUUID).get(keyID));
                    uState.setString(2, playerUUID.toString());
                    uState.setString(3, keyID);
                    uState.executeUpdate();
                }
            }
            virtualKeyConnection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            HuskyCrates.instance.logger.error("SQL DIRTY PUSH UPDATE FAILURE");
            try {
                virtualKeyConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.dirtyVirtualKeys.clear();
    }

    public void pushDirty() {
        if (this.dirtyKeysInCirculation.isEmpty() && this.dirtyVirtualKeys.isEmpty() && this.dirtyPhysicalCrates.isEmpty()) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            HuskyCrates.instance.logger.error("SQL DIRTY PUSH FAILURE");
            return;
        }
        HuskyCrates.instance.logger.info("Begin Dirty Data Push...");
        try {
            for (Location<World> location : this.dirtyPhysicalCrates) {
                if (this.physicalCrates.containsKey(location)) {
                    PreparedStatement statement = connection.prepareStatement("SELECT * FROM CRATELOCATIONS WHERE worldUUID = ? AND X = ? AND Y = ? AND Z = ? AND isEntityCrate = ?");
                    statement.setString(1, ((World)location.getExtent()).getUniqueId().toString());
                    statement.setDouble(2, location.getX());
                    statement.setDouble(3, location.getY());
                    statement.setDouble(4, location.getZ());
                    statement.setBoolean(5, this.physicalCrates.get(location).isEntity());
                    ResultSet results = statement.executeQuery();
                    boolean exists = results.next();
                    if (exists) continue;
                    PreparedStatement updateStatement = connection.prepareStatement("INSERT INTO CRATELOCATIONS(X,Y,Z,worldUUID,isEntityCrate,crateID) VALUES(?,?,?,?,?,?)");
                    updateStatement.setDouble(1, location.getX());
                    updateStatement.setDouble(2, location.getY());
                    updateStatement.setDouble(3, location.getZ());
                    updateStatement.setString(4, ((World)location.getExtent()).getUniqueId().toString());
                    updateStatement.setBoolean(5, this.physicalCrates.get(location).isEntity());
                    updateStatement.setString(6, this.physicalCrates.get(location).getCrate().getId());
                    updateStatement.executeUpdate();
                    continue;
                }
                PreparedStatement delState = connection.prepareStatement("DELETE FROM CRATELOCATIONS WHERE worldUUID = ? AND X = ? AND Y = ? AND Z = ?");
                delState.setString(1, ((World)location.getExtent()).getUniqueId().toString());
                delState.setDouble(2, location.getX());
                delState.setDouble(3, location.getY());
                delState.setDouble(4, location.getZ());
                delState.executeUpdate();
            }
            this.dirtyPhysicalCrates.clear();
            this.pushDirtyVirtualKeys();
            for (UUID uUID : this.dirtyKeysInCirculation) {
                if (this.keysInCirculation.containsKey(uUID)) {
                    int amount = this.keysInCirculation.get(uUID).getValue();
                    PreparedStatement statement = connection.prepareStatement("SELECT * FROM VALIDKEYS WHERE keyUUID = ?");
                    statement.setString(1, uUID.toString());
                    ResultSet results = statement.executeQuery();
                    boolean exists = results.next();
                    if (exists) {
                        PreparedStatement uState = connection.prepareStatement("UPDATE VALIDKEYS SET amount = ? WHERE keyUUID = ?");
                        uState.setInt(1, amount);
                        uState.setString(2, uUID.toString());
                        uState.executeUpdate();
                        continue;
                    }
                    PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO VALIDKEYS(keyUUID,crateID,amount) VALUES(?,?,?)");
                    insertStatement.setString(1, uUID.toString());
                    insertStatement.setString(2, this.keysInCirculation.get(uUID).getKey());
                    insertStatement.setInt(3, amount);
                    insertStatement.executeUpdate();
                    continue;
                }
                PreparedStatement delState = connection.prepareStatement("DELETE FROM VALIDKEYS WHERE keyUUID = ?");
                delState.setString(1, uUID.toString());
                delState.executeUpdate();
            }
            this.dirtyKeysInCirculation.clear();
            for (Map.Entry entry : this.dirtyLastCrateUse.entrySet()) {
                UUID playerUUID = (UUID)entry.getKey();
                for (String crateID : (HashSet)entry.getValue()) {
                    PreparedStatement statement = connection.prepareStatement("SELECT * FROM LASTUSED  WHERE userUUID = ? AND crateID = ?");
                    statement.setString(1, playerUUID.toString());
                    statement.setString(2, crateID);
                    ResultSet results = statement.executeQuery();
                    boolean exists = results.next();
                    if (exists) {
                        PreparedStatement uState = connection.prepareStatement("UPDATE LASTUSED  SET lastUsed = ? WHERE userUUID = ? AND crateID = ?");
                        uState.setLong(1, this.lastCrateUse.get(playerUUID).get(crateID));
                        uState.setString(2, playerUUID.toString());
                        uState.setString(3, crateID);
                        uState.executeUpdate();
                        continue;
                    }
                    PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO LASTUSED(userUUID,crateID,lastUsed) VALUES(?,?,?)");
                    insertStatement.setString(1, playerUUID.toString());
                    insertStatement.setString(2, crateID);
                    insertStatement.setLong(3, this.lastCrateUse.get(playerUUID).get(crateID));
                    insertStatement.executeUpdate();
                }
            }
            connection.close();
            HuskyCrates.instance.logger.info("End Dirty Data Push.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            HuskyCrates.instance.logger.error("SQL DIRTY PUSH UPDATE FAILURE");
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

