/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.command;

import com.codehusky.huskycrates.HuskyCrates;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;

public class BalanceCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        UUID balanceToUse;
        Optional user = args.getOne((Text)Text.of((String)"player"));
        Optional uuid = args.getOne((Text)Text.of((String)"uuid"));
        Optional username = args.getOne((Text)Text.of((String)"username"));
        UUID uUID = balanceToUse = src instanceof Player ? ((Player)src).getUniqueId() : null;
        if (user.isPresent()) {
            if (!src.hasPermission("huskycrates.bal.others")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to view the balance of others."}));
                return CommandResult.success();
            }
            src.sendMessage(HuskyCrates.balanceCommandMessages.getOtherBalanceHeader(((User)user.get()).getName()));
        } else if (uuid.isPresent()) {
            if (!src.hasPermission("huskycrates.bal.others")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to view the balance of others."}));
                return CommandResult.success();
            }
            src.sendMessage(HuskyCrates.balanceCommandMessages.getUUIDBalanceHeader(((UUID)uuid.get()).toString()));
        } else {
            if (username.isPresent()) {
                if (!src.hasPermission("huskycrates.bal.others")) {
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to view the balance of others."}));
                    return CommandResult.success();
                }
                src.sendMessage(HuskyCrates.balanceCommandMessages.getUserNotExist((String)username.get()));
                return CommandResult.success();
            }
            src.sendMessage(HuskyCrates.balanceCommandMessages.getSelfBalanceHeader());
        }
        if (balanceToUse == null) {
            src.sendMessage(HuskyCrates.balanceCommandMessages.getNoValidUser());
            return CommandResult.success();
        }
        HashMap<String, Integer> balances = HuskyCrates.registry.getVirtualKeyBalances(balanceToUse);
        for (Map.Entry<String, Integer> entry : balances.entrySet()) {
            String keyID = entry.getKey();
            src.sendMessage(HuskyCrates.balanceCommandMessages.getBalanceRow(HuskyCrates.registry.getKey(keyID).getName(), keyID, entry.getValue()));
        }
        if (balances.size() == 0) {
            src.sendMessage(HuskyCrates.balanceCommandMessages.getNoBalanceEntries());
        }
        return CommandResult.success();
    }

    public static class Messages {
        private String balanceRow;
        private String otherBalanceHeader;
        private String uuidBalanceHeader;
        private String selfBalanceHeader;
        private String userNotExist;
        private String noValidUser;
        private String noBalanceEntries;

        public Messages(ConfigurationNode node) {
            this.balanceRow = node.getNode(new Object[]{"balanceRow"}).getString("&7 - {key}&r&7: &a{amount}");
            this.otherBalanceHeader = node.getNode(new Object[]{"otherBalanceHeader"}).getString("&6{player}'s Key Balances");
            this.uuidBalanceHeader = node.getNode(new Object[]{"uuidBalanceHeader"}).getString("&2Balance for {uuid}");
            this.selfBalanceHeader = node.getNode(new Object[]{"selfBalanceHeader"}).getString("&3Your Key Balances");
            this.userNotExist = node.getNode(new Object[]{"userNotExist"}).getString("&c{username} has never logged into this server.");
            this.noValidUser = node.getNode(new Object[]{"noValidUser"}).getString("&cNo valid user found to list the balance of.");
            this.noBalanceEntries = node.getNode(new Object[]{"noBalanceEntries"}).getString("&7This user has no balances.");
        }

        public Text getBalanceRow(String keyName, String keyID, int amount) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.balanceRow.replace("{key}", keyName).replace("{key.id}", keyID).replace("{amount}", "" + amount).replace("{amount.plural}", amount != 1 ? "s" : ""));
        }

        public Text getOtherBalanceHeader(String playerName) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.otherBalanceHeader.replace("{player}", playerName));
        }

        public Text getSelfBalanceHeader() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.selfBalanceHeader);
        }

        public Text getUserNotExist(String username) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.userNotExist.replace("{username}", username));
        }

        public Text getUUIDBalanceHeader(String uuid) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.uuidBalanceHeader.replace("{uuid}", uuid));
        }

        public Text getNoValidUser() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.noValidUser);
        }

        public Text getNoBalanceEntries() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.noBalanceEntries);
        }
    }
}

