/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.command;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.command.BalanceCommand;
import com.codehusky.huskycrates.command.BlockCommand;
import com.codehusky.huskycrates.command.CrateGenerateCommand;
import com.codehusky.huskycrates.command.InventoryGenerateCommand;
import com.codehusky.huskycrates.command.ItemGenerateCommand;
import com.codehusky.huskycrates.command.ItemNBTCommand;
import com.codehusky.huskycrates.command.KeyCommand;
import com.codehusky.huskycrates.command.MainCommand;
import com.codehusky.huskycrates.command.OpenCommand;
import com.codehusky.huskycrates.command.ReloadCommand;
import com.codehusky.huskycrates.command.WandCommand;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;

public class CommandRegister {
    public static void register(HuskyCrates plugin) {
        CommandSpec mainCommand = CommandSpec.builder().child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new BlockCommand()).arguments(new CommandElement[]{new CrateArgument((Text)Text.of((String)"crate")), GenericArguments.optionalWeak((CommandElement)GenericArguments.catalogedElement((Text)Text.of((String)"block"), BlockType.class)), GenericArguments.optionalWeak((CommandElement)GenericArguments.player((Text)Text.of((String)"player"))), GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"amount"))), GenericArguments.optional((CommandElement)GenericArguments.integer((Text)Text.of((String)"damage")))}).permission("huskycrates.block.base").build(), new String[]{"b", "blk", "block", "chest"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new WandCommand()).arguments(new CommandElement[]{new CrateArgument((Text)Text.of((String)"crate")), GenericArguments.optionalWeak((CommandElement)GenericArguments.player((Text)Text.of((String)"player")))}).permission("huskycrates.wand.base").build(), new String[]{"w", "wand"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new KeyCommand()).arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.literal((Text)Text.of((String)"virtual"), (String[])new String[]{"v"})), GenericArguments.firstParsing((CommandElement[])new CommandElement[]{new CrateArgument((Text)Text.of((String)"crate")), new KeyArgument((Text)Text.of((String)"key"))}), GenericArguments.optional((CommandElement)GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.literal((Text)Text.of((String)"all"), (String[])new String[]{"@a"}), GenericArguments.player((Text)Text.of((String)"player"))})), GenericArguments.optionalWeak((CommandElement)GenericArguments.integer((Text)Text.of((String)"amount")))}).permission("huskycrates.key.base").build(), new String[]{"k", "key"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new OpenCommand()).arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.literal((Text)Text.of((String)"keyless"), (String[])new String[]{"nokey"})), new CrateArgument((Text)Text.of((String)"crate")), GenericArguments.optional((CommandElement)GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.literal((Text)Text.of((String)"all"), (String[])new String[]{"@a"}), GenericArguments.player((Text)Text.of((String)"player"))}))}).permission("huskycrates.open.base").build(), new String[]{"o", "open", "use"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new BalanceCommand()).arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.user((Text)Text.of((String)"player"))), GenericArguments.optionalWeak((CommandElement)GenericArguments.uuid((Text)Text.of((String)"uuid"))), GenericArguments.optionalWeak((CommandElement)GenericArguments.string((Text)Text.of((String)"username")))}).permission("huskycrates.bal.base").build(), new String[]{"bal", "balance"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new ReloadCommand()).permission("huskycrates.reload").build(), new String[]{"rl", "r", "reload"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new ItemNBTCommand()).permission("huskycrates.admin").build(), new String[]{"itemnbt", "nbt", "in"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new ItemGenerateCommand()).permission("huskycrates.admin").build(), new String[]{"genitem", "generateitem", "gitem"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new InventoryGenerateCommand()).permission("huskycrates.admin").build(), new String[]{"geninvent", "generateinventory", "ginv"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new CrateGenerateCommand()).permission("huskycrates.admin").arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"name")), GenericArguments.choices((Text)Text.of((String)"type"), (Map)ImmutableMap.builder().put((Object)"item", (Object)"item").put((Object)"inventory", (Object)"inventory").build())}).build(), new String[]{"gencrate", "generatecrate", "gcrate"}).child((CommandCallable)CommandSpec.builder().executor((CommandExecutor)new MainCommand()).build(), new String[]{"h", "help"}).executor((CommandExecutor)new MainCommand()).description((Text)Text.of((String)"Main HuskyCrates Command.")).extendedDescription((Text)Text.of((String)"For more information on the commands you can use with HuskyCrates, please visit the HuskyCrates documentation.\nYou can find a link to the documentation within /hc help.")).build();
        if (Sponge.getCommandManager().get("crate").isPresent() && HuskyCrates.FORCE_CRATE_CMD) {
            Sponge.getCommandManager().removeMapping((CommandMapping)Sponge.getCommandManager().get("crate").get());
            Sponge.getCommandManager().register((Object)plugin, (CommandCallable)mainCommand, new String[]{"crate"});
        }
        Sponge.getCommandManager().register((Object)plugin, (CommandCallable)mainCommand, new String[]{"hc", "husky", "huskycrates"});
    }

    public static class KeyArgument
    extends CommandElement {
        public KeyArgument(@Nullable Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (HuskyCrates.registry.isKey(args.peek())) {
                return HuskyCrates.registry.getKey(args.next());
            }
            throw args.createError((Text)Text.of((String)("\"" + args.next() + "\" is not a valid key.")));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                if (HuskyCrates.registry.isKey(args.peek())) {
                    return Collections.singletonList(args.next());
                }
                ArrayList<String> poss = new ArrayList<String>();
                for (String crateID : HuskyCrates.registry.getKeys().keySet()) {
                    if (crateID.indexOf(args.peek()) != 0) continue;
                    poss.add(crateID);
                }
                args.next();
                return poss;
            }
            catch (ArgumentParseException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    public static class CrateArgument
    extends CommandElement {
        public CrateArgument(@Nullable Text key) {
            super(key);
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            if (HuskyCrates.registry.isCrate(args.peek())) {
                return HuskyCrates.registry.getCrate(args.next());
            }
            throw args.createError((Text)Text.of((String)("\"" + args.next() + "\" is not a valid crate.")));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                if (HuskyCrates.registry.isCrate(args.peek())) {
                    return Collections.singletonList(args.next());
                }
                ArrayList<String> poss = new ArrayList<String>();
                for (String crateID : HuskyCrates.registry.getCrates().keySet()) {
                    if (crateID.indexOf(args.peek()) != 0) continue;
                    poss.add(crateID);
                }
                args.next();
                return poss;
            }
            catch (ArgumentParseException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }
}

