/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.command;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.virtual.Item;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class CrateGenerateCommand
implements CommandExecutor {
    public Map<Integer, ItemStack> inventory = new HashMap<Integer, ItemStack>();

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        block26: {
            if (src instanceof Player) {
                Player player = (Player)src;
                Inventory playerInventory = Util.getHotbarFirst((Inventory)player.getInventory());
                String genType = (String)args.getOne("type").get();
                String name = (String)args.getOne("name").get();
                Path newCratePath = HuskyCrates.instance.crateDirectoryPath.resolve(name + ".crate");
                if (newCratePath.toFile().exists()) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Crate file already exists with this name!"}));
                } else {
                    ArrayList slots;
                    CommentedConfigurationNode n1;
                    CommentedConfigurationNode n;
                    CommentedConfigurationNode root;
                    HoconConfigurationLoader generatedCrateConfig;
                    block25: {
                        if (genType.equals("inventory")) {
                            if (playerInventory.size() != 0) {
                                try {
                                    if (!newCratePath.toFile().createNewFile()) break block25;
                                    generatedCrateConfig = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(newCratePath.toAbsolutePath())).build();
                                    try {
                                        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "Attempting to generate a crate from your inventory..."}));
                                        int items = 0;
                                        root = (CommentedConfigurationNode)generatedCrateConfig.load();
                                        n = root.getNode(new Object[]{name});
                                        n.getNode(new Object[]{"name"}).setValue((Object)name);
                                        n.getNode(new Object[]{"free"}).setValue((Object)false);
                                        n1 = n.getNode(new Object[]{"slots"});
                                        slots = new ArrayList();
                                        for (Inventory slot : playerInventory.slots()) {
                                            Optional itemslot = slot.peek();
                                            if (!itemslot.isPresent()) continue;
                                            Item item = Item.fromItemStack((ItemStack)itemslot.get());
                                            HashMap<String, Serializable> mapA = new HashMap<String, Serializable>();
                                            mapA.put("chance", Double.valueOf(10.0));
                                            HashMap<String, Object> displayItem = new HashMap<String, Object>();
                                            displayItem.put("id", item.getItemType().getName());
                                            displayItem.put("name", item.getName());
                                            displayItem.put("count", item.getCount());
                                            displayItem.put("damage", item.getDamage());
                                            displayItem.put("durability", item.getDurability());
                                            if (item.getLore() != null && item.getLore().size() > 0) {
                                                displayItem.put("lore", item.getLore());
                                            }
                                            if (item.getEnchantments() != null && item.getEnchantments().size() > 0) {
                                                HashMap enchants = new HashMap();
                                                item.getEnchantments().forEach(enchantment -> enchants.put(enchantment.getType().getId(), enchantment.getLevel()));
                                                displayItem.put("enchantments", enchants);
                                            }
                                            if (item.getNBT() != null && item.getNBT().size() > 0) {
                                                displayItem.put("nbt", item.getNBT());
                                            }
                                            ArrayList rewards = new ArrayList();
                                            HashMap<String, String> reward1 = new HashMap<String, String>();
                                            reward1.put("type", "item");
                                            rewards.add(reward1);
                                            mapA.put("displayItem", displayItem);
                                            mapA.put("rewards", rewards);
                                            slots.add(mapA);
                                            generatedCrateConfig.save((ConfigurationNode)root);
                                            ++items;
                                        }
                                        n1.setValue(slots);
                                        ArrayList<String> hologramLines = new ArrayList<String>();
                                        hologramLines.add("&a" + name);
                                        hologramLines.add("&aCrate");
                                        n.getNode(new Object[]{"hologram"}).getNode(new Object[]{"lines"}).setValue(hologramLines);
                                        n.getNode(new Object[]{"hologram"}).getNode(new Object[]{"entityYOffset"}).setValue((Object)0.0);
                                        n.getNode(new Object[]{"viewType"}).setValue((Object)"spinner");
                                        HashMap<String, Number> viewConfig = new HashMap<String, Number>();
                                        viewConfig.put("tickDelayMultiplier", 1.025);
                                        viewConfig.put("ticksToSelection", 75);
                                        viewConfig.put("ticksToSelectionVariance", 5);
                                        n.getNode(new Object[]{"viewConfig"}).setValue(viewConfig);
                                        n.getNode(new Object[]{"localKey"}).getNode(new Object[]{"id"}).setValue((Object)"minecraft:tripwire_hook");
                                        n.getNode(new Object[]{"localKey"}).getNode(new Object[]{"name"}).setValue((Object)("&a" + name + " Crate Key"));
                                        n.getNode(new Object[]{"previewable"}).setValue((Object)true);
                                        n.getNode(new Object[]{"useLocalKey"}).setValue((Object)true);
                                        n.getNode(new Object[]{"messages"}).getNode(new Object[]{"rejectionNeedKey"}).setValue((Object)"&cYou lack the key needed to open this crate!");
                                        generatedCrateConfig.save((ConfigurationNode)root);
                                        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully generated a crate with " + items + " items, with the name " + name}));
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to generate a crate! Error has been printed to your console/logs!"}));
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    HuskyCrates.instance.logger.error("Failed to create crate file!");
                                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to create crate file!"}));
                                }
                            } else {
                                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Your inventory has no items in it! You must have atleast 1 item present within your primary 36 inventory slots to use this generation option!"}));
                            }
                        }
                    }
                    if (genType.equals("item")) {
                        if (player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
                            try {
                                if (!newCratePath.toFile().createNewFile()) break block26;
                                generatedCrateConfig = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(newCratePath.toAbsolutePath())).build();
                                try {
                                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "Attempting to generate a crate from your held item..."}));
                                    Item item = Item.fromItemStack((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get());
                                    root = (CommentedConfigurationNode)generatedCrateConfig.load();
                                    n = root.getNode(new Object[]{name});
                                    n.getNode(new Object[]{"name"}).setValue((Object)name);
                                    n.getNode(new Object[]{"free"}).setValue((Object)false);
                                    n1 = n.getNode(new Object[]{"slots"});
                                    slots = new ArrayList();
                                    HashMap<String, Serializable> mapA = new HashMap<String, Serializable>();
                                    mapA.put("chance", Double.valueOf(10.0));
                                    HashMap<String, Object> displayItem = new HashMap<String, Object>();
                                    displayItem.put("id", item.getItemType().getName());
                                    displayItem.put("name", item.getName());
                                    displayItem.put("count", item.getCount());
                                    displayItem.put("damage", item.getDamage());
                                    displayItem.put("durability", item.getDurability());
                                    if (item.getLore() != null && item.getLore().size() > 0) {
                                        displayItem.put("lore", item.getLore());
                                    }
                                    if (item.getEnchantments() != null && item.getEnchantments().size() > 0) {
                                        HashMap enchants = new HashMap();
                                        item.getEnchantments().forEach(enchantment -> enchants.put(enchantment.getType().getId(), enchantment.getLevel()));
                                        displayItem.put("enchantments", enchants);
                                    }
                                    if (item.getNBT() != null && item.getNBT().size() > 0) {
                                        displayItem.put("nbt", item.getNBT());
                                    }
                                    ArrayList rewards = new ArrayList();
                                    HashMap<String, String> reward1 = new HashMap<String, String>();
                                    reward1.put("type", "item");
                                    rewards.add(reward1);
                                    mapA.put("displayItem", displayItem);
                                    mapA.put("rewards", rewards);
                                    slots.add(mapA);
                                    generatedCrateConfig.save((ConfigurationNode)root);
                                    n1.setValue(slots);
                                    ArrayList<String> hologramLines = new ArrayList<String>();
                                    hologramLines.add("&a" + name);
                                    hologramLines.add("&aCrate");
                                    n.getNode(new Object[]{"hologram"}).getNode(new Object[]{"lines"}).setValue(hologramLines);
                                    n.getNode(new Object[]{"hologram"}).getNode(new Object[]{"entityYOffset"}).setValue((Object)0.0);
                                    n.getNode(new Object[]{"viewType"}).setValue((Object)"spinner");
                                    HashMap<String, Number> viewConfig = new HashMap<String, Number>();
                                    viewConfig.put("tickDelayMultiplier", 1.025);
                                    viewConfig.put("ticksToSelection", 75);
                                    viewConfig.put("ticksToSelectionVariance", 5);
                                    n.getNode(new Object[]{"viewConfig"}).setValue(viewConfig);
                                    n.getNode(new Object[]{"localKey"}).getNode(new Object[]{"id"}).setValue((Object)"minecraft:tripwire_hook");
                                    n.getNode(new Object[]{"localKey"}).getNode(new Object[]{"name"}).setValue((Object)("&a" + name + " Crate Key"));
                                    n.getNode(new Object[]{"previewable"}).setValue((Object)true);
                                    n.getNode(new Object[]{"useLocalKey"}).setValue((Object)true);
                                    n.getNode(new Object[]{"messages"}).getNode(new Object[]{"rejectionNeedKey"}).setValue((Object)"&cYou lack the key needed to open this crate!");
                                    generatedCrateConfig.save((ConfigurationNode)root);
                                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Successfully generated a crate with 1 item, and the name " + name}));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to generate a crate! Error has been printed to your console/logs!"}));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                HuskyCrates.instance.logger.error("Failed to create crate file!");
                                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to create crate file!"}));
                            }
                        } else {
                            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You're not holding an item! You must be holding an item to use this generation option!"}));
                        }
                    }
                }
            } else {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to use this command."}));
            }
        }
        return CommandResult.success();
    }
}

