/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.command;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.virtual.Item;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class InventoryGenerateCommand
implements CommandExecutor {
    public Map<Integer, ItemStack> inventory = new HashMap<Integer, ItemStack>();

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (src instanceof Player) {
            Player player = (Player)src;
            Inventory playerInventory = Util.getHotbarFirst((Inventory)player.getInventory());
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "Attempting to generate items based on your inventory..."}));
            if (playerInventory.size() == 0) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Your inventory must have an item in it to use this command!"}));
            } else {
                this.inventory = new HashMap<Integer, ItemStack>();
                int i = 0;
                for (Inventory slot : playerInventory.slots()) {
                    Optional itemslot = slot.peek();
                    if (itemslot.isPresent()) {
                        Item item = Item.fromItemStack((ItemStack)itemslot.get());
                        try {
                            String uuid = UUID.randomUUID().toString();
                            CommentedConfigurationNode root = (CommentedConfigurationNode)HuskyCrates.instance.generatedInventoryConfig.load();
                            CommentedConfigurationNode n = root.getNode(new Object[]{uuid});
                            n.getNode(new Object[]{"id"}).setValue((Object)item.getItemType().getName());
                            n.getNode(new Object[]{"name"}).setValue((Object)item.getName());
                            n.getNode(new Object[]{"count"}).setValue((Object)item.getCount());
                            n.getNode(new Object[]{"damage"}).setValue((Object)item.getDamage());
                            n.getNode(new Object[]{"durability"}).setValue((Object)item.getDurability());
                            if (item.getLore() != null && item.getLore().size() > 0) {
                                n.getNode(new Object[]{"lore"}).setValue(item.getLore());
                            }
                            if (item.getEnchantments() != null && item.getEnchantments().size() > 0) {
                                CommentedConfigurationNode en = n.getNode(new Object[]{"enchantments"});
                                item.getEnchantments().forEach(arg_0 -> InventoryGenerateCommand.lambda$execute$0((ConfigurationNode)en, arg_0));
                            }
                            if (item.getNBT() != null && item.getNBT().size() > 0) {
                                n.getNode(new Object[]{"nbt"}).setValue((Object)item.getNBT());
                            }
                            HuskyCrates.instance.generatedInventoryConfig.save((ConfigurationNode)root);
                            src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Item saved as UUID " + uuid + "."}));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        } else {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to use this command."}));
        }
        return CommandResult.success();
    }

    private static /* synthetic */ void lambda$execute$0(ConfigurationNode en, Enchantment enchantment) {
        en.getNode(new Object[]{enchantment.getType().getId()}).setValue((Object)enchantment.getLevel());
    }
}

