/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.command;

import java.io.IOException;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;

public class ItemNBTCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (src instanceof Player) {
            Player player = (Player)src;
            if (player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
                ItemStack stack = (ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get();
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "---- ITEM NBT ----"}));
                String beep = null;
                try {
                    beep = DataFormats.HOCON.write((DataView)stack.toContainer().get(DataQuery.of((String[])new String[]{"UnsafeData"})).get());
                    src.sendMessage((Text)Text.of((String)TextSerializers.LEGACY_FORMATTING_CODE.replaceCodes(beep, '&')));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "No custom NBT is present on this item."}));
                }
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.GRAY, "---- ITEM NBT ----"}));
            } else {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be holding an item to use this command."}));
            }
        } else {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You must be a player to use this command."}));
        }
        return CommandResult.success();
    }
}

