/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.command;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Key;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;

public class KeyCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        String keyName;
        Optional crate = args.getOne((Text)Text.of((String)"crate"));
        Optional key = args.getOne((Text)Text.of((String)"key"));
        Optional pamount = args.getOne((Text)Text.of((String)"amount"));
        boolean isVirtual = args.getOne((Text)Text.of((String)"virtual")).isPresent();
        Optional player = args.getOne((Text)Text.of((String)"player"));
        Optional all = args.getOne((Text)Text.of((String)"all"));
        Key workingWith = null;
        if (isVirtual && !src.hasPermission("huskycrates.key.virtual")) {
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to give out virtual keys."}));
            return CommandResult.success();
        }
        if (crate.isPresent()) {
            if (((Crate)crate.get()).hasLocalKey()) {
                workingWith = ((Crate)crate.get()).getLocalKey();
            }
        } else if (key.isPresent()) {
            workingWith = (Key)key.get();
        }
        if (workingWith == null) {
            src.sendMessage(HuskyCrates.keyCommandMessages.getCrateNoLocalKey());
            return CommandResult.success();
        }
        if (workingWith.isVirtual().booleanValue() && !isVirtual) {
            src.sendMessage(HuskyCrates.keyCommandMessages.getCrateKeyVirtual());
            return CommandResult.success();
        }
        int amount = pamount.orElse(1);
        String string = keyName = crate.isPresent() ? ((Crate)crate.get()).getName() : ((Key)key.get()).getName();
        if (all.isPresent()) {
            if (!src.hasPermission("huskycrates.key.all")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to give everyone keys."}));
                return CommandResult.success();
            }
            int deliveredTo = 0;
            for (Player p : Sponge.getServer().getOnlinePlayers()) {
                InventoryTransactionResult result = null;
                if (!isVirtual) {
                    result = Util.getHotbarFirst((Inventory)p.getInventory()).offer(workingWith.getKeyItemStack(amount));
                } else {
                    HuskyCrates.registry.addVirtualKeys(p.getUniqueId(), workingWith.getId(), amount);
                }
                if (!isVirtual && result.getType() != InventoryTransactionResult.Type.SUCCESS) {
                    src.sendMessage(HuskyCrates.keyCommandMessages.getKeyDeliveryFail(p.getName(), amount));
                    continue;
                }
                p.sendMessage(HuskyCrates.keyCommandMessages.getReceivedKey(keyName, amount));
                ++deliveredTo;
            }
            src.sendMessage(HuskyCrates.keyCommandMessages.getMassKeyDeliverySuccess(deliveredTo, amount));
        } else if (player.isPresent()) {
            if (!src.hasPermission("huskycrates.key.others")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to give others keys."}));
                return CommandResult.success();
            }
            InventoryTransactionResult result = null;
            if (!isVirtual) {
                result = Util.getHotbarFirst((Inventory)((Player)player.get()).getInventory()).offer(workingWith.getKeyItemStack(amount));
            } else {
                HuskyCrates.registry.addVirtualKeys(((Player)player.get()).getUniqueId(), workingWith.getId(), amount);
            }
            if (!isVirtual && result.getType() != InventoryTransactionResult.Type.SUCCESS) {
                src.sendMessage(HuskyCrates.keyCommandMessages.getKeyDeliveryFail(((Player)player.get()).getName(), amount));
            } else {
                ((Player)player.get()).sendMessage(HuskyCrates.keyCommandMessages.getReceivedKey(keyName, amount));
                src.sendMessage(HuskyCrates.keyCommandMessages.getKeyDeliverySuccess(((Player)player.get()).getName(), amount));
            }
        } else if (src instanceof Player) {
            if (!src.hasPermission("huskycrates.key.self")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to give yourself keys."}));
                return CommandResult.success();
            }
            Player psrc = (Player)src;
            InventoryTransactionResult result = null;
            if (!isVirtual) {
                result = Util.getHotbarFirst((Inventory)psrc.getInventory()).offer(workingWith.getKeyItemStack(amount));
            } else {
                HuskyCrates.registry.addVirtualKeys(psrc.getUniqueId(), workingWith.getId(), amount);
            }
            if (!isVirtual && result.getType() != InventoryTransactionResult.Type.SUCCESS) {
                src.sendMessage(HuskyCrates.keyCommandMessages.getSelfKeyDeliveryFail());
            } else {
                src.sendMessage(HuskyCrates.keyCommandMessages.getSelfKeyDeliverySuccess(amount));
            }
        } else {
            src.sendMessage(HuskyCrates.keyCommandMessages.getNoPlayersFound());
        }
        return CommandResult.success();
    }

    public static class Messages {
        private String crateNoLocalKey;
        private String crateKeyVirtual;
        private String receivedKey;
        private String keyDeliveryFail;
        private String massKeyDeliverySuccess;
        private String keyDeliverySuccess;
        private String selfKeyDeliveryFail;
        private String selfKeyDeliverySuccess;
        private String noPlayersFound;

        public Messages(ConfigurationNode node) {
            this.crateNoLocalKey = node.getNode(new Object[]{"crateNoLocalKey"}).getString("&cThe supplied crate did not have a local key.");
            this.crateKeyVirtual = node.getNode(new Object[]{"crateKeyVirtual"}).getString("&cThe resolved key is virtual only. Please supply a key that can be a physical item, or use the \"v\" flag.");
            this.receivedKey = node.getNode(new Object[]{"receivedKey"}).getString("&aYou received {amount} {key}{amount.plural}&r!");
            this.keyDeliveryFail = node.getNode(new Object[]{"keyDeliveryFail"}).getString("&c{player} failed to receive their {amount} key{amount.plural}!");
            this.massKeyDeliverySuccess = node.getNode(new Object[]{"massKeyDeliverySuccess"}).getString("&a{playerAmount} player{playerAmount.plural} received {amount} key{amount.plural}.");
            this.keyDeliverySuccess = node.getNode(new Object[]{"keyDeliverySuccess"}).getString("&a{player} received {amount} key{amount.plural}.");
            this.selfKeyDeliveryFail = node.getNode(new Object[]{"selfKeyDeliveryFail"}).getString("&cFailed to give you keys!");
            this.selfKeyDeliverySuccess = node.getNode(new Object[]{"selfKeyDeliverySuccess"}).getString("&aYou were given {amount} key{amount.plural}.");
            this.noPlayersFound = node.getNode(new Object[]{"noPlayersFound"}).getString("No valid players could be found to deliver keys to.");
        }

        public Text getCrateKeyVirtual() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.crateKeyVirtual);
        }

        public Text getCrateNoLocalKey() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.crateNoLocalKey);
        }

        public Text getKeyDeliveryFail(String playerName, Integer amount) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.keyDeliveryFail.replace("{player}", playerName).replace("{amount}", amount.toString()).replace("{amount.plural}", amount != 1 ? "s" : ""));
        }

        public Text getKeyDeliverySuccess(String playerName, Integer amount) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.keyDeliverySuccess.replace("{player}", playerName).replace("{amount}", amount.toString()).replace("{amount.plural}", amount != 1 ? "s" : ""));
        }

        public Text getMassKeyDeliverySuccess(Integer playerAmount, Integer amount) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.massKeyDeliverySuccess.replace("{playerAmount}", playerAmount.toString()).replace("{playerAmount.plural}", playerAmount != 1 ? "s" : "").replace("{amount}", amount.toString()).replace("{amount.plural}", amount != 1 ? "s" : ""));
        }

        public Text getNoPlayersFound() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.noPlayersFound);
        }

        public Text getReceivedKey(String keyName, Integer amount) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.receivedKey.replace("{key}", keyName).replace("{amount}", amount.toString()).replace("{amount.plural}", amount != 1 ? "s" : ""));
        }

        public Text getSelfKeyDeliveryFail() {
            return TextSerializers.FORMATTING_CODE.deserialize(this.selfKeyDeliveryFail);
        }

        public Text getSelfKeyDeliverySuccess(Integer amount) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.selfKeyDeliverySuccess.replace("{amount}", amount.toString()).replace("{amount.plural}", amount != 1 ? "s" : ""));
        }
    }
}

