/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.common;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.physical.PhysicalCrate;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class Checks {
    public Map<Integer, ItemStack> inventory = new HashMap<Integer, ItemStack>();

    public void tryCrateFromPhysicalCrate(PhysicalCrate physicalCrate, Player player) {
        if (physicalCrate.getCrate().isFree().booleanValue()) {
            if (!physicalCrate.getCrate().isTimedOut(player.getUniqueId())) {
                physicalCrate.getCrate().launchView(physicalCrate.getCrate(), player, physicalCrate.getLocation());
                return;
            }
            player.sendMessage(physicalCrate.getCrate().getMessages().format(Crate.Messages.Type.RejectionCooldown, player));
        } else if (!physicalCrate.getCrate().isTimedOut(player.getUniqueId())) {
            Optional pItemInHand = player.getItemInHand(HandTypes.MAIN_HAND);
            if (pItemInHand.isPresent() && this.handleKeyItem(physicalCrate.getCrate(), (ItemStack)pItemInHand.get(), player)) {
                physicalCrate.getCrate().launchView(physicalCrate.getCrate(), player, physicalCrate.getLocation());
                return;
            }
            if (physicalCrate.getCrate().testVirtualKey(player.getUniqueId())) {
                physicalCrate.getCrate().consumeVirtualKeys(player.getUniqueId());
                if (HuskyCrates.instance.virtualKeyDB) {
                    HuskyCrates.registry.pushDirtyVirtualKeys();
                }
                physicalCrate.getCrate().launchView(physicalCrate.getCrate(), player, physicalCrate.getLocation());
                return;
            }
            player.sendMessage(physicalCrate.getCrate().getMessages().format(Crate.Messages.Type.RejectionNeedKey, player));
        } else {
            player.sendMessage(physicalCrate.getCrate().getMessages().format(Crate.Messages.Type.RejectionCooldown, player));
        }
        player.playSound(SoundTypes.ENTITY_CREEPER_DEATH, player.getPosition(), 1.0);
        if (physicalCrate.getCrate().getRejectEffect() != null) {
            HuskyCrates.registry.runClientEffect(physicalCrate.getCrate().getRejectEffect(), physicalCrate.getLocation(), player);
        }
    }

    public void tryCrateFromCrate(Crate crate, Player player) {
        if (crate.isFree().booleanValue()) {
            if (!crate.isTimedOut(player.getUniqueId())) {
                crate.launchView(crate, player, player.getLocation());
                return;
            }
            player.sendMessage(crate.getMessages().format(Crate.Messages.Type.RejectionCooldown, player));
        } else if (!crate.isTimedOut(player.getUniqueId())) {
            Optional pItemInHand = player.getItemInHand(HandTypes.MAIN_HAND);
            if (pItemInHand.isPresent() && this.handleKeyItem(crate, (ItemStack)pItemInHand.get(), player)) {
                crate.launchView(crate, player, player.getLocation());
                return;
            }
            if (crate.testVirtualKey(player.getUniqueId())) {
                crate.consumeVirtualKeys(player.getUniqueId());
                if (HuskyCrates.instance.virtualKeyDB) {
                    HuskyCrates.registry.pushDirtyVirtualKeys();
                }
                crate.launchView(crate, player, player.getLocation());
                return;
            }
            player.sendMessage(crate.getMessages().format(Crate.Messages.Type.RejectionNeedKey, player));
        } else {
            player.sendMessage(crate.getMessages().format(Crate.Messages.Type.RejectionCooldown, player));
        }
        player.playSound(SoundTypes.ENTITY_CREEPER_DEATH, player.getPosition(), 1.0);
    }

    public boolean handleKeyItem(Crate crate, ItemStack stack, Player player) {
        String keyID = Key.extractKeyId(stack);
        if (keyID != null && HuskyCrates.registry.isKey(keyID)) {
            boolean ignoreCompatability;
            Key key = HuskyCrates.registry.getKey(keyID);
            boolean bl = ignoreCompatability = key.canLaunchCrate() != false && key.crateToLaunch().getId().equals(crate.getId());
            if ((key.testKey(stack) || ignoreCompatability) && (crate.testKey(stack) || ignoreCompatability)) {
                int toConsume = 1;
                if (crate.getAcceptedKeys().containsKey(keyID)) {
                    toConsume = crate.getAcceptedKeys().get(keyID);
                }
                if (!HuskyCrates.KEY_SECURITY || HuskyCrates.registry.validateSecureKey(stack, toConsume)) {
                    if (stack.getQuantity() > toConsume) {
                        player.setItemInHand(HandTypes.MAIN_HAND, ItemStack.builder().from(stack).quantity(stack.getQuantity() - toConsume).build());
                    } else if (stack.getQuantity() == toConsume) {
                        player.setItemInHand(HandTypes.MAIN_HAND, ItemStack.empty());
                    } else {
                        player.sendMessage(crate.getMessages().format(Crate.Messages.Type.RejectionNeedKey, player));
                        return false;
                    }
                    HuskyCrates.registry.consumeSecureKey(stack, toConsume);
                    return true;
                }
                player.playSound(SoundTypes.ENTITY_CAT_HISS, player.getPosition(), 1.0);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Caught you!\nYou attempted to use fake keys (stack of " + stack.getQuantity() + ") with this crate!\nThis will be reported to admins."}));
                Util.alertAdminsDupe(player, stack);
                List pe = (List)player.getOrElse(Keys.POTION_EFFECTS, new ArrayList());
                pe.add(PotionEffect.of((PotionEffectType)PotionEffectTypes.BLINDNESS, (int)0, (int)40));
                player.offer(Keys.POTION_EFFECTS, (Object)pe);
                return false;
            }
        }
        return false;
    }
}

