/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.listeners;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.common.Checks;
import com.codehusky.huskycrates.crate.physical.PhysicalCrate;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Key;
import com.codehusky.huskycrates.event.CrateInjectionEvent;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class CrateListeners {
    Checks commonChecks = new Checks();

    @Listener
    public void openCrateBlock(InteractBlockEvent.Secondary.MainHand event, @Root Player player) {
        if (event.getTargetBlock().getLocation().isPresent() && HuskyCrates.registry.isPhysicalCrate((Location<World>)((Location)event.getTargetBlock().getLocation().get()))) {
            PhysicalCrate physicalCrate = HuskyCrates.registry.getPhysicalCrate((Location<World>)((Location)event.getTargetBlock().getLocation().get()));
            event.setCancelled(true);
            this.commonChecks.tryCrateFromPhysicalCrate(physicalCrate, player);
        }
    }

    @Listener
    public void openCratePreviewBlock(InteractBlockEvent.Primary.MainHand event, @Root Player player) {
        PhysicalCrate physicalCrate;
        if (event.getTargetBlock().getLocation().isPresent() && HuskyCrates.registry.isPhysicalCrate((Location<World>)((Location)event.getTargetBlock().getLocation().get())) && (physicalCrate = HuskyCrates.registry.getPhysicalCrate((Location<World>)((Location)event.getTargetBlock().getLocation().get()))).getCrate().isPreviewable() && (!player.hasPermission("huskycrates.admin") || player.getOrNull(Keys.GAME_MODE) != GameModes.CREATIVE)) {
            physicalCrate.getCrate().launchPreview(player);
            event.setCancelled(true);
        }
    }

    @Listener
    public void openCrateEntity(InteractEntityEvent.Secondary.MainHand event, @Root Player player) {
    }

    @Listener
    public void openCratePreviewEntity(InteractEntityEvent.Primary.MainHand event, @Root Player player) {
    }

    @Listener(order=Order.PRE)
    public void placeCrate(ChangeBlockEvent.Place event, @Root Player player) {
        if (event.getContext().get(EventContextKeys.USED_ITEM).isPresent() || player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            for (Transaction transaction : event.getTransactions()) {
                Optional pLocation = ((BlockSnapshot)transaction.getFinal()).getLocation();
                ItemStack stackUsed = event.getContext().get(EventContextKeys.USED_ITEM).isPresent() ? ((ItemStackSnapshot)event.getContext().get(EventContextKeys.USED_ITEM).get()).createStack() : ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).createSnapshot().createStack();
                if (!pLocation.isPresent()) continue;
                Location location = (Location)pLocation.get();
                String pID = null;
                try {
                    pID = Crate.extractCrateID(stackUsed);
                }
                catch (Exception e) {
                    return;
                }
                if (pID == null || !HuskyCrates.registry.isCrate(pID)) continue;
                if (!stackUsed.getType().getBlock().isPresent()) {
                    return;
                }
                if (!((BlockType)stackUsed.getType().getBlock().get()).equals(((BlockSnapshot)transaction.getFinal()).getState().getType())) continue;
                if (!player.hasPermission("huskycrates.admin")) {
                    event.setCancelled(true);
                    player.setItemInHand(HandTypes.MAIN_HAND, ItemStack.empty());
                    Util.alertAdmins(Text.of((Object[])new Object[]{TextColors.RED, "[HuskyCrates]", TextColors.YELLOW, " " + player.getName() + " tried to place a crate without permission."}), "[PERM VIOLATION] " + player.getName() + " (" + player.getUniqueId().toString() + ") tried to place a crate without permission.");
                    return;
                }
                HuskyCrates.registry.registerPhysicalCrate(new PhysicalCrate((Location<World>)location, pID));
            }
        }
    }

    @Listener
    public void crateBlockDestroyed(ChangeBlockEvent event) {
        if (!(event instanceof ChangeBlockEvent.Break)) {
            return;
        }
        for (Transaction trans : event.getTransactions()) {
            Player plr;
            BlockSnapshot original = (BlockSnapshot)trans.getOriginal();
            BlockSnapshot after = (BlockSnapshot)trans.getFinal();
            if (!original.getLocation().isPresent() || !HuskyCrates.registry.isPhysicalCrate((Location<World>)((Location)original.getLocation().get()))) continue;
            if (event.getCause().root() instanceof Player && !(plr = (Player)event.getCause().root()).hasPermission("huskycrates.admin")) {
                event.setCancelled(true);
                return;
            }
            if (original.getState().getType().equals(after.getState().getType())) continue;
            PhysicalCrate pc = HuskyCrates.registry.getPhysicalCrate((Location<World>)((Location)original.getLocation().get()));
            pc.cleanup();
            HuskyCrates.registry.unregisterPhysicalCrate((Location<World>)((Location)original.getLocation().get()));
        }
    }

    @Listener(order=Order.POST)
    public void keyInteract(InteractItemEvent.Secondary.MainHand event, @Root Player player) {
        Key key;
        String keyid = Key.extractKeyId(event.getItemStack().createStack());
        if (keyid != null && HuskyCrates.registry.isKey(keyid) && (key = HuskyCrates.registry.getKey(keyid)).canLaunchCrate().booleanValue()) {
            this.commonChecks.handleKeyItem(new PhysicalCrate(null, key.crateToLaunch().getId(), false).getCrate(), event.getItemStack().createStack(), player);
        }
    }

    @Listener(order=Order.POST)
    public void afterInjection(CrateInjectionEvent event) {
        HuskyCrates.registry.postInjection();
        HuskyCrates.instance.logger.info("Injection checks passed.");
    }
}

