/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.physical;

import com.codehusky.huskycrates.crate.virtual.Hologram;
import java.util.Collection;
import java.util.List;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class HologramInstance {
    private Hologram hologram;
    private Location<World> location;
    private boolean isEntity;
    private Entity assocEntity;
    private List<ArmorStand> armorStands;

    public HologramInstance(Hologram hologram, Location<World> location, boolean isEntity) {
        this.hologram = hologram;
        this.location = location;
        this.isEntity = isEntity;
        this.init();
    }

    public void cleanup() {
        HologramInstance.cleanup(this.location);
    }

    public static void cleanup(Location<World> location) {
        if (location == null) {
            return;
        }
        Collection potential = ((World)location.getExtent()).getNearbyEntities(location.getPosition().clone().add(0.5, 0.0, 0.5).add(0.0, 0.4, 0.0), 0.8);
        for (int i = 1; i < 2; ++i) {
            potential.addAll(((World)location.getExtent()).getNearbyEntities(location.getPosition().clone().add(0.5, 0.0, 0.5).add(0.0, 0.4 + 0.8 * (double)i, 0.0), 0.8));
        }
        for (Entity e : potential) {
            if (!(e instanceof ArmorStand)) continue;
            e.remove();
        }
    }

    public void init() {
        this.cleanup();
        int linenum = 0;
        for (String line : this.hologram.getLines()) {
            Text textline = TextSerializers.FORMATTING_CODE.deserialize(line);
            ArmorStand as = (ArmorStand)((World)this.location.getExtent()).createEntity(EntityTypes.ARMOR_STAND, this.location.getPosition().clone().add(0.5, 1.0, 0.5).add(0.0, this.hologram.getEntityYOffset() - (double)linenum * 0.23, 0.0));
            as.offer(Keys.HAS_GRAVITY, (Object)false);
            as.offer(Keys.ARMOR_STAND_IS_SMALL, (Object)true);
            as.offer(Keys.CUSTOM_NAME_VISIBLE, (Object)true);
            as.offer(Keys.INVULNERABLE, (Object)true);
            as.offer(Keys.INVISIBLE, (Object)true);
            as.offer(Keys.INVULNERABILITY_TICKS, (Object)-1);
            as.offer(Keys.DISPLAY_NAME, (Object)textline);
            as.offer(Keys.ARMOR_STAND_MARKER, (Object)true);
            as.offer(Keys.ARMOR_STAND_HAS_ARMS, (Object)false);
            ((World)this.location.getExtent()).spawnEntity((Entity)as);
            ++linenum;
        }
    }

    public Location<World> getLocation() {
        return this.location;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public Entity getAssocEntity() {
        return this.assocEntity;
    }

    public List<ArmorStand> getArmorStands() {
        return this.armorStands;
    }
}

