/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.physical;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.crate.physical.EffectInstance;
import com.codehusky.huskycrates.crate.physical.HologramInstance;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.exception.InvalidCrateIDError;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PhysicalCrate {
    private Location<World> location;
    private boolean isEntity;
    private String representedCrateID;
    private EffectInstance idleEffect;
    private EffectInstance rejectEffect;
    private EffectInstance winEffect;
    private EffectInstance openEffect;
    private HologramInstance hologramInstance;

    public PhysicalCrate(Location<World> location, String representedCrateID, boolean isEntity) {
        this.location = location;
        if (!HuskyCrates.registry.isCrate(representedCrateID)) {
            throw new InvalidCrateIDError("No crate with id " + representedCrateID);
        }
        this.representedCrateID = representedCrateID;
        this.isEntity = isEntity;
        System.out.println(representedCrateID);
        Crate crate = HuskyCrates.registry.getCrate(this.representedCrateID);
        if (location == null) {
            return;
        }
        if (crate.getIdleEffect() != null) {
            this.idleEffect = new EffectInstance(crate.getIdleEffect(), location);
        }
        if (crate.getRejectEffect() != null) {
            this.rejectEffect = new EffectInstance(crate.getRejectEffect(), location);
        }
        if (crate.getWinEffect() != null) {
            this.winEffect = new EffectInstance(crate.getWinEffect(), location);
        }
        if (crate.getOpenEffect() != null) {
            this.openEffect = new EffectInstance(crate.getOpenEffect(), location);
        }
        if (crate.getHologram() != null) {
            this.hologramInstance = new HologramInstance(crate.getHologram(), location, isEntity);
        }
    }

    public EffectInstance getIdleEffect() {
        return this.idleEffect;
    }

    public PhysicalCrate(Location<World> location, String representedCrateID) {
        this(location, representedCrateID, false);
    }

    public Crate getCrate() {
        return HuskyCrates.registry.getCrate(this.representedCrateID);
    }

    public Location<World> getLocation() {
        return this.location;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public void cleanup() {
        if (this.hologramInstance != null) {
            this.hologramInstance.cleanup();
        }
    }
}

