/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.crate.virtual.Hologram;
import com.codehusky.huskycrates.crate.virtual.Item;
import com.codehusky.huskycrates.crate.virtual.Key;
import com.codehusky.huskycrates.crate.virtual.Slot;
import com.codehusky.huskycrates.crate.virtual.effects.Effect;
import com.codehusky.huskycrates.crate.virtual.effects.elements.Particle;
import com.codehusky.huskycrates.crate.virtual.views.SimpleView;
import com.codehusky.huskycrates.crate.virtual.views.SpinnerView;
import com.codehusky.huskycrates.crate.virtual.views.ViewConfig;
import com.codehusky.huskycrates.exception.ConfigParseError;
import com.codehusky.huskycrates.exception.InjectionMissedError;
import com.codehusky.huskycrates.exception.InvalidMessageTypeError;
import com.codehusky.huskycrates.exception.NoMessageContextError;
import com.codehusky.huskycrates.exception.SlotSelectionError;
import com.codehusky.huskycrates.exception.VirtualKeyStarvedError;
import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.Page;
import com.codehusky.huskyui.states.State;
import com.codehusky.huskyui.states.element.Element;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Crate {
    private String id;
    private String name;
    private Hologram hologram;
    private Effect idleEffect;
    private Effect rejectEffect;
    private Effect winEffect;
    private Effect openEffect;
    private List<Slot> slots;
    private int slotChanceMax = 0;
    private Boolean scrambleSlots;
    private Boolean free;
    private boolean previewable;
    private Boolean previewShowsRewardCount;
    private long cooldownSeconds;
    private BlockType defaultBlock;
    private Boolean useLocalKey;
    private Key localKey;
    private HashMap<String, Integer> acceptedKeys = new HashMap();
    private ViewType viewType;
    private ViewConfig viewConfig;
    private Messages messages;
    private boolean injection;

    public Crate(ConfigurationNode node) {
        if (!node.hasMapChildren()) {
            throw new ConfigParseError("Invalid data in crates.conf. Please remove it.", node.getPath());
        }
        this.slots = new ArrayList<Slot>();
        this.id = node.getKey().toString();
        this.name = node.getNode(new Object[]{"name"}).getString();
        this.useLocalKey = node.getNode(new Object[]{"useLocalKey"}).getBoolean(false);
        this.injection = node.getNode(new Object[]{"waitForInjection"}).getBoolean(false);
        ConfigurationNode aKeyNode = node.getNode(new Object[]{"acceptedKeys"});
        if (!aKeyNode.isVirtual()) {
            if (aKeyNode.hasListChildren()) {
                for (ConfigurationNode keynode : aKeyNode.getChildrenList()) {
                    if (HuskyCrates.registry.isKey(keynode.getString())) {
                        this.acceptedKeys.put(keynode.getString(), 1);
                        continue;
                    }
                    throw new ConfigParseError("Invalid key id: " + keynode.getString(), keynode.getPath());
                }
            } else if (aKeyNode.hasMapChildren()) {
                for (Object key : aKeyNode.getChildrenMap().keySet()) {
                    if (HuskyCrates.registry.isKey(key.toString())) {
                        this.acceptedKeys.put(key.toString(), aKeyNode.getNode(new Object[]{key}).getInt(1));
                        continue;
                    }
                    throw new ConfigParseError("Invalid key id: " + key.toString(), aKeyNode.getNode(new Object[]{key}).getPath());
                }
            } else {
                throw new ConfigParseError("Invalid key format specified. Odd.", aKeyNode.getPath());
            }
        }
        this.free = node.getNode(new Object[]{"free"}).getBoolean(false);
        if (this.useLocalKey.booleanValue()) {
            boolean localKeyLaunchesCrate = node.getNode(new Object[]{"localKeyLaunchesCrate"}).getBoolean(false);
            this.localKey = !node.getNode(new Object[]{"localKey"}).isVirtual() ? new Key("LOCALKEY_" + this.id, new Item(node.getNode(new Object[]{"localKey"})), localKeyLaunchesCrate) : new Key("LOCALKEY_" + this.id, new Item("&8" + this.name + " Key", ItemTypes.NETHER_STAR, null, 1, null, null, null, null), localKeyLaunchesCrate);
        } else if (aKeyNode.isVirtual() && !this.free.booleanValue()) {
            throw new ConfigParseError("Non-free crate has no accepted keys!", node.getPath());
        }
        if (node.getNode(new Object[]{"slots"}).isVirtual()) {
            if (!this.injection) {
                throw new ConfigParseError("Crates must have associated slots!", node.getNode(new Object[]{"slots"}).getPath());
            }
            HuskyCrates.instance.logger.warn("Crate with id of " + this.id + " is waiting for injection.");
        } else {
            for (ConfigurationNode slot : node.getNode(new Object[]{"slots"}).getChildrenList()) {
                Slot thisSlot = new Slot(slot, this);
                this.slotChanceMax += thisSlot.getChance().intValue();
                this.slots.add(thisSlot);
            }
            if (this.slots.size() == 0) {
                throw new ConfigParseError("Crates must have associated slots!", node.getNode(new Object[]{"slots"}).getPath());
            }
        }
        this.messages = new Messages(node.getNode(new Object[]{"messages"}), this.id, HuskyCrates.crateMessages);
        try {
            this.viewType = ViewType.valueOf(node.getNode(new Object[]{"viewType"}).getString().toUpperCase());
            switch (this.viewType) {
                case SPINNER: {
                    this.viewConfig = new SpinnerView.Config(node.getNode(new Object[]{"viewConfig"}));
                    break;
                }
                default: {
                    this.viewConfig = new ViewConfig(node.getNode(new Object[]{"viewConfig"}));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ConfigParseError("Invalid view type!", node.getNode(new Object[]{"viewType"}).getPath());
        }
        this.cooldownSeconds = node.getNode(new Object[]{"cooldownSeconds"}).getLong(0L);
        this.scrambleSlots = node.getNode(new Object[]{"scrambleSlots"}).getBoolean(false);
        ConfigurationNode eNode = node.getNode(new Object[]{"effects"});
        if (!eNode.getNode(new Object[]{"idle"}).isVirtual()) {
            this.idleEffect = new Effect(eNode.getNode(new Object[]{"idle"}));
            if (this.idleEffect.isDisabled()) {
                this.idleEffect = null;
            }
        }
        if (!eNode.getNode(new Object[]{"reject"}).isVirtual()) {
            this.rejectEffect = new Effect(eNode.getNode(new Object[]{"reject"}));
            if (this.rejectEffect.isDisabled()) {
                this.rejectEffect = null;
            }
        } else {
            this.rejectEffect = new Effect(false, 1L, false, false, true, new ArrayList<Particle>(Collections.singletonList(new Particle(ParticleEffect.builder().type(ParticleTypes.SMOKE).quantity(20).offset(new Vector3d(0.1, 0.3, 0.1)).build(), new Vector3d(0.5, 1.3, 0.5)))));
        }
        if (!eNode.getNode(new Object[]{"win"}).isVirtual()) {
            this.winEffect = new Effect(eNode.getNode(new Object[]{"win"}));
            if (this.winEffect.isDisabled()) {
                this.winEffect = null;
            }
        }
        if (!eNode.getNode(new Object[]{"open"}).isVirtual()) {
            this.openEffect = new Effect(eNode.getNode(new Object[]{"open"}));
            if (this.openEffect.isDisabled()) {
                this.openEffect = null;
            }
        }
        if (!node.getNode(new Object[]{"hologram"}).isVirtual()) {
            this.hologram = new Hologram(node.getNode(new Object[]{"hologram"}));
        }
        this.previewable = node.getNode(new Object[]{"previewable"}).getBoolean(false);
        this.previewShowsRewardCount = node.getNode(new Object[]{"previewShowsRewardCount"}).getBoolean(true);
    }

    public Crate(String id, String name, Hologram hologram, Effect idleEffect, Effect rejectEffect, Effect winEffect, Effect openEffect, List<Slot> slots, boolean scrambleSlots, boolean free, boolean previewable, boolean previewRewardCount, long cooldownSeconds, boolean useLocalKey, Key localKey, HashMap<String, Integer> acceptedKeys, ViewType viewType, ViewConfig viewConfig) {
        this.id = id;
        this.name = name;
        this.hologram = hologram;
        this.idleEffect = idleEffect;
        this.rejectEffect = rejectEffect;
        this.winEffect = winEffect;
        this.openEffect = openEffect;
        this.slots = slots;
        this.slotChanceMax = 0;
        for (Slot slot : slots) {
            this.slotChanceMax += slot.getChance().intValue();
        }
        if (slots.size() == 0) {
            throw new ConfigParseError("Crates must have associated slots!", Lists.newArrayList((Object[])new String[]{"Injected!!!"}).toArray());
        }
        this.scrambleSlots = scrambleSlots;
        this.free = free;
        this.previewable = previewable;
        this.previewShowsRewardCount = previewRewardCount;
        this.cooldownSeconds = cooldownSeconds;
        this.useLocalKey = useLocalKey;
        this.localKey = localKey;
        this.acceptedKeys = acceptedKeys;
        this.viewType = viewType;
        this.viewConfig = viewConfig;
    }

    public Crate getScrambledCrate() {
        ArrayList<Slot> newSlots = new ArrayList<Slot>(this.slots);
        Collections.shuffle(newSlots);
        return new Crate(this.id, this.name, this.hologram, this.idleEffect, this.rejectEffect, this.winEffect, this.openEffect, newSlots, this.scrambleSlots, this.free, this.previewable, this.previewShowsRewardCount, this.cooldownSeconds, this.useLocalKey, this.localKey, this.acceptedKeys, this.viewType, this.viewConfig);
    }

    public boolean isScrambled() {
        return this.scrambleSlots;
    }

    public boolean isInjectable() {
        return this.injection;
    }

    public void injectSlot(Slot slot) {
        this.slots.add(slot);
        this.slotChanceMax += slot.getChance().intValue();
    }

    public void postInjectionChecks() {
        if (this.injection) {
            if (this.slots.size() == 0) {
                throw new InjectionMissedError("Injectable crates with no slots must be injected!");
            }
            HuskyCrates.instance.logger.info("Injection successful on " + this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    public int selectSlot() {
        int chanceCuml = 0;
        int selection = new Random().nextInt(this.slotChanceMax + 1);
        for (int i = 0; i < this.slots.size(); ++i) {
            if (selection > (chanceCuml += this.slots.get(i).getChance().intValue())) continue;
            return i;
        }
        throw new SlotSelectionError("Slot could not be selected for crate \"" + this.id + "\". chanceCuml=" + chanceCuml + "; selection=" + selection);
    }

    public boolean testKey(ItemStack stack) {
        if (this.free.booleanValue()) {
            return true;
        }
        if (this.useLocalKey.booleanValue() && this.localKey.testKey(stack)) {
            return true;
        }
        for (Map.Entry<String, Integer> entry : this.acceptedKeys.entrySet()) {
            Key potential = HuskyCrates.registry.getKey(entry.getKey());
            if (!potential.testKey(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean testVirtualKey(UUID playerUUID) {
        for (Map.Entry<String, Integer> entry : this.acceptedKeys.entrySet()) {
            if (HuskyCrates.registry.getVirtualKeyBalance(playerUUID, entry.getKey()) < entry.getValue()) continue;
            return true;
        }
        return this.useLocalKey != false && HuskyCrates.registry.getVirtualKeyBalance(playerUUID, this.getLocalKey().getId()) >= 1;
    }

    public void consumeVirtualKeys(UUID playerUUID) {
        if (this.testVirtualKey(playerUUID)) {
            for (Map.Entry<String, Integer> entry : this.acceptedKeys.entrySet()) {
                String keyID = entry.getKey();
                int consumed = entry.getValue();
                if (HuskyCrates.registry.getVirtualKeyBalance(playerUUID, keyID) < consumed) continue;
                HuskyCrates.registry.removeVirtualKeys(playerUUID, keyID, consumed);
                if (Sponge.getServer().getPlayer(playerUUID).isPresent()) {
                    Player player = (Player)Sponge.getServer().getPlayer(playerUUID).get();
                    player.sendMessage(this.messages.getVirtualKeyConsumed(HuskyCrates.registry.getKey(keyID).getName(), consumed, HuskyCrates.registry.getVirtualKeyBalance(playerUUID, keyID)));
                }
                return;
            }
            if (this.useLocalKey.booleanValue() && HuskyCrates.registry.getVirtualKeyBalance(playerUUID, this.getLocalKey().getId()) >= 1) {
                HuskyCrates.registry.removeVirtualKeys(playerUUID, this.getLocalKey().getId(), 1);
                if (Sponge.getServer().getPlayer(playerUUID).isPresent()) {
                    Player player = (Player)Sponge.getServer().getPlayer(playerUUID).get();
                    player.sendMessage(this.messages.getVirtualKeyConsumed(this.getLocalKey().getName(), 1, HuskyCrates.registry.getVirtualKeyBalance(playerUUID, this.getLocalKey().getId())));
                }
                return;
            }
            throw new VirtualKeyStarvedError("No virtual key could be found to consume in exchange for a crate use. Report this to a developer.");
        }
    }

    public boolean hasLocalKey() {
        return this.useLocalKey;
    }

    public Key getLocalKey() {
        return this.localKey;
    }

    public boolean isPreviewable() {
        return this.previewable;
    }

    public boolean previewShowsRewards() {
        return this.previewShowsRewardCount;
    }

    public ItemStack getCratePlacementBlock(ItemType itemType, int damage) {
        ItemStack stack = ItemStack.builder().itemType(itemType).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextSerializers.FORMATTING_CODE.deserialize(this.name != null ? this.name : this.id), " Placement Block"})).build();
        return ItemStack.builder().fromContainer((DataView)stack.toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "HCCRATEID"}), (Object)this.id).set(DataQuery.of((String[])new String[]{"UnsafeDamage"}), (Object)damage)).build();
    }

    public ItemStack getWandItem() {
        ItemStack stack = ItemStack.builder().itemType(ItemTypes.BLAZE_ROD).add(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextSerializers.FORMATTING_CODE.deserialize(this.name != null ? this.name : this.id), " Wand"})).add(Keys.ITEM_LORE, Arrays.asList(Text.of((String)"Right click to set entity"), Text.of((String)"or crate. You can also remove"), Text.of((String)"crates from entities or crates with this."))).build();
        return ItemStack.builder().fromContainer((DataView)stack.toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "HCCRATEID"}), (Object)this.id)).build();
    }

    public ItemStack getCratePlacementBlock(int damage) {
        return this.getCratePlacementBlock(ItemTypes.CHEST, damage);
    }

    public static String extractCrateID(ItemStack stack) {
        try {
            return stack.toContainer().get(DataQuery.of((String[])new String[]{"UnsafeData", "HCCRATEID"})).get().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public ViewConfig getViewConfig() {
        return this.viewConfig;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public int getSlotCount() {
        return this.slots.size();
    }

    public Slot getSlot(int slot) {
        return this.slots.get(slot);
    }

    public Effect getIdleEffect() {
        return this.idleEffect;
    }

    public Effect getOpenEffect() {
        return this.openEffect;
    }

    public Effect getRejectEffect() {
        return this.rejectEffect;
    }

    public Effect getWinEffect() {
        return this.winEffect;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public HashMap<String, Integer> getAcceptedKeys() {
        return this.acceptedKeys;
    }

    public Boolean isFree() {
        return this.free;
    }

    public long getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public long getCooldownSeconds(Player player) {
        Long time = HuskyCrates.registry.getLastUse(this.id, player.getUniqueId());
        if (time == null) {
            return 0L;
        }
        return 1L + (long)Math.ceil((time + this.cooldownSeconds * 1000L - System.currentTimeMillis()) / 1000L);
    }

    public boolean isTimedOut(UUID playerUUID) {
        Long time = HuskyCrates.registry.getLastUse(this.id, playerUUID);
        return time != null && time + this.cooldownSeconds * 1000L - System.currentTimeMillis() >= 0L;
    }

    public void launchView(Crate ucrate, Player player, Location loc) {
        HuskyCrates.registry.updateLastUse(this.id, player.getUniqueId());
        switch (this.viewType) {
            case SPINNER: {
                new SpinnerView(ucrate, player, loc);
                break;
            }
            case INSTANT: {
                player.playSound(SoundTypes.ENTITY_EXPERIENCE_ORB_PICKUP, player.getPosition(), 1.0);
                this.getSlot(this.selectSlot()).rewardPlayer(player, (Location<World>)loc);
                break;
            }
            case SIMPLE: {
                new SimpleView(ucrate, player, loc);
                break;
            }
            default: {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "The view type \"" + this.viewType.name() + "\" is currently not supported."}));
            }
        }
    }

    public void launchPreview(Player player) {
        StateContainer previewContainer = new StateContainer();
        Page.PageBuilder builder = Page.builder();
        builder.setTitle(Text.of((Object[])new Object[]{TextSerializers.FORMATTING_CODE.deserialize(this.getName())}));
        builder.setAutoPaging(true);
        for (int j = 0; j < this.slots.size(); ++j) {
            ItemStack orig = this.slots.get(j).getDisplayItem().toItemStack();
            List oldLore = (List)orig.getOrElse(Keys.ITEM_LORE, new ArrayList());
            double val = (double)this.slots.get(j).getChance().intValue() / (double)this.slotChanceMax * 100.0;
            BigDecimal occurance = new BigDecimal(val).setScale(2, 4);
            if (this.previewShowsRewardCount.booleanValue()) {
                oldLore.add(Text.of((Object[])new Object[]{TextStyles.NONE, TextColors.GRAY, "Rewards: " + this.slots.get(j).getRewards().size()}));
            }
            oldLore.add(Text.of((Object[])new Object[]{TextStyles.NONE, TextColors.GRAY, "Occurrence: " + (val < 0.01 ? "< 0.01" : occurance.toString()) + "%"}));
            builder.addElement(new Element(ItemStack.builder().from(orig).add(Keys.ITEM_LORE, (Object)oldLore).build()));
        }
        Page built = builder.build("preview");
        previewContainer.setInitialState((State)built);
        previewContainer.launchFor(player);
    }

    public static class Messages {
        private String rejectionNeedKey;
        private String rejectionCooldown;
        private String virtualKeyConsumed;
        private String crateID;

        public String getRejectionCooldown() {
            return this.rejectionCooldown;
        }

        public String getRejectionNeedKey() {
            return this.rejectionNeedKey;
        }

        public String getVirtualKeyConsumed() {
            return this.virtualKeyConsumed;
        }

        public Messages(ConfigurationNode node, @Nullable String crateID, @Nullable Messages defaultMessages) {
            this.rejectionNeedKey = node.getNode(new Object[]{"rejectionNeedKey"}).getString(defaultMessages != null ? defaultMessages.getRejectionNeedKey() : "&cYou need a {key.0.name} to use this crate.");
            this.rejectionCooldown = node.getNode(new Object[]{"rejectionCooldown"}).getString(defaultMessages != null ? defaultMessages.getRejectionCooldown() : "&aCalm down! &7You need to wait {cooldown.remaining} second{cooldown.remaining.plural} before you can use another {crate.name}&r&7!");
            this.virtualKeyConsumed = node.getNode(new Object[]{"virtualKeyConsumed"}).getString(defaultMessages != null ? defaultMessages.getVirtualKeyConsumed() : "&eYou just used {amount} {key}{amount.plural}&r&e from your key balance. You have {amountRemaining} {key}&r&e{amountRemaining.plural} left.");
            this.crateID = crateID;
        }

        public Messages(ConfigurationNode node, @Nullable String crateID) {
            this(node, crateID, null);
        }

        public Messages(String rnk, String rc, String crateID) {
            this.rejectionCooldown = rc;
            this.rejectionNeedKey = rnk;
            this.crateID = crateID;
        }

        public Messages clone() {
            return new Messages(this.rejectionNeedKey, this.rejectionCooldown, this.crateID);
        }

        public void setCrateID(String crateID) {
            this.crateID = crateID;
        }

        public Text format(Type messageType, Player player) {
            if (!HuskyCrates.registry.isCrate(this.crateID)) {
                throw new NoMessageContextError("Invalid crate id: " + this.crateID);
            }
            return this.format(messageType, HuskyCrates.registry.getCrate(this.crateID), player, null);
        }

        public Text getVirtualKeyConsumed(String keyName, Integer amountConsumed, Integer amountRemaining) {
            return TextSerializers.FORMATTING_CODE.deserialize(this.virtualKeyConsumed.replace("{amount}", amountConsumed.toString()).replace("{amount.plural}", amountConsumed != 1 ? "s" : "").replace("{amountRemaining}", amountRemaining.toString()).replace("{amountRemaining.plural}", amountRemaining != 1 ? "s" : "").replace("{key}", keyName));
        }

        public Text format(Type messageType, Crate crate, Player player, Slot slot) {
            String newMessage;
            switch (messageType) {
                case RejectionNeedKey: {
                    newMessage = this.rejectionNeedKey;
                    break;
                }
                case RejectionCooldown: {
                    newMessage = this.rejectionCooldown;
                    break;
                }
                default: {
                    throw new InvalidMessageTypeError("Invalid message type used!");
                }
            }
            newMessage = newMessage.replace("{crate.name}", crate.getName()).replace("{crate.id}", crate.getId());
            ArrayList<Key> keys = new ArrayList<Key>();
            if (crate.hasLocalKey()) {
                keys.add(crate.getLocalKey());
            }
            for (String keyID : crate.getAcceptedKeys().keySet()) {
                keys.add(HuskyCrates.registry.getKey(keyID));
            }
            int num = 0;
            for (Key key : keys) {
                Integer amountRequired = crate.hasLocalKey() && num == 0 ? Integer.valueOf(1) : crate.getAcceptedKeys().get(key.getId());
                newMessage = newMessage.replace("{key." + num + ".id}", key.getId()).replace("{key." + num + ".name}", key.getName()).replace("{key." + num + ".amountRequired}", amountRequired.toString()).replace("{key." + num + ".amountRequired.plural}", amountRequired != 0 ? "s" : "").replace("{key." + key.getId() + ".id}", key.getId()).replace("{key." + key.getId() + ".name}", key.getName()).replace("{key." + key.getId() + ".amountRequired}", amountRequired.toString()).replace("{key." + key.getId() + ".amountRequired.plural}", amountRequired != 0 ? "s" : "");
                ++num;
            }
            newMessage = newMessage.replace("{cooldown.remaining}", "" + crate.getCooldownSeconds(player)).replace("{cooldown.remaining.plural}", crate.getCooldownSeconds(player) != 1L ? "s" : "").replace("{cooldown.total}", "" + crate.getCooldownSeconds()).replace("{cooldown.total.plural}", crate.getCooldownSeconds() != 1L ? "s" : "");
            return TextSerializers.FORMATTING_CODE.deserialize(newMessage);
        }

        public static enum Type {
            RejectionNeedKey,
            RejectionCooldown;

        }
    }

    static enum ViewType {
        SPINNER,
        ROULETTE,
        INSTANT,
        SIMPLE;

    }
}

