/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.exception.ConfigParseError;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class Item {
    private String name;
    private ItemType itemType;
    private List<String> lore;
    private Integer count;
    private Integer damage;
    private Integer durability;
    private List<Enchantment> enchantments;
    private Map nbt;

    public static Item fromItemStack(ItemStack stack) {
        String name = TextSerializers.FORMATTING_CODE.serialize(stack.get(Keys.DISPLAY_NAME).orElse(Text.EMPTY));
        if (name.length() == 0) {
            name = null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (stack.get(Keys.ITEM_LORE).isPresent()) {
            ((List)stack.get(Keys.ITEM_LORE).get()).forEach(text -> lore.add(TextSerializers.FORMATTING_CODE.serialize(text)));
        }
        return new Item(name, stack.getType(), lore, stack.getQuantity(), stack.toContainer().getInt(DataQuery.of((String[])new String[]{"UnsafeDamage"})).orElse(null), stack.get(Keys.ITEM_DURABILITY).orElse(null), stack.get(Keys.ITEM_ENCHANTMENTS).orElse(null), stack.toContainer().getMap(DataQuery.of((String[])new String[]{"UnsafeData"})).orElse(null));
    }

    public Item(String name, ItemType itemType, List<String> lore, Integer count, Integer damage, Integer durability, List<Enchantment> enchantments, Map nbt) {
        this.name = name;
        if (name != null && name.length() == 0) {
            this.name = null;
        }
        this.itemType = itemType;
        this.lore = lore;
        this.count = count;
        this.damage = damage;
        this.durability = durability;
        this.enchantments = enchantments;
        this.nbt = nbt;
        if (this.nbt instanceof ImmutableMap) {
            this.nbt = Maps.newHashMap((Map)this.nbt);
        }
    }

    public Item(ConfigurationNode node) {
        if (!node.getNode(new Object[]{"id"}).isVirtual()) {
            try {
                this.itemType = (ItemType)node.getNode(new Object[]{"id"}).getValue(TypeToken.of(ItemType.class));
            }
            catch (ObjectMappingException e) {
                HuskyCrates.instance.logger.error("Printing out ItemID ObjectMappingException below!");
                e.printStackTrace();
                throw new ConfigParseError("Supplied Item ID is not valid!", node.getNode(new Object[]{"id"}).getPath());
            }
        } else {
            throw new ConfigParseError("Item ID was not specified in an item!", node.getNode(new Object[]{"id"}).getPath());
        }
        this.name = node.getNode(new Object[]{"name"}).getString();
        if (this.name != null && this.name.length() == 0) {
            this.name = null;
        }
        this.count = node.getNode(new Object[]{"count"}).getInt(1);
        this.damage = node.getNode(new Object[]{"damage"}).getInt(node.getNode(new Object[]{"meta"}).getInt(node.getNode(new Object[]{"metadata"}).getInt()));
        this.durability = node.getNode(new Object[]{"durability"}).getInt();
        if (!node.getNode(new Object[]{"lore"}).isVirtual()) {
            try {
                this.lore = node.getNode(new Object[]{"lore"}).getList(TypeToken.of(String.class));
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
                throw new ConfigParseError("Invalid lore virtual specified! Reason is printed above.", node.getNode(new Object[]{"lore"}).getPath());
            }
        }
        this.enchantments = new ArrayList<Enchantment>();
        if (!node.getNode(new Object[]{"enchantments"}).isVirtual()) {
            node.getNode(new Object[]{"enchantments"}).getChildrenMap().forEach((enchantID, level) -> {
                Optional enchantType = Sponge.getRegistry().getType(EnchantmentType.class, enchantID.toString());
                if (!enchantType.isPresent()) {
                    throw new ConfigParseError("Invalid Enchantment specified!", node.getNode(new Object[]{"enchantments", enchantID}).getPath());
                }
                if (!(level.getValue() instanceof Integer)) {
                    throw new ConfigParseError("Invalid Type for Enchantment Level!", node.getNode(new Object[]{"enchantments", enchantID}).getPath());
                }
                this.enchantments.add(Enchantment.builder().type((EnchantmentType)enchantType.get()).level(((Integer)level.getValue()).intValue()).build());
            });
        }
        if (!node.getNode(new Object[]{"nbt"}).isVirtual() && node.getNode(new Object[]{"nbt"}).getValue() instanceof LinkedHashMap) {
            this.nbt = (LinkedHashMap)node.getNode(new Object[]{"nbt"}).getValue();
        }
    }

    public ItemStack toItemStack() {
        ItemStack stack = ItemStack.of((ItemType)this.itemType, (int)this.count);
        if (this.name != null) {
            stack.offer(Keys.DISPLAY_NAME, (Object)TextSerializers.FORMATTING_CODE.deserialize(this.name));
        }
        if (this.durability != null) {
            stack.offer(Keys.ITEM_DURABILITY, (Object)this.durability);
        }
        if (this.lore != null) {
            ArrayList<Text> realLore = new ArrayList<Text>();
            for (String line : this.lore) {
                realLore.add(TextSerializers.FORMATTING_CODE.deserialize(line));
            }
            stack.offer(Keys.ITEM_LORE, realLore);
        }
        if (this.enchantments != null) {
            stack.offer(Keys.ITEM_ENCHANTMENTS, this.enchantments);
        }
        if (this.nbt != null) {
            DataContainer container = stack.toContainer();
            if (container.get(DataQuery.of((String[])new String[]{"UnsafeData"})).isPresent()) {
                Map real = (Map)container.getMap(DataQuery.of((String[])new String[]{"UnsafeData"})).get();
                this.nbt.putAll(real);
            }
            container.set(DataQuery.of((String[])new String[]{"UnsafeData"}), (Object)this.nbt);
            stack = ItemStack.builder().fromContainer((DataView)container).build();
        }
        if (this.damage != null) {
            stack = ItemStack.builder().fromContainer((DataView)stack.toContainer().set(DataQuery.of((String[])new String[]{"UnsafeDamage"}), (Object)this.damage)).build();
        }
        return stack;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getDamage() {
        return this.damage;
    }

    public Integer getDurability() {
        return this.durability;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public Map getNBT() {
        return this.nbt;
    }

    public List<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public String getName() {
        return this.name;
    }
}

