/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Item;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.item.inventory.ItemStack;

public class Key {
    private String id;
    private String name;
    private Boolean isVirtual;
    private Boolean canLaunchCrate;
    private String crateIDToLaunch;
    private Item item;

    public Key(ConfigurationNode node) {
        this.id = node.getKey().toString();
        this.name = node.getNode(new Object[]{"name"}).getString(this.id);
        this.isVirtual = node.getNode(new Object[]{"isVirtual"}).getBoolean(false);
        if (!this.isVirtual.booleanValue()) {
            this.item = new Item(node.getNode(new Object[]{"item"}));
        }
        this.canLaunchCrate = this.isVirtual == false && node.getNode(new Object[]{"canLaunchCrate"}).getBoolean(false);
        this.crateIDToLaunch = node.getNode(new Object[]{"crateIDToLaunch"}).getString();
    }

    public Key(String id) {
        this.id = id;
        this.isVirtual = true;
        this.canLaunchCrate = false;
    }

    public Key(String id, Item item, boolean canLaunchCrate) {
        this.id = id;
        this.item = item;
        this.isVirtual = false;
        this.canLaunchCrate = canLaunchCrate;
        this.crateIDToLaunch = this.canLaunchCrate != false ? id.replace("LOCALKEY_", "") : null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            return this.item.getName();
        }
        return this.name;
    }

    public Boolean isVirtual() {
        return this.isVirtual;
    }

    public Boolean canLaunchCrate() {
        return this.canLaunchCrate;
    }

    public Crate crateToLaunch() {
        if (this.canLaunchCrate.booleanValue() && HuskyCrates.registry.isCrate(this.crateIDToLaunch)) {
            return HuskyCrates.registry.getCrate(this.crateIDToLaunch);
        }
        return null;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getKeyItemStack() {
        return this.getKeyItemStack(1);
    }

    public ItemStack getKeyItemStack(int amount) {
        if (this.isVirtual.booleanValue()) {
            return null;
        }
        DataContainer container = this.item.toItemStack().toContainer().set(DataQuery.of((String[])new String[]{"UnsafeData", "HCKEYID"}), (Object)this.id);
        if (HuskyCrates.KEY_SECURITY) {
            container = container.set(DataQuery.of((String[])new String[]{"UnsafeData", "HCKEYUUID"}), (Object)HuskyCrates.registry.generateSecureKey(this.id, amount).toString());
        }
        return ItemStack.builder().fromContainer((DataView)container).quantity(amount).build();
    }

    public static String extractKeyId(ItemStack stack) {
        try {
            return stack.toContainer().get(DataQuery.of((String[])new String[]{"UnsafeData", "HCKEYID"})).get().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static UUID extractKeyUUID(ItemStack stack) {
        Optional potentialUUID;
        if (HuskyCrates.KEY_SECURITY && (potentialUUID = stack.toContainer().get(DataQuery.of((String[])new String[]{"UnsafeData", "HCKEYUUID"}))).isPresent()) {
            try {
                return UUID.fromString(potentialUUID.get().toString());
            }
            catch (Exception e) {
                System.out.println(potentialUUID.get());
                return null;
            }
        }
        return null;
    }

    public boolean testKey(ItemStack stack) {
        if (this.isVirtual.booleanValue()) {
            return false;
        }
        return this.id.equals(Key.extractKeyId(stack)) && stack.getType().equals(this.item.getItemType());
    }
}

