/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.Util;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Item;
import com.codehusky.huskycrates.crate.virtual.effects.Effect;
import com.codehusky.huskycrates.exception.ConfigError;
import com.codehusky.huskycrates.exception.ConfigParseError;
import com.codehusky.huskycrates.exception.InjectionDataError;
import com.codehusky.huskycrates.exception.RewardDeliveryError;
import com.sun.istack.internal.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Slot {
    private Item displayItem;
    private List<Reward> rewards = new ArrayList<Reward>();
    private List<List<Reward>> rewardGroups = new ArrayList<List<Reward>>();
    private Integer chance;
    private Boolean pickRandom;
    private Integer pickSize;
    private Boolean pickUnique;

    public Slot(ConfigurationNode node, Crate holder) {
        this.displayItem = new Item(node.getNode(new Object[]{"displayItem"}));
        for (ConfigurationNode rNode : node.getNode(new Object[]{"rewards"}).getChildrenList()) {
            if (rNode.hasListChildren()) {
                ArrayList<Reward> rewardGroup = new ArrayList<Reward>();
                for (ConfigurationNode rgNode : rNode.getChildrenList()) {
                    rewardGroup.add(new Reward(rgNode, node.getNode(new Object[]{"displayItem"}), holder));
                }
                this.rewardGroups.add(rewardGroup);
                continue;
            }
            this.rewards.add(new Reward(rNode, node.getNode(new Object[]{"displayItem"}), holder));
        }
        if (this.rewards.size() == 0 && this.rewardGroups.size() == 0) {
            HuskyCrates.instance.logger.warn("Slot has no rewards @ " + ConfigError.readablePath(node.getNode(new Object[]{"rewards"}).getPath()));
        }
        if (node.getNode(new Object[]{"chance"}).isVirtual()) {
            throw new ConfigParseError("Chance not specified in reward.", node.getNode(new Object[]{"chance"}).getPath());
        }
        this.chance = node.getNode(new Object[]{"chance"}).getInt();
        this.pickRandom = node.getNode(new Object[]{"pickRandom"}).getBoolean(false);
        if (this.pickRandom.booleanValue()) {
            this.pickSize = node.getNode(new Object[]{"pickSize"}).getInt(1);
            if (this.pickSize > this.rewards.size() + this.rewardGroups.size()) {
                throw new ConfigParseError("pickSize is bigger than the amount of rewards.", node.getNode(new Object[]{"pickSize"}).getPath());
            }
            this.pickUnique = node.getNode(new Object[]{"pickUnique"}).getBoolean(true);
        }
    }

    public Slot(@NotNull Item displayItem, List<Reward> rewards, List<List<Reward>> rewardGroups, @NotNull Integer chance, Boolean pickRandom, Integer pickSize, Boolean pickUnique) {
        this.displayItem = displayItem;
        this.chance = chance;
        this.rewards = rewards != null ? rewards : new ArrayList<Reward>();
        this.rewardGroups = rewardGroups != null ? rewardGroups : new ArrayList<List<Reward>>();
        if (pickRandom != null) {
            this.pickRandom = pickRandom;
            if (this.pickRandom.booleanValue()) {
                this.pickSize = pickSize != null ? pickSize : Integer.valueOf(1);
                this.pickUnique = pickUnique != null ? pickUnique : Boolean.valueOf(true);
            }
        } else {
            this.pickRandom = false;
        }
    }

    public boolean rewardPlayer(Player player, Location<World> crateLocation) {
        ArrayList<Reward> theseRewards = new ArrayList<Reward>(this.rewards);
        theseRewards.addAll(this.rewardGroups);
        if (this.pickRandom.booleanValue()) {
            ArrayList<Reward> availRewards = new ArrayList<Reward>(this.rewards);
            availRewards.addAll(this.rewardGroups);
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.pickSize; ++i) {
                Object selected = availRewards.get(new Random().nextInt(availRewards.size()));
                arrayList.add(selected);
                if (!this.pickUnique.booleanValue()) continue;
                availRewards.remove(selected);
            }
            theseRewards = arrayList;
        }
        try {
            for (Object e : theseRewards) {
                if (e instanceof Reward) {
                    ((Reward)e).actOnReward(player, crateLocation);
                    continue;
                }
                if (!(e instanceof List)) continue;
                for (Reward rr : (List)e) {
                    rr.actOnReward(player, crateLocation);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "A fatal error has occurred while trying to deliver your reward. Please contact server administration."}));
            return false;
        }
        return true;
    }

    public Integer getChance() {
        return this.chance;
    }

    public Item getDisplayItem() {
        return this.displayItem;
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public static enum RewardType {
        USERCOMMAND,
        SERVERCOMMAND,
        USERMESSAGE,
        SERVERMESSAGE,
        ITEM,
        EFFECT,
        KEY;

    }

    public static class Reward {
        private RewardType rewardType;
        private String rewardString;
        private Item rewardItem;
        private Item displayItem;
        private Effect effect;
        private boolean effectOnPlayer = false;
        private Integer keyCount = 1;
        private String crateid;

        private Reward(ConfigurationNode node, ConfigurationNode displayItemNode, Crate holder) {
            this.crateid = holder.getId();
            try {
                this.rewardType = RewardType.valueOf(node.getNode(new Object[]{"type"}).getString("").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigParseError("Invalid reward type or no reward type specified.", node.getNode(new Object[]{"type"}).getPath());
            }
            this.displayItem = new Item(displayItemNode);
            if (this.rewardType == RewardType.USERCOMMAND || this.rewardType == RewardType.SERVERCOMMAND || this.rewardType == RewardType.SERVERMESSAGE || this.rewardType == RewardType.USERMESSAGE || this.rewardType == RewardType.KEY) {
                this.rewardString = node.getNode(new Object[]{"data"}).getString();
                if (this.rewardString == null) {
                    throw new ConfigParseError("No data specified for reward.", node.getNode(new Object[]{"data"}).getPath());
                }
                if (this.rewardType == RewardType.KEY) {
                    if (!(HuskyCrates.registry.isKey(this.rewardString) || holder.hasLocalKey() || holder.getLocalKey().getId().equals(this.rewardString))) {
                        throw new ConfigParseError("Invalid key ID!", node.getNode(new Object[]{"data"}).getPath());
                    }
                    this.keyCount = node.getNode(new Object[]{"keyCount"}).getInt(1);
                }
            } else if (this.rewardType == RewardType.ITEM) {
                this.rewardItem = node.getNode(new Object[]{"item"}).isVirtual() ? this.displayItem : new Item(node.getNode(new Object[]{"item"}));
            } else if (this.rewardType == RewardType.EFFECT) {
                this.effect = new Effect(node.getNode(new Object[]{"effect"}));
                this.effectOnPlayer = node.getNode(new Object[]{"effectOnPlayer"}).getBoolean(false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Reward(@NotNull Crate holder, @NotNull RewardType rewardType, String rewardString, Item rewardItem, Item slotDisplayItem, Effect effect, Boolean effectOnPlayer, Integer keyCount) {
            this.displayItem = slotDisplayItem;
            this.crateid = holder.getId();
            this.rewardType = rewardType;
            if (this.rewardType == RewardType.USERCOMMAND || this.rewardType == RewardType.SERVERCOMMAND || this.rewardType == RewardType.SERVERMESSAGE || this.rewardType == RewardType.USERMESSAGE || this.rewardType == RewardType.KEY) {
                this.rewardString = rewardString;
                if (rewardString == null) {
                    throw new InjectionDataError("No data specified for injected reward.");
                }
                if (this.rewardType != RewardType.KEY) return;
                if (!(HuskyCrates.registry.isKey(rewardString) || holder.hasLocalKey() || holder.getLocalKey().getId().equals(rewardString))) {
                    throw new InjectionDataError("Invalid injected key ID!");
                }
                if (keyCount == null) throw new InjectionDataError("You cannot inject null as keyCount.");
                this.keyCount = keyCount;
                return;
            } else if (this.rewardType == RewardType.ITEM) {
                if (rewardItem == null) {
                    if (slotDisplayItem == null) throw new InjectionDataError("Either slotDisplayItem or rewardItem must be an Item");
                    this.rewardItem = slotDisplayItem;
                    return;
                } else {
                    this.rewardItem = rewardItem;
                }
                return;
            } else {
                if (this.rewardType != RewardType.EFFECT) return;
                this.effect = effect;
                this.effectOnPlayer = effectOnPlayer != null ? effectOnPlayer : false;
            }
        }

        private String replaceCommand(Player player, Location<World> crateLocation) {
            ArrayList<String> vowels = new ArrayList<String>(Arrays.asList("a", "e", "i", "o", "u"));
            String pP = this.rewardString.replace("%p", player.getName()).replace("%P", player.getUniqueId().toString()).replace("%cxi", crateLocation.getBlockX() + "").replace("%cyi", crateLocation.getBlockY() + "").replace("%czi", crateLocation.getBlockZ() + "").replace("%cxd", crateLocation.getX() + "").replace("%cyd", crateLocation.getY() + "").replace("%czd", crateLocation.getZ() + "").replace("%pxi", player.getLocation().getBlockX() + "").replace("%pyi", player.getLocation().getBlockY() + "").replace("%pzi", player.getLocation().getBlockZ() + "").replace("%pxd", player.getLocation().getX() + "").replace("%pyd", player.getLocation().getY() + "").replace("%pzd", player.getLocation().getZ() + "").replace("%R", this.displayItem.getName() != null ? this.displayItem.getName() : this.displayItem.toItemStack().getTranslation().get()).replace("%a", this.displayItem.getName() != null && vowels.indexOf(this.displayItem.getName().substring(0, 1)) == 0 ? "an" : "a").replace("%C", HuskyCrates.registry.isCrate(this.crateid) ? HuskyCrates.registry.getCrate(this.crateid).getName() : "INVALID CRATE! (CONTACT ADMINS)");
            return pP;
        }

        public void actOnReward(Player player, Location<World> crateLocation) {
            block12: {
                try {
                    if (this.rewardType == RewardType.ITEM) {
                        InventoryTransactionResult result = Util.getHotbarFirst((Inventory)player.getInventory()).offer(this.rewardItem.toItemStack());
                        if (result.getType() != InventoryTransactionResult.Type.SUCCESS) {
                            throw new RewardDeliveryError("Failed to deliver item to " + player.getName() + " from reward.");
                        }
                        break block12;
                    }
                    if (this.rewardType == RewardType.SERVERMESSAGE) {
                        Sponge.getServer().getBroadcastChannel().send(TextSerializers.FORMATTING_CODE.deserialize(this.replaceCommand(player, crateLocation)));
                        break block12;
                    }
                    if (this.rewardType == RewardType.USERMESSAGE) {
                        player.sendMessage(TextSerializers.FORMATTING_CODE.deserialize(this.replaceCommand(player, crateLocation)));
                        break block12;
                    }
                    if (this.rewardType == RewardType.SERVERCOMMAND) {
                        Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), this.replaceCommand(player, crateLocation));
                        break block12;
                    }
                    if (this.rewardType == RewardType.USERCOMMAND) {
                        Sponge.getCommandManager().process((CommandSource)player, this.replaceCommand(player, crateLocation));
                        break block12;
                    }
                    if (this.rewardType == RewardType.EFFECT) {
                        HuskyCrates.registry.runEffect(this.effect, (Location<World>)(this.effectOnPlayer ? player.getLocation() : crateLocation));
                        break block12;
                    }
                    if (this.rewardType == RewardType.KEY) {
                        if (HuskyCrates.registry.getKey(this.rewardString) == null) {
                            throw new RewardDeliveryError("Failed to deliver key to " + player.getName() + ": \"" + this.rewardString + "\" is not a valid key id.");
                        }
                        InventoryTransactionResult result = Util.getHotbarFirst((Inventory)player.getInventory()).offer(HuskyCrates.registry.getKey(this.rewardString).getKeyItemStack(this.keyCount));
                        if (result.getType() != InventoryTransactionResult.Type.SUCCESS) {
                            throw new RewardDeliveryError("Failed to deliver key to " + player.getName() + " from reward.");
                        }
                        break block12;
                    }
                    throw new RewardDeliveryError("Failed to deliver reward to " + player.getName() + " due to invalid reward type. If you see this, contact the developer immediately.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RewardDeliveryError("Failed to deliver reward to " + player.getName() + ". See error above for more information.");
                }
            }
        }

        public RewardType getRewardType() {
            return this.rewardType;
        }
    }
}

