/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual.effects;

import com.codehusky.huskycrates.crate.virtual.effects.elements.Particle;
import com.codehusky.huskycrates.crate.virtual.effects.elements.Sound;
import java.util.ArrayList;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Effect {
    private long duration;
    private boolean loop;
    private boolean resetOnTimeout;
    private boolean finished = false;
    private boolean clientSide;
    private ArrayList<Particle> particles = new ArrayList();
    private ArrayList<Sound> sounds = new ArrayList();
    private boolean disabled;

    public Effect(ConfigurationNode node) {
        this.disabled = node.getNode(new Object[]{"disabled"}).getBoolean(false);
        if (this.disabled) {
            return;
        }
        this.duration = node.getNode(new Object[]{"duration"}).getLong(0L);
        this.loop = node.getNode(new Object[]{"loop"}).getBoolean(true);
        this.resetOnTimeout = node.getNode(new Object[]{"resetOnTimeout"}).getBoolean(false);
        this.clientSide = node.getNode(new Object[]{"clientSide"}).getBoolean(false);
        for (ConfigurationNode particleNode : node.getNode(new Object[]{"particles"}).getChildrenList()) {
            this.particles.add(new Particle(particleNode));
        }
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    public Effect(boolean disabled, long duration, boolean loop, boolean resetOnTimeout, boolean clientSide, ArrayList<Particle> particles) {
        this.disabled = disabled;
        this.duration = duration;
        this.loop = loop;
        this.resetOnTimeout = resetOnTimeout;
        this.clientSide = clientSide;
        this.particles = particles;
    }

    public Effect clone() {
        return new Effect(this.disabled, this.duration, this.loop, this.resetOnTimeout, this.clientSide, (ArrayList)this.particles.clone());
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public long tick(long ticks, Location<World> location, Player player) {
        if (this.disabled || this.finished) {
            return ticks;
        }
        for (Particle particle : this.particles) {
            particle.run(ticks, location, player);
        }
        if (ticks >= this.duration - 1L && (this.resetOnTimeout || !this.loop)) {
            if (!this.loop) {
                this.finished = true;
            } else {
                ticks = 0L;
            }
        } else {
            ++ticks;
        }
        return ticks;
    }

    public long tick(long ticks, Location<World> location) {
        return this.tick(ticks, location, null);
    }

    public void reset() {
        this.finished = false;
        this.duration = 0L;
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

