/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual.effects.elements;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.exception.ConfigParseError;
import com.codehusky.huskycrates.exception.InjectionDataError;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.reflect.TypeToken;
import com.sun.istack.internal.NotNull;
import java.util.ArrayList;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Particle {
    private ParticleEffect particle;
    private String animationCode;
    private boolean animateColor = false;
    private CompiledScript compiled;
    private int amount;
    private int quantity;
    private Vector3d offset;
    private Vector3d position;
    private Optional<String> preset = Optional.empty();
    private Optional<String> colorPreset = Optional.empty();
    private ArrayList<ParticleEffect> palette = new ArrayList();
    private ArrayList<ArrayList<Integer>> art = new ArrayList();

    public Particle(@NotNull ParticleEffect particle, int amount, int quantity, Vector3d offset, Vector3d position, String animationPreset, String colorPreset, Boolean animateColor, String animationCode) {
        this.particle = particle;
        this.amount = amount;
        this.quantity = quantity;
        this.offset = offset;
        this.position = position == null ? new Vector3d(0.5, 0.5, 0.5) : position;
        this.preset = Optional.ofNullable(animationPreset);
        this.colorPreset = Optional.ofNullable(colorPreset);
        this.animateColor = animateColor;
        this.animationCode = animationCode;
        if (this.animationCode == null && !this.preset.isPresent()) {
            throw new InjectionDataError("Must provide animation instructions for a Particle.");
        }
    }

    public Particle(ConfigurationNode node) {
        Optional pPT = Sponge.getRegistry().getType(ParticleType.class, node.getNode(new Object[]{"type"}).getString(""));
        if (!pPT.isPresent()) {
            throw new ConfigParseError("Invalid particle type!", node.getNode(new Object[]{"type"}).getPath());
        }
        this.amount = node.getNode(new Object[]{"amount"}).getInt(1);
        this.quantity = node.getNode(new Object[]{"quantity"}).getInt(1);
        if (!node.getNode(new Object[]{"offset"}).isVirtual() && node.getNode(new Object[]{"offset"}).hasListChildren()) {
            this.offset = new Vector3d(node.getNode(new Object[]{"offset", 0}).getDouble(0.0), node.getNode(new Object[]{"offset", 1}).getDouble(0.0), node.getNode(new Object[]{"offset", 2}).getDouble(0.0));
        }
        this.position = !node.getNode(new Object[]{"position"}).isVirtual() && node.getNode(new Object[]{"position"}).hasListChildren() ? new Vector3d(node.getNode(new Object[]{"position", 0}).getDouble(0.0), node.getNode(new Object[]{"position", 1}).getDouble(0.0), node.getNode(new Object[]{"position", 2}).getDouble(0.0)) : new Vector3d(0.5, 0.5, 0.5);
        if (!node.getNode(new Object[]{"palette"}).isVirtual()) {
            ArrayList potentialArt;
            for (ConfigurationNode colorNode : node.getNode(new Object[]{"palette"}).getChildrenList()) {
                ParticleEffect.Builder builder = ParticleEffect.builder();
                builder.type((ParticleType)pPT.get());
                builder.quantity(this.quantity);
                if (this.offset != null) {
                    builder.offset(this.offset);
                }
                Color clr = Color.ofRgb((int)colorNode.getNode(new Object[]{0}).getInt(0), (int)colorNode.getNode(new Object[]{1}).getInt(0), (int)colorNode.getNode(new Object[]{2}).getInt(0));
                builder.option(ParticleOptions.COLOR, (Object)clr);
                this.palette.add(builder.build());
            }
            if (node.getNode(new Object[]{"art"}).isVirtual()) {
                throw new ConfigParseError("Palette is defined but there is no art to go along with it.", node.getNode(new Object[]{"art"}).getPath());
            }
            try {
                potentialArt = (ArrayList)node.getNode(new Object[]{"art"}).getValue(TypeToken.of(ArrayList.class));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConfigParseError("Art is in invalid format.", node.getNode(new Object[]{"art"}).getPath());
            }
            this.art = potentialArt;
        } else {
            ParticleEffect.Builder builder = ParticleEffect.builder();
            builder.type((ParticleType)pPT.get());
            if (!node.getNode(new Object[]{"color"}).isVirtual() && node.getNode(new Object[]{"color"}).hasListChildren()) {
                builder.option(ParticleOptions.COLOR, (Object)Color.ofRgb((int)node.getNode(new Object[]{"color"}).getNode(new Object[]{0}).getInt(0), (int)node.getNode(new Object[]{"color"}).getNode(new Object[]{1}).getInt(0), (int)node.getNode(new Object[]{"color"}).getNode(new Object[]{2}).getInt(0)));
            }
            builder.quantity(this.quantity);
            if (this.offset != null) {
                builder.offset(this.offset);
            }
            this.particle = builder.build();
        }
        if (node.getNode(new Object[]{"animationPreset"}).isVirtual()) {
            this.animationCode = node.getNode(new Object[]{"animationCode"}).getString("x=Math.sin(time/5)*0.7;z=Math.cos(time/5)*0.7;");
            this.animateColor = node.getNode(new Object[]{"animateColor"}).getBoolean(false);
        } else {
            this.preset = Optional.ofNullable(node.getNode(new Object[]{"animationPreset"}).getString());
            this.colorPreset = Optional.ofNullable(node.getNode(new Object[]{"colorAnimationPreset"}).getString());
            if (this.colorPreset.isPresent()) {
                this.animateColor = true;
            }
        }
        if (!this.preset.isPresent()) {
            try {
                this.compiled = ((Compilable)((Object)HuskyCrates.jsengine)).compile("function HSVtoRGB(h,s,v){var r,g,b,i,f,p,q,t;if(arguments.length===1){s=h.s,v=h.v,h=h.h}i=Math.floor(h*6);f=h*6-i;p=v*(1-s);q=v*(1-f*s);t=v*(1-(1-f)*s);switch(i%6){case 0:r=v,g=t,b=p;break;case 1:r=q,g=v,b=p;break;case 2:r=p,g=v,b=t;break;case 3:r=p,g=q,b=v;break;case 4:r=t,g=p,b=v;break;case 5:r=v,g=p,b=q;break}return{r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)}} (function(time, num){var x = 0.0; var y = 0.0; var z = 0.0; var h; var s; var v; var r = -1; var g = -1; var b = -1; " + this.animationCode + "; if(h&&s&&v){var hsv = HSVtoRGB(h/255,s/255,v/255); r=hsv.r;g=hsv.g;b=hsv.b;} var result = {x:x,y:y,z:z,r:Math.round(r),g:Math.round(g),b:Math.round(b)}; return result;})(time, num);");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Particle(ParticleEffect effect, Vector3d position) {
        this.particle = effect;
        this.amount = 1;
        this.position = position;
    }

    public void run(long tick, Location<World> location, Player player) {
        for (int i = 0; i < this.amount; ++i) {
            Vector3d particlePos = location.getPosition().clone().add(this.position);
            ParticleEffect ourParticle = this.particle;
            Double x = 0.0;
            Double y = 0.0;
            Double z = 0.0;
            Integer r = null;
            Integer g = null;
            Integer b = null;
            if (this.animationCode != null && !this.preset.isPresent()) {
                try {
                    SimpleScriptContext sc = new SimpleScriptContext();
                    sc.setBindings(HuskyCrates.jsengine.createBindings(), 200);
                    Bindings bindings = sc.getBindings(200);
                    bindings.put("time", (Object)tick);
                    bindings.put("num", (Object)(i + 1));
                    sc.setBindings(bindings, 200);
                    ScriptObjectMirror scriptObjectMirror = (ScriptObjectMirror)this.compiled.eval(sc);
                    x = Double.valueOf("" + scriptObjectMirror.get((Object)"x"));
                    y = Double.valueOf("" + scriptObjectMirror.get((Object)"y"));
                    z = Double.valueOf("" + scriptObjectMirror.get((Object)"z"));
                    if ((Double)scriptObjectMirror.get((Object)"r") != -1.0 && (Double)scriptObjectMirror.get((Object)"g") != -1.0 && (Double)scriptObjectMirror.get((Object)"b") != -1.0) {
                        r = Math.max(0, Math.min(255, ((Double)scriptObjectMirror.get((Object)"r")).intValue()));
                        g = Math.max(0, Math.min(255, ((Double)scriptObjectMirror.get((Object)"g")).intValue()));
                        b = Math.max(0, Math.min(255, ((Double)scriptObjectMirror.get((Object)"b")).intValue()));
                    }
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            } else {
                if (this.preset.isPresent()) {
                    switch (this.preset.get().toLowerCase()) {
                        case "orbit": {
                            x = Math.sin((double)tick / 4.0) * 0.7;
                            y = Math.sin((double)tick / 4.0) * 0.2;
                            z = Math.cos((double)tick / 4.0) * 0.7;
                            break;
                        }
                        case "counterorbit": {
                            x = Math.cos((double)tick / 4.0) * 0.7;
                            y = Math.sin((double)tick / 4.0 + 10.0) * 0.2 - 0.1;
                            z = Math.sin((double)tick / 4.0) * 0.7;
                        }
                    }
                }
                if (this.colorPreset.isPresent()) {
                    switch (this.colorPreset.get().toLowerCase()) {
                        case "rainbow": {
                            this.animateColor = true;
                            java.awt.Color clr = java.awt.Color.getHSBColor(((float)tick * 5.0f % 255.0f + 1.0f) / 255.0f, 1.0f, 1.0f);
                            r = clr.getRed();
                            g = clr.getGreen();
                            b = clr.getBlue();
                            break;
                        }
                        default: {
                            this.animateColor = false;
                        }
                    }
                }
            }
            if (this.animateColor && r != null && g != null && b != null) {
                ourParticle = ParticleEffect.builder().from(ourParticle).option(ParticleOptions.COLOR, (Object)Color.ofRgb((int)r, (int)g, (int)b)).build();
            }
            particlePos = location.getPosition().clone().add(this.position).add(x.doubleValue(), y.doubleValue(), z.doubleValue());
            if (player != null) {
                player.spawnParticles(ourParticle, particlePos);
                continue;
            }
            ((World)location.getExtent()).spawnParticles(ourParticle, particlePos);
        }
    }
}

