/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual.views;

import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.views.ViewConfig;
import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.Page;
import com.codehusky.huskyui.states.State;
import com.codehusky.huskyui.states.element.Element;
import java.util.function.Consumer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SimpleView
implements Consumer<Page> {
    private Location<World> physicalLocation;
    private Crate crate;
    private int selectedSlot;
    private Player player;
    private ViewConfig config;
    private boolean safetyKill = false;

    public SimpleView(Crate ucrate, Player player, Location loc) {
        this.crate = ucrate;
        this.physicalLocation = loc;
        this.config = this.crate.getViewConfig();
        this.selectedSlot = this.crate.selectSlot();
        this.player = player;
        player.playSound(SoundTypes.ENTITY_FIREWORK_LAUNCH, player.getPosition(), 0.5);
        Page.PageBuilder builder = Page.builder().setAutoPaging(false).setTitle(TextSerializers.FORMATTING_CODE.deserialize(this.crate.getName())).setUpdatable(true).setUpdater((Consumer)this).setInterrupt(() -> {
            this.crate.getSlot(this.selectedSlot).rewardPlayer(player, this.physicalLocation);
            player.playSound(SoundTypes.ENTITY_EXPERIENCE_ORB_PICKUP, player.getLocation().getPosition(), 0.5);
        }).setInventoryDimension(InventoryDimension.of((int)3, (int)3)).setInventoryArchetype(InventoryArchetypes.DISPENSER);
        for (int i = 0; i < 9; ++i) {
            builder.putElement(i, new Element(i == 4 ? this.crate.getSlot(this.selectedSlot).getDisplayItem().toItemStack() : this.getConfetti()));
        }
        Page page = builder.build("meme");
        StateContainer sc = new StateContainer();
        sc.setInitialState((State)page);
        sc.launchFor(player);
    }

    private ItemStack getConfetti() {
        DyeColor[] colors = new DyeColor[]{DyeColors.BLUE, DyeColors.CYAN, DyeColors.LIGHT_BLUE, DyeColors.LIME, DyeColors.MAGENTA, DyeColors.ORANGE, DyeColors.PINK, DyeColors.PURPLE, DyeColors.RED, DyeColors.YELLOW};
        ItemStack g = ItemStack.builder().itemType(ItemTypes.STAINED_GLASS_PANE).add(Keys.DYE_COLOR, (Object)colors[(int)Math.floor(Math.random() * (double)colors.length)]).build();
        g.offer(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextStyles.RESET, "You win!"}));
        return g;
    }

    @Override
    public void accept(Page page) {
        int count = 0;
        for (Slot e : page.getPageView().slots()) {
            if (count != 4 && page.getTicks() % 5L == 0L) {
                e.set(this.getConfetti());
            }
            ++count;
        }
        if (page.getTicks() > 60L && !this.safetyKill) {
            page.getObserver().closeInventory();
            this.safetyKill = true;
            page.interrupt();
        }
    }
}

