/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskycrates.crate.virtual.views;

import com.codehusky.huskycrates.HuskyCrates;
import com.codehusky.huskycrates.crate.virtual.Crate;
import com.codehusky.huskycrates.crate.virtual.Item;
import com.codehusky.huskycrates.crate.virtual.views.ViewConfig;
import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.Page;
import com.codehusky.huskyui.states.State;
import com.codehusky.huskyui.states.element.Element;
import java.util.Random;
import java.util.function.Consumer;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpinnerView
implements Consumer<Page> {
    private Location<World> physicalLocation;
    private Crate crate;
    private int selectedSlot;
    private Player player;
    private Config config;
    int spinnerOffset = 0;
    int currentTicks = 0;
    double currentTickDelay = 1.0;
    int variance = 0;
    boolean rewardGiven = false;
    boolean hasWon = false;
    boolean safetyKill = false;
    long tickWinBegin = 0L;

    public SpinnerView(Crate ucrate, Player player, Location loc) {
        this.crate = ucrate;
        if (this.crate.isScrambled()) {
            this.crate = ucrate.getScrambledCrate();
        }
        this.physicalLocation = loc;
        this.config = (Config)this.crate.getViewConfig();
        this.variance = (int)Math.round(new Random().nextDouble() * (double)this.config.getTicksToSelectionVariance().intValue());
        this.selectedSlot = this.crate.selectSlot();
        this.player = player;
        player.playSound(SoundTypes.BLOCK_WOOD_BUTTON_CLICK_OFF, player.getPosition(), 1.0);
        Page.PageBuilder builder = Page.builder().setAutoPaging(false).setTitle(TextSerializers.FORMATTING_CODE.deserialize(this.crate.getName())).setUpdatable(true).setUpdater((Consumer)this).setInterrupt(() -> {
            if (this.rewardGiven) {
                return;
            }
            try {
                this.crate.getSlot(this.selectedSlot).rewardPlayer(player, this.physicalLocation);
                player.playSound(SoundTypes.ENTITY_EXPERIENCE_ORB_PICKUP, player.getLocation().getPosition(), 0.5);
            }
            catch (Exception e) {
                e.printStackTrace();
                HuskyCrates.instance.logger.error("Error occurred while trying to reward player.");
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "A fatal exception has occurred while delivering your reward. Please contact server administration."}));
            }
            this.rewardGiven = true;
        }).setInventoryDimension(InventoryDimension.of((int)9, (int)3));
        Element borderElement = new Element(this.config.getBorderItem().toItemStack());
        Element selectorItem = new Element(this.config.getSelectorItem().toItemStack());
        for (int i = 0; i < 27; ++i) {
            builder.putElement(i, i == 4 | i == 22 ? selectorItem : borderElement);
        }
        Page page = builder.build("meme");
        StateContainer sc = new StateContainer();
        sc.setInitialState((State)page);
        sc.launchFor(player);
    }

    private long getTicksToSelection() {
        return this.config.getTicksToSelection() + this.variance;
    }

    private boolean winCondition() {
        return (long)this.spinnerOffset > this.getTicksToSelection();
    }

    private ItemStack getConfetti() {
        DyeColor[] colors = new DyeColor[]{DyeColors.BLUE, DyeColors.CYAN, DyeColors.LIGHT_BLUE, DyeColors.LIME, DyeColors.MAGENTA, DyeColors.ORANGE, DyeColors.PINK, DyeColors.PURPLE, DyeColors.RED, DyeColors.YELLOW};
        ItemStack g = ItemStack.builder().itemType(ItemTypes.STAINED_GLASS_PANE).add(Keys.DYE_COLOR, (Object)colors[(int)Math.floor(Math.random() * (double)colors.length)]).build();
        g.offer(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{TextStyles.RESET, "You win!"}));
        return g;
    }

    @Override
    public void accept(Page page) {
        if (this.winCondition() && !this.hasWon) {
            this.hasWon = true;
            this.tickWinBegin = page.getTicks();
        }
        if (!this.hasWon) {
            int num = 0;
            for (Inventory slot : page.getPageView().slots()) {
                if (num >= 10 && num <= 16) {
                    int spinnerSlotAffected = num - 10;
                    int slotSelected = Math.max(0, this.spinnerOffset + spinnerSlotAffected - 3 + this.crate.getSlotCount() * 5);
                    slotSelected = (int)((long)slotSelected + ((long)this.selectedSlot - this.getTicksToSelection() % (long)this.crate.getSlotCount()));
                    slotSelected %= this.crate.getSlotCount();
                    if (!((double)this.currentTicks >= this.currentTickDelay) || num == 13) {
                        // empty if block
                    }
                    slot.set(this.crate.getSlot(slotSelected).getDisplayItem().toItemStack());
                }
                ++num;
            }
            if ((double)this.currentTicks >= this.currentTickDelay) {
                this.currentTicks = 0;
                this.currentTickDelay *= this.config.getTickDelayMultiplier().doubleValue();
                ++this.spinnerOffset;
                page.getObserver().playSound(this.winCondition() ? SoundTypes.ENTITY_FIREWORK_LAUNCH : SoundTypes.UI_BUTTON_CLICK, page.getObserver().getLocation().getPosition(), 0.5);
            }
            ++this.currentTicks;
        } else {
            if (page.getTicks() % 5L == 0L) {
                int num = 0;
                for (Inventory slot : page.getPageView().slots()) {
                    if (num != 13) {
                        slot.set(this.getConfetti());
                    }
                    ++num;
                }
            }
            if (page.getTicks() > this.tickWinBegin + 60L && !this.safetyKill) {
                page.getObserver().closeInventory();
                this.safetyKill = true;
                if (page.hasInterupt()) {
                    page.interrupt();
                }
            }
        }
    }

    public static class Config
    extends ViewConfig {
        private Item selectorItem;
        private Integer ticksToSelection;
        private Double tickDelayMultiplier;
        private Integer ticksToSelectionVariance;

        public Config(ConfigurationNode node) {
            super(node);
            this.selectorItem = !node.getNode(new Object[]{"selectorItem"}).isVirtual() ? new Item(node.getNode(new Object[]{"selectorItem"})) : new Item("&6HuskyCrates", ItemTypes.REDSTONE_TORCH, null, 1, null, null, null, null);
            System.out.println(node.getNode(new Object[]{"ticksToSelection"}).getValue());
            this.ticksToSelection = node.getNode(new Object[]{"ticksToSelection"}).getInt(30);
            this.tickDelayMultiplier = node.getNode(new Object[]{"tickDelayMultiplier"}).getDouble(1.08);
            this.ticksToSelectionVariance = node.getNode(new Object[]{"ticksToSelectionVariance"}).getInt(0);
        }

        public Item getSelectorItem() {
            return this.selectorItem;
        }

        public Integer getTicksToSelection() {
            return this.ticksToSelection;
        }

        public Double getTickDelayMultiplier() {
            return this.tickDelayMultiplier;
        }

        public Integer getTicksToSelectionVariance() {
            return this.ticksToSelectionVariance;
        }
    }
}

