/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot.Config;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.moddedminecraft.mmcreboot.Config.Config;
import net.moddedminecraft.mmcreboot.Main;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;

public class Messages {
    private static Main plugin;
    private Path defaultMessage;
    private static ConfigurationLoader<CommentedConfigurationNode> messageLoader;
    private static CommentedConfigurationNode messages;
    private static String[] restartVoteBroadcastDefault;
    private static String[] restartVoteBroadcastOnLoginDefault;
    private static String chatprefix;
    private static String sidebarTitle;
    private static String sidebarYes;
    private static String sidebarNo;
    private static String sidebarTimeleft;
    private static String sidebarRestartTimerTitle;
    private static String errorAlreadyVoted;
    private static String errorNoVoteRunning;
    private static String errorVoteToRestartDisabled;
    private static String errorVoteAlreadyRunning;
    private static String errorNotOnlineLongEnough;
    private static String errorMinPlayers;
    private static String errorAlreadyRestarting;
    private static String errorWaitTime;
    private static String errorNoPermission;
    private static String errorNoTaskScheduled;
    private static String errorTookTooLong;
    private static String errorInvalidTimescale;
    private static String errorNothingToConfirm;
    private static String restartCancel;
    private static String restartPassed;
    private static String restartVoteNotEnoughVoted;
    private static String votedYes;
    private static String votedNo;
    private static String restartMessageWithReason;
    private static String restartMessageWithoutReason;
    private static String restartFormatMessage;
    private static String restartConfirm;
    private static String restartConfirmMessage;
    private static List<String> restartVoteBroadcast;
    private static List<String> restartVoteBroadcastOnLogin;
    private static String restartNotificationMinutes;
    private static String restartNotificationMinute;
    private static String restartNotificationSeconds;
    private static String helpHeader;
    private static String helpHelp;
    private static String helpNow;
    private static String helpStart;
    private static String helpCancel;
    private static String helpVote;
    private static String helpTime;
    private static String helpVoteYea;
    private static String helpVoteNo;

    public Messages(Main main) throws IOException, ObjectMappingException {
        plugin = main;
        String language = Config.language;
        this.defaultMessage = Messages.plugin.configDir.resolve("localization/messages_" + language + ".conf");
        if (Files.notExists(this.defaultMessage, new LinkOption[0])) {
            Messages.plugin.logger.warn("Localization was not found");
        }
        messageLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.defaultMessage)).build();
        messages = (CommentedConfigurationNode)messageLoader.load();
        this.checkLangAssetFiles();
        this.messageCheck();
    }

    private void messageCheck() throws IOException, ObjectMappingException {
        sidebarTitle = this.check(messages.getNode(new Object[]{"sidebar", "vote", "title"}), sidebarTitle).getString();
        sidebarYes = this.check(messages.getNode(new Object[]{"sidebar", "vote", "yes"}), sidebarYes).getString();
        sidebarNo = this.check(messages.getNode(new Object[]{"sidebar", "vote", "no"}), sidebarNo).getString();
        sidebarTimeleft = this.check(messages.getNode(new Object[]{"sidebar", "restart", "time-left"}), sidebarTimeleft).getString();
        sidebarRestartTimerTitle = this.check(messages.getNode(new Object[]{"sidebar", "restart", "title"}), sidebarRestartTimerTitle).getString();
        errorAlreadyVoted = this.check(messages.getNode(new Object[]{"error", "already-voted"}), errorAlreadyVoted).getString();
        errorNoVoteRunning = this.check(messages.getNode(new Object[]{"error", "no-vote-running"}), errorNoVoteRunning).getString();
        errorVoteToRestartDisabled = this.check(messages.getNode(new Object[]{"error", "vote-restart-disabled"}), errorVoteToRestartDisabled).getString();
        errorVoteAlreadyRunning = this.check(messages.getNode(new Object[]{"error", "vote-already-running"}), errorVoteAlreadyRunning).getString();
        errorNotOnlineLongEnough = this.check(messages.getNode(new Object[]{"error", "not-online-long-enough"}), errorNotOnlineLongEnough).getString();
        errorMinPlayers = this.check(messages.getNode(new Object[]{"error", "min-players"}), errorMinPlayers).getString();
        errorAlreadyRestarting = this.check(messages.getNode(new Object[]{"error", "already-restarting"}), errorAlreadyRestarting).getString();
        errorWaitTime = this.check(messages.getNode(new Object[]{"error", "wait-time"}), errorWaitTime).getString();
        errorNoPermission = this.check(messages.getNode(new Object[]{"error", "no-permission"}), errorNoPermission).getString();
        errorNoTaskScheduled = this.check(messages.getNode(new Object[]{"error", "no-task-scheduled"}), errorNoTaskScheduled).getString();
        errorTookTooLong = this.check(messages.getNode(new Object[]{"error", "took-too-long"}), errorTookTooLong).getString();
        errorInvalidTimescale = this.check(messages.getNode(new Object[]{"error", "invalid-time-scale"}), errorInvalidTimescale).getString();
        errorNothingToConfirm = this.check(messages.getNode(new Object[]{"error", "nothing-to-confirm"}), errorNothingToConfirm).getString();
        restartCancel = this.check(messages.getNode(new Object[]{"general", "restart-canceled"}), restartCancel).getString();
        restartPassed = this.check(messages.getNode(new Object[]{"general", "restart-passed"}), restartPassed).getString();
        restartVoteNotEnoughVoted = this.check(messages.getNode(new Object[]{"general", "not-enough-voted"}), restartVoteNotEnoughVoted).getString();
        votedYes = this.check(messages.getNode(new Object[]{"general", "voted-yes"}), votedYes).getString();
        votedNo = this.check(messages.getNode(new Object[]{"general", "voted-no"}), votedNo).getString();
        restartMessageWithReason = this.check(messages.getNode(new Object[]{"general", "restart-with-reason"}), restartMessageWithReason).getString();
        restartMessageWithoutReason = this.check(messages.getNode(new Object[]{"general", "restart-no-reason"}), restartMessageWithoutReason).getString();
        restartFormatMessage = this.check(messages.getNode(new Object[]{"general", "restart-format"}), restartFormatMessage).getString();
        restartConfirm = this.check(messages.getNode(new Object[]{"general", "restart-confirmed"}), restartConfirm).getString();
        restartConfirmMessage = this.check(messages.getNode(new Object[]{"general", "confirm-restart"}), restartConfirmMessage).getString();
        restartVoteBroadcast = this.checkList(messages.getNode(new Object[]{"vote-notification", "after-command"}), restartVoteBroadcastDefault).getList(TypeToken.of(String.class));
        restartVoteBroadcastOnLogin = this.checkList(messages.getNode(new Object[]{"vote-notification", "on-login"}), restartVoteBroadcastOnLoginDefault).getList(TypeToken.of(String.class));
        restartNotificationMinutes = this.check(messages.getNode(new Object[]{"restart-notification", "more-than-1-minute-remaining"}), restartNotificationMinutes).getString();
        restartNotificationMinute = this.check(messages.getNode(new Object[]{"restart-notification", "only-1-minute-remaining"}), restartNotificationMinute).getString();
        restartNotificationSeconds = this.check(messages.getNode(new Object[]{"restart-notification", "less-than-1-minute-remaining"}), restartNotificationSeconds).getString();
        helpHeader = this.check(messages.getNode(new Object[]{"help", "header"}), helpHeader).getString();
        helpHelp = this.check(messages.getNode(new Object[]{"help", "help"}), helpHelp).getString();
        helpNow = this.check(messages.getNode(new Object[]{"help", "now"}), helpNow).getString();
        helpStart = this.check(messages.getNode(new Object[]{"help", "start"}), helpStart).getString();
        helpCancel = this.check(messages.getNode(new Object[]{"help", "cancel"}), helpCancel).getString();
        helpVote = this.check(messages.getNode(new Object[]{"help", "vote"}), helpVote).getString();
        helpTime = this.check(messages.getNode(new Object[]{"help", "time"}), helpTime).getString();
        helpVoteYea = this.check(messages.getNode(new Object[]{"help", "vote-yes"}), helpVoteYea).getString();
        helpVoteNo = this.check(messages.getNode(new Object[]{"help", "vote-no"}), helpVoteNo).getString();
        messageLoader.save((ConfigurationNode)messages);
    }

    private void checkLangAssetFiles() throws IOException {
        String[] assets;
        if (!Files.isDirectory(Messages.plugin.configDir.resolve("localization"), new LinkOption[0])) {
            Files.createDirectory(Messages.plugin.configDir.resolve("localization"), new FileAttribute[0]);
        }
        for (String asset : assets = new String[]{"messages_EN.conf", "messages_RU.conf"}) {
            if (Files.exists(Messages.plugin.configDir.resolve("localization/" + asset), new LinkOption[0]) || !Sponge.getAssetManager().getAsset((Object)plugin, asset).isPresent()) continue;
            ((Asset)Sponge.getAssetManager().getAsset((Object)plugin, asset).get()).copyToFile(Messages.plugin.configDir.resolve("localization/" + asset));
        }
    }

    private CommentedConfigurationNode check(CommentedConfigurationNode node, Object defaultValue) {
        if (node.isVirtual()) {
            node.setValue(defaultValue);
        }
        return node;
    }

    private CommentedConfigurationNode checkList(CommentedConfigurationNode node, String[] defaultValue) {
        if (node.isVirtual()) {
            node.setValue(Arrays.asList(defaultValue));
        }
        return node;
    }

    public static String getChatprefix() {
        return chatprefix;
    }

    public static String getRestartCancel() {
        return restartCancel;
    }

    public static String getSidebarTitle() {
        return sidebarTitle;
    }

    public static String getSidebarNo() {
        return sidebarNo;
    }

    public static String getSidebarYes() {
        return sidebarYes;
    }

    public static String getSidebarTimeleft() {
        return sidebarTimeleft;
    }

    public static String getSidebarRestartTimerTitle() {
        return sidebarRestartTimerTitle;
    }

    public static String getRestartMessageWithoutReason() {
        return restartMessageWithoutReason;
    }

    public static String getRestartMessageWithReason() {
        return restartMessageWithReason;
    }

    public static String getErrorInvalidTimescale() {
        return errorInvalidTimescale;
    }

    public static String getRestartFormatMessage() {
        return restartFormatMessage;
    }

    public static String getRestartConfirm() {
        return restartConfirm;
    }

    public static String getErrorNothingToConfirm() {
        return errorNothingToConfirm;
    }

    public static String getHelpCancel() {
        return helpCancel;
    }

    public static String getHelpHeader() {
        return helpHeader;
    }

    public static String getHelpHelp() {
        return helpHelp;
    }

    public static String getHelpVote() {
        return helpVote;
    }

    public static String getHelpNow() {
        return helpNow;
    }

    public static String getHelpStart() {
        return helpStart;
    }

    public static String getHelpTime() {
        return helpTime;
    }

    public static String getHelpVoteNo() {
        return helpVoteNo;
    }

    public static String getHelpVoteYea() {
        return helpVoteYea;
    }

    public static String getErrorTookTooLong() {
        return errorTookTooLong;
    }

    public static String getRestartConfirmMessage() {
        return restartConfirmMessage;
    }

    public static String getErrorNoTaskScheduled() {
        return errorNoTaskScheduled;
    }

    public static String getErrorNoPermission() {
        return errorNoPermission;
    }

    public static String getErrorAlreadyRestarting() {
        return errorAlreadyRestarting;
    }

    public static String getErrorAlreadyVoted() {
        return errorAlreadyVoted;
    }

    public static String getErrorMinPlayers() {
        return errorMinPlayers.replace("%config.timerminplayers%", String.valueOf(Config.timerMinplayers));
    }

    public static String getErrorNotOnlineLongEnough() {
        return errorNotOnlineLongEnough.replace("%config.timerstartvote%", String.valueOf(Config.timerStartvote));
    }

    public static String getErrorNoVoteRunning() {
        return errorNoVoteRunning;
    }

    public static String getErrorVoteAlreadyRunning() {
        return errorVoteAlreadyRunning;
    }

    public static String getErrorVoteToRestartDisabled() {
        return errorVoteToRestartDisabled;
    }

    public static String getErrorWaitTime() {
        return errorWaitTime.replace("%config.timerrevote%", String.valueOf(Config.timerRevote));
    }

    public static String getVotedNo() {
        return votedNo;
    }

    public static String getVotedYes() {
        return votedYes;
    }

    public static String getRestartVoteNotEnoughVoted() {
        return restartVoteNotEnoughVoted;
    }

    public static String getRestartPassed() {
        return restartPassed;
    }

    public static List<String> getRestartVoteBroadcast() {
        return restartVoteBroadcast;
    }

    public static List<String> getRestartVoteBroadcastOnLogin() {
        return restartVoteBroadcastOnLogin;
    }

    public static String getRestartNotificationMinute() {
        return restartNotificationMinute;
    }

    public static String getRestartNotificationMinutes() {
        return restartNotificationMinutes;
    }

    public static String getRestartNotificationSeconds() {
        return restartNotificationSeconds;
    }

    static {
        restartVoteBroadcastDefault = new String[]{"&a%playername$ &bhas voted that the server should be restarted", "&6Type &a/reboot vote yes &6if you agree", "&6Type &c/reboot vote no &6if you do not agree", "&6If there are more yes votes than no, The server will be restarted! (minimum of %config.timerminplayers%)", "&bYou have &a90 &bseconds to vote!"};
        restartVoteBroadcastOnLoginDefault = new String[]{"&3There is a vote to restart the server.", "&6Type &a/reboot vote yes &6if you agree", "&6Type &c/reboot vote no &6if you do not agree", "&6If there are more yes votes than no, The server will be restarted! (minimum of %config.timerminplayers%)"};
        chatprefix = "&f[&6MMCReboot&f] ";
        sidebarTitle = "Restart Vote";
        sidebarYes = "Yes";
        sidebarNo = "No";
        sidebarTimeleft = "Time Left";
        sidebarRestartTimerTitle = "Restart Timer";
        errorAlreadyVoted = "&4You have already voted!";
        errorNoVoteRunning = "&4There is no vote running at the moment";
        errorVoteToRestartDisabled = "&4Voting to restart is disabled";
        errorVoteAlreadyRunning = "&4A vote is already running";
        errorNotOnlineLongEnough = "&4The server needs to be online for %config.timerstartvote% minutes before starting a vote!";
        errorMinPlayers = "&4There must be a minimum of %config.timerminplayers% players online to start a vote";
        errorAlreadyRestarting = "&4The server is already restarting!";
        errorWaitTime = "&4You need to wait %config.timerrevote% minutes before starting another vote!";
        errorNoPermission = "&4You don't have permission to do this!";
        errorNoTaskScheduled = "&cThere is no restart scheduled!";
        errorTookTooLong = "&cYou took too long to confirm the reboot.";
        errorInvalidTimescale = "&cInvalid time scale!";
        errorNothingToConfirm = "&cThere is nothing to confirm.";
        restartCancel = "&3Restarts have been canceled.";
        restartPassed = "Players have voted to restart the server.";
        restartVoteNotEnoughVoted = "&3The server will not be restarted. Not enough people have voted.";
        votedYes = "You Voted Yes!";
        votedNo = "You Voted No!";
        restartMessageWithReason = "&3The server will now be restarting in &f%hours%h%minutes%m%seconds%s &3with the reason:";
        restartMessageWithoutReason = "&3The server will now be restarting in &f%hours%h%minutes%m%seconds%s";
        restartFormatMessage = "&bUse 'h' for time in hours, 'm' for minutes and 's' for seconds";
        restartConfirm = "&cOk, you asked for it!";
        restartConfirmMessage = "&cPlease type: &6/Reboot Confirm &cif you are sure you want to do this.";
        restartNotificationMinutes = "&bThe server will be restarting in &f%minutes%:%seconds% &bminutes";
        restartNotificationMinute = "&bThe server will be restarting in &f%minutes% &bminute";
        restartNotificationSeconds = "&bThe server will be restarting in &f%seconds% &bseconds";
        helpHeader = "&3[] = required  () = optional";
        helpHelp = "&3/reboot &bhelp - &7shows this help";
        helpNow = "&3/reboot &bnow - &7restarts the server instantly";
        helpStart = "&3/reboot start &7[&bh&7|&bm&7|&bs&7] &7[&btime&7] &7(&breason&7) &b- &7restart the server after a given time";
        helpCancel = "&3/reboot &bcancel - &7cancel any current restart timer";
        helpVote = "&3/reboot &bvote - &7starts a vote to restart the server";
        helpTime = "&3/reboot &btime - &7informs you how much time is left before restarting";
        helpVoteYea = "&3/reboot &bvote yes - &7vote yes to restart the server";
        helpVoteNo = "&3/reboot &bvote no - &7vote no to restart the server";
    }
}

