/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcreboot.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import net.moddedminecraft.mmcreboot.Config.Config;
import net.moddedminecraft.mmcreboot.Config.Messages;
import net.moddedminecraft.mmcreboot.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;

public class RebootVote
implements CommandExecutor {
    private final Main plugin;

    public RebootVote(Main instance) {
        this.plugin = instance;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optional = args.getOne("optional");
        if (optional.isPresent()) {
            String op;
            switch (op = (String)optional.get()) {
                case "on": {
                    if (src.hasPermission("mmcreboot.reboot.toggle.vote")) {
                        Config.voteEnabled = true;
                        Config.config.getNode(new Object[]{"voting", "enabled"}).setValue((Object)"true");
                        return CommandResult.success();
                    }
                    return CommandResult.empty();
                }
                case "off": {
                    if (src.hasPermission("mmcreboot.reboot.toggle.vote")) {
                        Config.voteEnabled = false;
                        Config.config.getNode(new Object[]{"voting", "enabled"}).setValue((Object)"false");
                        return CommandResult.success();
                    }
                    return CommandResult.empty();
                }
                case "yes": {
                    if (this.plugin.hasVoted.contains(src)) {
                        throw new CommandException(this.plugin.fromLegacy(Messages.getErrorAlreadyVoted()));
                    }
                    if (this.plugin.voteStarted) {
                        ++this.plugin.yesVotes;
                        if (src instanceof Player) {
                            this.plugin.hasVoted.add((Player)src);
                        }
                        this.plugin.displayVotes();
                        this.plugin.sendMessage(src, Messages.getVotedYes());
                        return CommandResult.success();
                    }
                    throw new CommandException(this.plugin.fromLegacy(Messages.getErrorNoVoteRunning()));
                }
                case "no": {
                    if (this.plugin.hasVoted.contains(src)) {
                        throw new CommandException(this.plugin.fromLegacy(Messages.getErrorAlreadyVoted()));
                    }
                    if (this.plugin.voteStarted) {
                        ++this.plugin.noVotes;
                        if (src instanceof Player) {
                            this.plugin.hasVoted.add((Player)src);
                        }
                        this.plugin.displayVotes();
                        this.plugin.sendMessage(src, Messages.getVotedNo());
                        return CommandResult.success();
                    }
                    throw new CommandException(this.plugin.fromLegacy(Messages.getErrorNoVoteRunning()));
                }
            }
            return CommandResult.empty();
        }
        double timeLeft = 0.0;
        if (Config.restartInterval > 0.0) {
            timeLeft = Config.restartInterval * 3600.0 - (double)(System.currentTimeMillis() - this.plugin.startTimestamp) / 1000.0;
        } else if (this.plugin.nextRealTimeRestart > 0.0) {
            timeLeft = this.plugin.nextRealTimeRestart - (double)(System.currentTimeMillis() - this.plugin.startTimestamp) / 1000.0;
        }
        int hours = (int)(timeLeft / 3600.0);
        int minutes = (int)((timeLeft - (double)(hours * 3600)) / 60.0);
        if (!src.hasPermission("mmcreboot.reboot.bypass") && !src.hasPermission("mmcreboot.reboot.vote")) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorNoPermission()));
        }
        if (!src.hasPermission("mmcreboot.reboot.bypass") && !Config.voteEnabled) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorVoteToRestartDisabled()));
        }
        if (this.plugin.hasVoted.contains(src)) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorAlreadyVoted()));
        }
        if (this.plugin.voteStarted) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorVoteAlreadyRunning()));
        }
        if (!src.hasPermission("mmcreboot.reboot.bypass") && this.plugin.justStarted) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorNotOnlineLongEnough()));
        }
        if (!src.hasPermission("mmcreboot.reboot.bypass") && Sponge.getServer().getOnlinePlayers().size() < Config.timerMinplayers) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorMinPlayers()));
        }
        if (this.plugin.isRestarting && timeLeft != 0.0 && hours == 0 && minutes <= 10) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorAlreadyRestarting()));
        }
        if (this.plugin.cdTimer) {
            throw new CommandException(this.plugin.fromLegacy(Messages.getErrorWaitTime()));
        }
        if (src instanceof Player) {
            Player player = (Player)src;
            this.plugin.voteStarted = true;
            this.plugin.voteCancel = false;
            this.plugin.hasVoted.add(player);
            ++this.plugin.yesVotes;
            this.plugin.noVotes = 0;
            this.plugin.voteSeconds = 90;
            this.plugin.displayVotes();
        } else {
            this.plugin.voteStarted = true;
            this.plugin.displayVotes();
        }
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        ArrayList<Text> contents = new ArrayList<Text>();
        List<String> broadcast = Messages.getRestartVoteBroadcast();
        if (broadcast != null) {
            for (String line : broadcast) {
                String checkLine = line.replace("%playername$", src.getName()).replace("%config.timerminplayers%", String.valueOf(Config.timerMinplayers));
                contents.add(this.plugin.fromLegacy(checkLine));
            }
        }
        if (!contents.isEmpty()) {
            paginationService.builder().title(this.plugin.fromLegacy("Restart")).contents(contents).padding((Text)Text.of((String)"=")).sendTo((Iterable)MessageChannel.TO_ALL.getMembers());
        }
        Timer voteTimer = new Timer();
        voteTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean requiredPercent;
                int Online = Sponge.getServer().getOnlinePlayers().size();
                int percentage = ((RebootVote)RebootVote.this).plugin.yesVotes / Online * 100;
                boolean yesAboveNo = ((RebootVote)RebootVote.this).plugin.yesVotes > ((RebootVote)RebootVote.this).plugin.noVotes;
                boolean yesAboveMin = ((RebootVote)RebootVote.this).plugin.yesVotes >= Config.timerMinplayers;
                boolean bl = requiredPercent = percentage >= Config.timerVotepercent;
                if (yesAboveNo && yesAboveMin && !((RebootVote)RebootVote.this).plugin.voteCancel && requiredPercent) {
                    ((RebootVote)RebootVote.this).plugin.isRestarting = true;
                    Config.restartInterval = (double)(Config.timerVotepassed + 1) / 3600.0;
                    ((RebootVote)RebootVote.this).plugin.logger.info("[MMCReboot] scheduling restart tasks...");
                    ((RebootVote)RebootVote.this).plugin.reason = Messages.getRestartPassed();
                    RebootVote.this.plugin.scheduleTasks();
                } else {
                    if (!((RebootVote)RebootVote.this).plugin.voteCancel) {
                        RebootVote.this.plugin.broadcastMessage("&f[&6Restart&f] " + Messages.getRestartVoteNotEnoughVoted());
                    }
                    ((RebootVote)RebootVote.this).plugin.voteCancel = false;
                    Timer voteTimer = new Timer();
                    voteTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ((RebootVote)RebootVote.this).plugin.cdTimer = false;
                        }
                    }, (long)((double)Config.timerRevote * 60000.0));
                }
                RebootVote.this.plugin.removeScoreboard();
                RebootVote.this.plugin.removeBossBar();
                ((RebootVote)RebootVote.this).plugin.yesVotes = 0;
                ((RebootVote)RebootVote.this).plugin.cdTimer = true;
                ((RebootVote)RebootVote.this).plugin.voteStarted = false;
                ((RebootVote)RebootVote.this).plugin.hasVoted.clear();
            }
        }, 90000L);
        return CommandResult.success();
    }
}

