/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.crafting.utils;

import com.sofodev.armorplus.common.container.base.InventoryCraftingImproved;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipeUtils {
    public static void checkRecipeShape(int width, int height, StringBuilder shape, ItemStack output, Object ... recipe) {
        if (width * height != shape.length()) {
            StringBuilder ret = new StringBuilder("Invalid shaped ore recipe: ");
            Arrays.stream(recipe).forEachOrdered(tmp -> ret.append(tmp).append(", "));
            ret.append(output);
            throw new RuntimeException(ret.toString());
        }
    }

    public static boolean matches(int width, int height, Object[] input, InventoryCraftingImproved inv) {
        return IntStream.rangeClosed(0, inv.func_174922_i() - width).anyMatch(x -> IntStream.rangeClosed(0, inv.func_174923_h() - height).anyMatch(y -> ShapedOreRecipeUtils.checkMatch(width, height, input, inv, x, y, true) || ShapedOreRecipeUtils.checkMatch(width, height, input, inv, x, y, false)));
    }

    private static boolean checkMatch(int width, int height, Object[] input, InventoryCraftingImproved inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < width && subY < height) {
                    target = mirror ? input[width - subX - 1 + subY * width] : input[subX + subY * width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }
}

