/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.armors.base;

import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemArmorBase;
import com.sofodev.armorplus.common.util.ArmorPlusItemUtils;
import com.sofodev.armorplus.common.util.EnumHelperUtil;
import com.sofodev.armorplus.common.util.LoaderUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class ItemSpecialArmor
extends ItemArmorBase {
    public EntityEquipmentSlot slot;
    private EnumAction wear = EnumHelperUtil.addAction("WEAR");
    public APArmorMaterial field_77878_bZ;
    private ItemStack repairStack;

    public ItemSpecialArmor(APArmorMaterial material, EntityEquipmentSlot slot) {
        super(material.getArmorMaterial(), slot, material.getName(), material.getName());
        this.setMaterial(material);
        this.setRepairStack(material.getRepairStack());
        this.setSlot(slot);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        boolean isUnbreakable = false;
        if (tagCompound != null) {
            isUnbreakable = tagCompound.func_74767_n("Unbreakable");
        }
        if (this.field_77878_bZ.isUnbreakable() && !isUnbreakable) {
            Utils.setUnbreakable(stack);
            LogHelper.info((Object)"Making The Ultimate Armor Unbreakable!");
        }
    }

    public APArmorMaterial getMaterial() {
        return this.field_77878_bZ;
    }

    public void setMaterial(APArmorMaterial material) {
        this.field_77878_bZ = material;
    }

    public void setSlot(EntityEquipmentSlot slot) {
        this.slot = slot;
    }

    public void setRepairStack(ItemStack repairStack) {
        this.repairStack = repairStack;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.getRarity(this.field_77878_bZ.getFormatting(), "Armor Color");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.field_77878_bZ.isEnabled()) {
            this.field_77878_bZ.onArmorTick(player, this.slot);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, this.repairStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        float perc;
        if ((this.field_77878_bZ == APArmorMaterial.GUARDIAN || this.field_77878_bZ == APArmorMaterial.SUPER_STAR || this.field_77878_bZ == APArmorMaterial.ENDER_DRAGON) && LoaderUtils.isDELoaded() && (perc = (float)ModConfig.IntegrationsConfig.normalChaosResistance) > 0.0f) {
            int displayPerc = MathHelper.func_76141_d((float)(perc * 100.0f));
            String out = new TextComponentTranslation("misc.armorplus.chaos.resistance", new Object[]{displayPerc + "%"}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)).func_150254_d();
            tooltip.add(TextFormatting.DARK_PURPLE + out);
        }
        this.field_77878_bZ.addInformation(stack, world, tooltip, advanced);
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.wear;
    }
}

