/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.handlers;

import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BaseItemHandler
extends ItemStackHandler {
    private int size;

    public BaseItemHandler() {
    }

    public BaseItemHandler(int size) {
        super(size);
        this.size = size;
    }

    public BaseItemHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public NonNullList<ItemStack> getItemStacks() {
        NonNullList list = NonNullList.func_191196_a();
        int numOfSlots = this.getSlots();
        for (int i = 0; i < numOfSlots; ++i) {
            list.add(i, (Object)this.getStackInSlot(i));
        }
        return list;
    }

    public boolean canInsertItem(ItemStack stack) {
        int availableSlots = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.getStackInSlot(i).func_190926_b()) {
                availableSlots += stack.func_77976_d();
                continue;
            }
            if (!ItemStack.func_179545_c((ItemStack)this.getStackInSlot(i), (ItemStack)stack)) continue;
            availableSlots = availableSlots + stack.func_77976_d() - this.getStackInSlot(i).func_190916_E();
        }
        return availableSlots >= stack.func_190916_E();
    }

    public ItemStack setInFirstAvailableSlot(ItemStack stack) {
        ItemStack remainder = ItemStack.field_190927_a;
        for (int i = 0; i < this.size; ++i) {
            if (this.getStackInSlot(i).func_190926_b()) {
                this.setStackInSlot(i, stack.func_77946_l());
                return remainder;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(i), (ItemStack)stack) || this.getStackInSlot(i).func_190916_E() >= this.getStackInSlot(i).func_77976_d()) continue;
            ItemStack itemInSlot = this.getStackInSlot(i);
            int available = itemInSlot.func_77976_d() - itemInSlot.func_190916_E();
            if (stack.func_190916_E() <= available) {
                itemInSlot.func_190917_f(stack.func_190916_E());
                return remainder;
            }
            int newSize = stack.func_190916_E() - available;
            itemInSlot.func_190917_f(available);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)newSize);
        }
        return remainder;
    }
}

