/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.trials;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import xt9.deepmoblearning.common.trials.Trial;

public class SkeletonTrial
extends Trial {
    public SkeletonTrial(String mobKey, int[] mobsPerWave) {
        super(mobKey, mobsPerWave);
    }

    @Override
    public EntityLiving getTrialPrimaryEntity(World world) {
        EntityMob e = this.getRandomSkeleton(world);
        e.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
        e.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 2) {
            ItemStack pewpewBow = new ItemStack((Item)Items.field_151031_f);
            pewpewBow.func_77966_a(Enchantment.func_185262_c((int)49), 1);
            pewpewBow.func_77966_a(Enchantment.func_185262_c((int)48), 2);
            e.func_184611_a(EnumHand.MAIN_HAND, pewpewBow);
            e.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag));
        } else if (rand < 25) {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
        } else if (rand < 50) {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151103_aS));
        } else {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151052_q));
        }
        return e;
    }

    @Override
    public NonNullList<ItemStack> getTrialRewards(int tier) {
        NonNullList rewards = NonNullList.func_191196_a();
        ItemStack pristine = this.data.getPristineMatterStack(1);
        switch (tier) {
            case 0: {
                pristine.func_190920_e(2);
                break;
            }
            case 1: {
                pristine.func_190920_e(3);
                break;
            }
            case 2: {
                pristine.func_190920_e(5);
                break;
            }
            case 3: {
                pristine.func_190920_e(12);
                break;
            }
            case 4: {
                pristine.func_190920_e(18);
            }
        }
        rewards.add((Object)pristine);
        return rewards;
    }

    private EntityMob getRandomSkeleton(World world) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 33) {
            return new EntityStray(world);
        }
        return new EntitySkeleton(world);
    }
}

