/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.trials.affix;

import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xt9.deepmoblearning.common.trials.affix.BlazeInvadersAffix;
import xt9.deepmoblearning.common.trials.affix.EmpoweredGlitchAffix;
import xt9.deepmoblearning.common.trials.affix.ITrialAffix;
import xt9.deepmoblearning.common.trials.affix.KnockbackImmuneAffix;
import xt9.deepmoblearning.common.trials.affix.LootHoarderAffix;
import xt9.deepmoblearning.common.trials.affix.RegenPartyAffix;
import xt9.deepmoblearning.common.trials.affix.SpeedAffix;
import xt9.deepmoblearning.common.trials.affix.ThunderDomeAffix;

public class TrialAffixFactory {
    public static ITrialAffix createAffix(String key, BlockPos pos, World world) {
        ITrialAffix trial = new SpeedAffix();
        if (key.equals("speed")) {
            trial = new SpeedAffix();
        } else if (key.equals("regen_party")) {
            trial = new RegenPartyAffix(pos, world);
        } else if (key.equals("empowered_glitches")) {
            trial = new EmpoweredGlitchAffix();
        } else if (key.equals("knockback_immunity")) {
            trial = new KnockbackImmuneAffix();
        } else if (key.equals("blaze_invaders")) {
            trial = new BlazeInvadersAffix(pos, world);
        } else if (key.equals("loot_hoarders")) {
            trial = new LootHoarderAffix(pos, world);
        } else if (key.equals("thunderdome")) {
            trial = new ThunderDomeAffix(pos, world);
        }
        return trial;
    }

    public static NonNullList<ITrialAffix> getAllAffixes() {
        NonNullList affixes = NonNullList.func_191196_a();
        affixes.add((Object)new SpeedAffix());
        affixes.add((Object)new RegenPartyAffix());
        affixes.add((Object)new EmpoweredGlitchAffix());
        affixes.add((Object)new KnockbackImmuneAffix());
        affixes.add((Object)new BlazeInvadersAffix());
        affixes.add((Object)new LootHoarderAffix());
        affixes.add((Object)new ThunderDomeAffix());
        return affixes;
    }
}

