/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.claiming;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class FillCommand
extends AbstractCommand {
    private final ProtectionConfig protectionConfig;

    public FillCommand(EagleFactions plugin) {
        super(plugin);
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (!this.isPlayer(source)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        boolean isAdmin = super.getPlugin().getPlayerManager().hasAdminMode((User)player);
        Faction playerFaction = optionalPlayerFaction.get();
        if (!isAdmin && !super.getPlugin().getPermsManager().canClaim(player.getUniqueId(), playerFaction)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.PLAYERS_WITH_YOUR_RANK_CANT_CLAIM_LANDS}));
        }
        World world = player.getWorld();
        if (!this.canClaimInWorld(world, isAdmin)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANNOT_CLAIM_TERRITORIES_IN_THIS_WORLD}));
        }
        if (this.isFactionUnderAttack(playerFaction)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOUR_FACTION_IS_UNDER_ATTACK + " ", MessageLoader.parseMessage(Messages.YOU_NEED_TO_WAIT_NUMBER_SECONDS_TO_BE_ABLE_TO_CLAIM_AGAIN, TextColors.RED, Collections.singletonMap(Placeholders.NUMBER, Text.of((Object[])new Object[]{TextColors.GOLD, EagleFactionsPlugin.ATTACKED_FACTIONS.get(playerFaction.getName())})))}));
        }
        this.fill(player, playerFaction);
        return CommandResult.success();
    }

    private boolean canClaimInWorld(World world, boolean isAdmin) {
        if (this.protectionConfig.getClaimableWorldNames().contains(world.getName())) {
            return true;
        }
        return this.protectionConfig.getNotClaimableWorldNames().contains(world.getName()) && isAdmin;
    }

    private boolean hasReachedClaimLimit(Faction faction) {
        return super.getPlugin().getPowerManager().getFactionMaxClaims(faction) <= faction.getClaims().size();
    }

    private boolean isFactionUnderAttack(Faction faction) {
        return EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(faction.getName());
    }

    private void fill(Player player, Faction faction) throws CommandException {
        UUID worldUUID = player.getWorld().getUniqueId();
        LinkedList<Vector3i> chunks = new LinkedList<Vector3i>();
        chunks.add(player.getLocation().getChunkPosition());
        while (!chunks.isEmpty()) {
            if (this.hasReachedClaimLimit(faction)) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOUR_FACTION_DOES_NOT_HAVE_POWER_TO_CLAIM_MORE_LANDS}));
            }
            Vector3i chunkPosition = (Vector3i)chunks.poll();
            if (super.getPlugin().getFactionLogic().isClaimed(worldUUID, chunkPosition)) continue;
            faction = super.getPlugin().getFactionLogic().getFactionByName(faction.getName());
            super.getPlugin().getFactionLogic().startClaiming(player, faction, worldUUID, chunkPosition);
            chunks.add(chunkPosition.add(1, 0, 0));
            chunks.add(chunkPosition.add(-1, 0, 0));
            chunks.add(chunkPosition.add(0, 0, 1));
            chunks.add(chunkPosition.add(0, 0, -1));
        }
    }
}

