/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.general;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Collections;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class LeaveCommand
extends AbstractCommand {
    public LeaveCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Player player = this.requirePlayerSource(source);
        Faction faction = this.requirePlayerFaction(player);
        if (faction.getLeader().equals(player.getUniqueId())) {
            if (super.getPlugin().getPlayerManager().hasAdminMode((User)player)) {
                return this.leaveFaction(player, faction, true);
            }
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_LEAVE_YOUR_FACTION_BECAUSE_YOU_ARE_ITS_LEADER + " " + Messages.DISBAND_YOUR_FACTION_OR_SET_SOMEONE_AS_LEADER}));
        }
        return this.leaveFaction(player, faction, false);
    }

    private CommandResult leaveFaction(Player player, Faction faction, boolean hasAdminMode) {
        boolean isCancelled = EventRunner.runFactionLeaveEventPre(player, faction);
        if (isCancelled) {
            return CommandResult.success();
        }
        if (hasAdminMode) {
            super.getPlugin().getRankManager().setLeader(null, faction);
        } else {
            super.getPlugin().getFactionLogic().leaveFaction(player.getUniqueId(), faction.getName());
        }
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_LEFT_FACTION, TextColors.GREEN, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, faction.getName()})))}));
        EagleFactionsPlugin.AUTO_CLAIM_LIST.remove(player.getUniqueId());
        EagleFactionsPlugin.CHAT_LIST.remove(player.getUniqueId());
        EventRunner.runFactionLeaveEventPost(player, faction);
        return CommandResult.success();
    }
}

