/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.rank;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.exception.PlayerNotInFactionException;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class DemoteCommand
extends AbstractCommand {
    public DemoteCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        FactionPlayer demotedPlayer = (FactionPlayer)context.requireOne("player");
        if (!this.isPlayer(source)) {
            return this.demoteByConsole(source, demotedPlayer);
        }
        Player sourcePlayer = this.requirePlayerSource(source);
        Faction playerFaction = this.requirePlayerFaction(sourcePlayer);
        super.getPlugin().getFactionLogic().getFactionByPlayerUUID(demotedPlayer.getUniqueId()).filter(faction -> faction.getName().equals(playerFaction.getName())).orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLAYER_IS_NOT_IN_YOUR_FACTION})));
        return this.tryDemotePlayer(playerFaction, sourcePlayer, demotedPlayer);
    }

    private CommandResult tryDemotePlayer(Faction faction, Player sourcePlayer, FactionPlayer targetPlayer) throws CommandException {
        boolean hasAdminMode = super.getPlugin().getPlayerManager().hasAdminMode((User)sourcePlayer);
        FactionMemberType sourcePlayerMemberType = faction.getPlayerMemberType(sourcePlayer.getUniqueId());
        FactionMemberType targetPlayerMemberType = targetPlayer.getFactionRole();
        if (hasAdminMode) {
            if (targetPlayerMemberType == FactionMemberType.RECRUIT) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_DEMOTE_THIS_PLAYER_MORE}));
            }
            if (targetPlayerMemberType == FactionMemberType.LEADER) {
                super.getPlugin().getRankManager().setLeader(null, faction);
                sourcePlayer.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DEMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, Messages.OFFICER})))}));
                return CommandResult.success();
            }
            return this.demotePlayer(sourcePlayer, targetPlayer);
        }
        List<FactionMemberType> demotableRoles = this.getDemotableRolesForRole(sourcePlayerMemberType);
        if (!demotableRoles.contains((Object)targetPlayerMemberType)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_DEMOTE_THIS_PLAYER_MORE}));
        }
        return this.demotePlayer(sourcePlayer, targetPlayer);
    }

    private CommandResult demoteByConsole(CommandSource source, FactionPlayer demotedPlayer) throws CommandException {
        Faction faction = demotedPlayer.getFaction().orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "This player is not in a faction."})));
        FactionMemberType targetPlayerRole = demotedPlayer.getFactionRole();
        if (targetPlayerRole == FactionMemberType.LEADER) {
            super.getPlugin().getRankManager().setLeader(null, faction);
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DEMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, Messages.OFFICER})))}));
            return CommandResult.success();
        }
        if (targetPlayerRole == FactionMemberType.RECRUIT) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_DEMOTE_THIS_PLAYER_MORE}));
        }
        FactionMemberType oldRank = demotedPlayer.getFactionRole();
        FactionMemberType demotedTo = null;
        try {
            demotedTo = super.getPlugin().getRankManager().demotePlayer(null, demotedPlayer);
            if (oldRank != demotedTo) {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DEMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedTo.name()})))}));
            }
        }
        catch (PlayerNotInFactionException playerNotInFactionException) {
            // empty catch block
        }
        return CommandResult.success();
    }

    private CommandResult demotePlayer(Player demotedBy, FactionPlayer demotedPlayer) {
        try {
            FactionMemberType demotedTo = this.getPlugin().getRankManager().demotePlayer(demotedBy, demotedPlayer);
            demotedBy.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DEMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedTo.name()})))}));
        }
        catch (PlayerNotInFactionException playerNotInFactionException) {
            // empty catch block
        }
        return CommandResult.success();
    }

    private List<FactionMemberType> getDemotableRolesForRole(FactionMemberType factionMemberType) {
        if (factionMemberType != FactionMemberType.LEADER && factionMemberType != FactionMemberType.OFFICER) {
            return Collections.emptyList();
        }
        ArrayList<FactionMemberType> roles = new ArrayList<FactionMemberType>(Arrays.asList(FactionMemberType.values()));
        roles.remove((Object)FactionMemberType.ALLY);
        roles.remove((Object)FactionMemberType.TRUCE);
        roles.remove((Object)FactionMemberType.RECRUIT);
        roles.remove((Object)FactionMemberType.NONE);
        if (factionMemberType == FactionMemberType.LEADER) {
            roles.remove((Object)FactionMemberType.LEADER);
        } else {
            roles.remove((Object)FactionMemberType.LEADER);
            roles.remove((Object)FactionMemberType.OFFICER);
        }
        return roles;
    }
}

