/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.rank;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.exception.PlayerNotInFactionException;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PromoteCommand
extends AbstractCommand {
    public PromoteCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        FactionPlayer promotedPlayer = (FactionPlayer)context.requireOne("player");
        if (!this.isPlayer(source)) {
            return this.promoteByConsole(source, promotedPlayer);
        }
        Player sourcePlayer = this.requirePlayerSource(source);
        Faction playerFaction = this.requirePlayerFaction(sourcePlayer);
        promotedPlayer.getFaction().filter(faction -> faction.getName().equals(playerFaction.getName())).orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLAYER_IS_NOT_IN_YOUR_FACTION})));
        return this.tryPromotePlayer(playerFaction, sourcePlayer, promotedPlayer);
    }

    private CommandResult tryPromotePlayer(Faction faction, Player sourcePlayer, FactionPlayer targetPlayer) throws CommandException {
        boolean hasAdminMode = super.getPlugin().getPlayerManager().hasAdminMode((User)sourcePlayer);
        FactionMemberType sourcePlayerMemberType = faction.getPlayerMemberType(sourcePlayer.getUniqueId());
        FactionMemberType targetPlayerMemberType = targetPlayer.getFactionRole();
        if (hasAdminMode) {
            if (targetPlayerMemberType == FactionMemberType.OFFICER) {
                super.getPlugin().getRankManager().setLeader(targetPlayer, faction);
                sourcePlayer.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_PROMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, Messages.LEADER})))}));
                return CommandResult.success();
            }
            if (targetPlayerMemberType == FactionMemberType.LEADER) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_PROMOTE_THIS_PLAYER_MORE}));
            }
            return this.promotePlayer(sourcePlayer, targetPlayer);
        }
        List<FactionMemberType> promotableRoles = this.getPromotableRolesForRole(sourcePlayerMemberType);
        if (!promotableRoles.contains((Object)targetPlayerMemberType)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_PROMOTE_THIS_PLAYER_MORE}));
        }
        return this.promotePlayer(sourcePlayer, targetPlayer);
    }

    private CommandResult promoteByConsole(CommandSource source, FactionPlayer promotedPlayer) throws CommandException {
        Faction faction = promotedPlayer.getFaction().orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "This player is not in a faction."})));
        FactionMemberType targetPlayerRole = promotedPlayer.getFactionRole();
        if (targetPlayerRole == FactionMemberType.OFFICER) {
            super.getPlugin().getRankManager().setLeader(promotedPlayer, faction);
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_PROMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, promotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, Messages.LEADER})))}));
            return CommandResult.success();
        }
        if (targetPlayerRole == FactionMemberType.LEADER) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_PROMOTE_THIS_PLAYER_MORE}));
        }
        try {
            FactionMemberType promotedTo = super.getPlugin().getRankManager().promotePlayer(null, promotedPlayer);
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_PROMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, promotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, promotedTo.name()})))}));
        }
        catch (PlayerNotInFactionException playerNotInFactionException) {
            // empty catch block
        }
        return CommandResult.success();
    }

    private CommandResult promotePlayer(Player promotedBy, FactionPlayer promotedPlayer) {
        try {
            FactionMemberType promotedTo = this.getPlugin().getRankManager().promotePlayer(promotedBy, promotedPlayer);
            promotedBy.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_PROMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, promotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, promotedTo.name()})))}));
        }
        catch (PlayerNotInFactionException playerNotInFactionException) {
            // empty catch block
        }
        return CommandResult.success();
    }

    private List<FactionMemberType> getPromotableRolesForRole(FactionMemberType factionMemberType) {
        if (factionMemberType != FactionMemberType.LEADER && factionMemberType != FactionMemberType.OFFICER) {
            return Collections.emptyList();
        }
        ArrayList<FactionMemberType> roles = new ArrayList<FactionMemberType>(Arrays.asList(FactionMemberType.values()));
        roles.remove((Object)FactionMemberType.ALLY);
        roles.remove((Object)FactionMemberType.TRUCE);
        roles.remove((Object)FactionMemberType.OFFICER);
        roles.remove((Object)FactionMemberType.LEADER);
        roles.remove((Object)FactionMemberType.NONE);
        if (factionMemberType == FactionMemberType.OFFICER) {
            roles.remove((Object)FactionMemberType.MEMBER);
        }
        return roles;
    }
}

