/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.relation;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.ArmisticeRequest;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.managers.InvitationManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class EnemyCommand
extends AbstractCommand {
    private InvitationManager invitationManager;

    public EnemyCommand(EagleFactions plugin) {
        super(plugin);
        this.invitationManager = plugin.getInvitationManager();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Player player;
        Faction playerFaction;
        Faction enemyFaction = (Faction)context.requireOne((Text)Text.of((String)"faction"));
        ArmisticeRequest armisticeRequest = this.findArmisticeRequest(enemyFaction, playerFaction = this.requirePlayerFaction(player = this.requirePlayerSource(source)));
        if (armisticeRequest != null) {
            armisticeRequest.accept();
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_HAVE_ACCEPTED_ARMISTICE_REQUEST_FROM_FACTION, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, enemyFaction.getName()})))}));
        } else {
            this.sendRequest(player, playerFaction, enemyFaction);
        }
        return CommandResult.success();
    }

    @Nullable
    private ArmisticeRequest findArmisticeRequest(Faction senderFaction, Faction invitedFaction) {
        return EagleFactionsPlugin.RELATION_INVITES.stream().filter(ArmisticeRequest.class::isInstance).map(ArmisticeRequest.class::cast).filter(armisticeRequest -> armisticeRequest.getInvitedFaction().equals(invitedFaction.getName()) && armisticeRequest.getSenderFaction().equals(senderFaction.getName())).findFirst().orElse(null);
    }

    private void sendRequest(Player player, Faction playerFaction, Faction targetFaction) {
        this.invitationManager.sendArmisticeOrWarRequest(player, playerFaction, targetFaction);
    }
}

