/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.relation;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.TruceRequest;
import io.github.aquerr.eaglefactions.api.managers.InvitationManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class TruceCommand
extends AbstractCommand {
    private final InvitationManager invitationManager;

    public TruceCommand(EagleFactions plugin) {
        super(plugin);
        this.invitationManager = plugin.getInvitationManager();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Player player;
        Faction playerFaction;
        Faction selectedFaction = (Faction)context.requireOne((Text)Text.of((String)"faction"));
        TruceRequest truceRequest = this.findTruceRequest(selectedFaction, playerFaction = this.requirePlayerFaction(player = this.requirePlayerSource(source)));
        if (truceRequest != null) {
            truceRequest.accept();
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_HAVE_ACCEPTED_AN_INVITATION_FROM_FACTION, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, selectedFaction.getName()})))}));
        } else {
            if (this.findTruceRequest(playerFaction, selectedFaction) != null) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_HAVE_ALREADY_INVITED_THIS_FACTION_TO_THE_TRUCE}));
            }
            this.sendInvite(player, playerFaction, selectedFaction);
        }
        return CommandResult.success();
    }

    @Nullable
    private TruceRequest findTruceRequest(Faction senderFaction, Faction invitedFaction) {
        return EagleFactionsPlugin.RELATION_INVITES.stream().filter(TruceRequest.class::isInstance).map(TruceRequest.class::cast).filter(truceRequest -> truceRequest.getInvitedFaction().equals(invitedFaction.getName()) && truceRequest.getSenderFaction().equals(senderFaction.getName())).findFirst().orElse(null);
    }

    private void sendInvite(Player player, Faction playerFaction, Faction targetFaction) {
        this.invitationManager.sendTruceRequest(player, playerFaction, targetFaction);
    }
}

