/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.config;

import com.google.common.reflect.TypeToken;
import io.github.aquerr.eaglefactions.api.config.Configuration;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ProtectionConfigImpl
implements ProtectionConfig {
    private final Configuration configuration;
    private ConfigurationLoader<CommentedConfigurationNode> configurationLoader;
    private CommentedConfigurationNode worldsConfigNode;
    private boolean protectWildernessFromPlayers = false;
    private boolean protectFromMobGrief = false;
    private boolean protectFromMobGriefWarZone = false;
    private boolean allowExplosionsByOtherPlayersInClaims = false;
    private boolean protectWarZoneFromPlayers = true;
    private boolean spawnMobsInSafeZone = true;
    private boolean spawnMobsInWarZone = true;
    private boolean spawnHostileMobsInWarZone = true;
    private boolean spawnMobsInFactionsTerritory = true;
    private boolean spawnHostileMobsInFactionsTerritory = true;
    private Set<String> claimableWorldNames = new HashSet<String>();
    private Set<String> notClaimableWorldNames = new HashSet<String>();
    private Set<String> safeZoneWorldNames = new HashSet<String>();
    private Set<String> warZoneWorldNames = new HashSet<String>();
    private ProtectionConfig.WhiteList safeZoneWhiteLists = null;
    private ProtectionConfig.WhiteList warZoneWhiteLists = null;
    private ProtectionConfig.WhiteList factionWhiteLists = null;
    private ProtectionConfig.WhiteList wildernessWhiteLists = null;

    public ProtectionConfigImpl(Configuration configuration) {
        this.configuration = configuration;
        try {
            Optional worldsFile = Sponge.getAssetManager().getAsset((Object)EagleFactionsPlugin.getPlugin(), "Worlds.conf");
            if (worldsFile.isPresent()) {
                ((Asset)worldsFile.get()).copyToDirectory(configuration.getConfigDirectoryPath(), false, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(configuration.getConfigDirectoryPath().resolve("Worlds.conf"))).build();
        this.loadWorldsFile();
        this.saveWorldsFile();
    }

    @Override
    public void reload() {
        this.loadWorldsFile();
        this.protectWildernessFromPlayers = this.configuration.getBoolean(false, "protect-wilderness-from-players");
        this.protectFromMobGrief = this.configuration.getBoolean(false, "protect-from-mob-grief");
        this.protectFromMobGriefWarZone = this.configuration.getBoolean(false, "protect-from-mob-grief-warzone");
        this.allowExplosionsByOtherPlayersInClaims = this.configuration.getBoolean(false, "allow-explosions-by-other-players-in-claims");
        this.protectWarZoneFromPlayers = this.configuration.getBoolean(true, "protect-warzone-from-players");
        this.spawnMobsInSafeZone = this.configuration.getBoolean(true, "spawn-mobs-in-safezone");
        this.spawnMobsInWarZone = this.configuration.getBoolean(true, "spawn-mobs-in-warzone");
        this.spawnHostileMobsInWarZone = this.configuration.getBoolean(true, "spawn-hostile-mobs-in-warzone");
        this.spawnMobsInFactionsTerritory = this.configuration.getBoolean(true, "spawn-mobs-in-factions-territory");
        this.spawnHostileMobsInFactionsTerritory = this.configuration.getBoolean(true, "spawn-hostile-mobs-in-factions-territory");
        try {
            this.claimableWorldNames = new HashSet<String>(this.worldsConfigNode.getNode(new Object[]{"worlds", "CLAIMABLE"}).getList(TypeToken.of(String.class), new ArrayList()));
            this.notClaimableWorldNames = new HashSet<String>(this.worldsConfigNode.getNode(new Object[]{"worlds", "NOT_CLAIMABLE"}).getList(TypeToken.of(String.class), new ArrayList()));
            this.safeZoneWorldNames = new HashSet<String>(this.worldsConfigNode.getNode(new Object[]{"worlds", "SAFE_ZONE"}).getList(TypeToken.of(String.class), new ArrayList()));
            this.warZoneWorldNames = new HashSet<String>(this.worldsConfigNode.getNode(new Object[]{"worlds", "WAR_ZONE"}).getList(TypeToken.of(String.class), new ArrayList()));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        Set<String> factionItemsWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "normal-faction", "items-whitelist");
        Set<String> factionPlaceDestroyWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "normal-faction", "place-destroy-whitelist");
        Set<String> factionInteractWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "normal-faction", "interact-whitelist");
        this.factionWhiteLists = new WhiteListsImpl(factionItemsWhiteList, factionInteractWhiteList, factionPlaceDestroyWhiteList);
        Set<String> safeZoneItemsWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "safe-zone", "items-whitelist");
        Set<String> safeZonePlaceDestroyWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "safe-zone", "place-destroy-whitelist");
        Set<String> safeZoneInteractWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "safe-zone", "interact-whitelist");
        this.safeZoneWhiteLists = new WhiteListsImpl(safeZoneItemsWhiteList, safeZoneInteractWhiteList, safeZonePlaceDestroyWhiteList);
        Set<String> warZoneItemsWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "war-zone", "items-whitelist");
        Set<String> warZonePlaceDestroyWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "war-zone", "place-destroy-whitelist");
        Set<String> warZoneInteractWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "war-zone", "interact-whitelist");
        this.warZoneWhiteLists = new WhiteListsImpl(warZoneItemsWhiteList, warZoneInteractWhiteList, warZonePlaceDestroyWhiteList);
        Set<String> wildernessItemsWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "wilderness", "items-whitelist");
        Set<String> wildernessPlaceDestroyWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "wilderness", "place-destroy-whitelist");
        Set<String> wildernessInteractWhiteList = this.configuration.getSetOfStrings(new HashSet<String>(), "allowed-items-and-blocks", "wilderness", "interact-whitelist");
        this.wildernessWhiteLists = new WhiteListsImpl(wildernessItemsWhiteList, wildernessInteractWhiteList, wildernessPlaceDestroyWhiteList);
    }

    @Override
    public Set<String> getClaimableWorldNames() {
        return this.claimableWorldNames;
    }

    @Override
    public Set<String> getNotClaimableWorldNames() {
        return this.notClaimableWorldNames;
    }

    @Override
    public Set<String> getSafeZoneWorldNames() {
        return this.safeZoneWorldNames;
    }

    @Override
    public Set<String> getWarZoneWorldNames() {
        return this.warZoneWorldNames;
    }

    @Override
    public ProtectionConfig.WhiteList getFactionWhitelists() {
        return this.factionWhiteLists;
    }

    @Override
    public ProtectionConfig.WhiteList getSafeZoneWhitelists() {
        return this.safeZoneWhiteLists;
    }

    @Override
    public ProtectionConfig.WhiteList getWarZoneWhitelists() {
        return this.warZoneWhiteLists;
    }

    @Override
    public ProtectionConfig.WhiteList getWildernessWhitelists() {
        return this.wildernessWhiteLists;
    }

    @Override
    public Set<String> getDetectedWorldNames() {
        HashSet<String> detectedWorldNames = new HashSet<String>();
        detectedWorldNames.addAll(this.getClaimableWorldNames());
        detectedWorldNames.addAll(this.getNotClaimableWorldNames());
        detectedWorldNames.addAll(this.getSafeZoneWorldNames());
        detectedWorldNames.addAll(this.getWarZoneWorldNames());
        return detectedWorldNames;
    }

    @Override
    public void addWorld(String name) {
        this.claimableWorldNames.add(name);
        this.worldsConfigNode.getNode(new Object[]{"worlds", "CLAIMABLE"}).setValue(this.claimableWorldNames);
        this.saveWorldsFile();
    }

    @Override
    public boolean canSpawnMobsInSafeZone() {
        return this.spawnMobsInSafeZone;
    }

    @Override
    public boolean canSpawnMobsInWarZone() {
        return this.spawnMobsInWarZone;
    }

    @Override
    public boolean canSpawnHostileMobsInWarZone() {
        return this.spawnHostileMobsInWarZone;
    }

    @Override
    public boolean canSpawnMobsInFactionsTerritory() {
        return this.spawnMobsInFactionsTerritory;
    }

    @Override
    public boolean canSpawnHostileMobsInFactionsTerritory() {
        return this.spawnHostileMobsInFactionsTerritory;
    }

    @Override
    public boolean shouldProtectClaimFromMobGrief() {
        return this.protectFromMobGrief;
    }

    @Override
    public boolean shouldProtectWarZoneFromMobGrief() {
        return this.protectFromMobGriefWarZone;
    }

    @Override
    public boolean shouldAllowExplosionsByOtherPlayersInClaims() {
        return this.allowExplosionsByOtherPlayersInClaims;
    }

    @Override
    public boolean shouldProtectWarzoneFromPlayers() {
        return this.protectWarZoneFromPlayers;
    }

    @Override
    public boolean shouldProtectWildernessFromPlayers() {
        return this.protectWildernessFromPlayers;
    }

    private void loadWorldsFile() {
        try {
            this.worldsConfigNode = (CommentedConfigurationNode)this.configurationLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveWorldsFile() {
        try {
            this.configurationLoader.save((ConfigurationNode)this.worldsConfigNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final class WhiteListsImpl
    implements ProtectionConfig.WhiteList {
        private Set<String> whitelistedItems;
        private Set<String> whitelistedPlaceDestroyBlocks;
        private Set<String> whitelistedInteractBlocks;

        protected WhiteListsImpl(Set<String> whitelistedItems, Set<String> whitelistedInteractBlocks, Set<String> whitelistedPlaceDestroyBlocks) {
            this.whitelistedInteractBlocks = whitelistedInteractBlocks;
            this.whitelistedItems = whitelistedItems;
            this.whitelistedPlaceDestroyBlocks = whitelistedPlaceDestroyBlocks;
        }

        @Override
        public Set<String> getWhiteListedItems() {
            return this.whitelistedItems;
        }

        @Override
        public Set<String> getWhiteListedPlaceDestroyBlocks() {
            return this.whitelistedPlaceDestroyBlocks;
        }

        @Override
        public Set<String> getWhiteListedInteractBlocks() {
            return this.whitelistedInteractBlocks;
        }

        @Override
        public boolean isItemWhiteListed(String itemId) {
            return this.isWhiteListed(this.getWhiteListedItems(), itemId);
        }

        @Override
        public boolean isBlockWhitelistedForPlaceDestroy(String blockId) {
            return this.isWhiteListed(this.getWhiteListedPlaceDestroyBlocks(), blockId);
        }

        @Override
        public boolean isBlockWhiteListedForInteraction(String blockId) {
            return this.isWhiteListed(this.getWhiteListedInteractBlocks(), blockId);
        }

        private boolean isWhiteListed(Collection<String> collection, String id) {
            for (String whiteListedIdPattern : collection) {
                if (whiteListedIdPattern.equals(id)) {
                    return true;
                }
                try {
                    Pattern pattern = Pattern.compile(whiteListedIdPattern);
                    if (!pattern.matcher(id).matches()) continue;
                    return true;
                }
                catch (PatternSyntaxException exception) {
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "The syntax of your pattern is wrong. Id = " + whiteListedIdPattern}));
                }
            }
            return false;
        }
    }
}

