/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.integrations.dynmap;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.DynmapUpdateTask;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class DynmapService {
    static MarkerAPI markerapi;
    static MarkerSet markerSet;
    static final ArrayList<Faction> drawnFactions;
    static final HashMap<String, Marker> drawnMarkers;
    static final HashMap<String, ArrayList<AreaMarker>> drawnAreas;
    private final EagleFactions plugin;
    private Task dynmapUpdateTask;

    public DynmapService(EagleFactions plugin) {
        this.plugin = plugin;
    }

    public void activate() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI api) {
                markerapi = api.getMarkerAPI();
                markerSet = DynmapService.this.createOrGetMarkerSet();
                if (markerSet == null) {
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not create MarkerSet in Dynmap. Restarting the server may help."}));
                    return;
                }
                DynmapService.this.restartDynmapUpdateTask();
            }
        });
    }

    public void reload() {
        drawnFactions.clear();
        drawnMarkers.values().forEach(GenericMarker::deleteMarker);
        drawnMarkers.clear();
        drawnAreas.values().forEach(x -> {
            x.forEach(GenericMarker::deleteMarker);
            x.clear();
        });
        drawnAreas.clear();
        markerSet.deleteMarkerSet();
        markerSet = this.createOrGetMarkerSet();
        this.restartDynmapUpdateTask();
    }

    private MarkerSet createOrGetMarkerSet() {
        MarkerSet markerSet = markerapi.getMarkerSet("purpleflag");
        if (markerSet == null) {
            markerSet = markerapi.createMarkerSet("purpleflag", "EagleFactions", markerapi.getMarkerIcons(), false);
        }
        return markerSet;
    }

    private void restartDynmapUpdateTask() {
        if (this.dynmapUpdateTask != null) {
            this.dynmapUpdateTask.cancel();
        }
        this.dynmapUpdateTask = EagleFactionsScheduler.getInstance().scheduleWithDelayedIntervalAsync(new DynmapUpdateTask(), 0L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
    }

    static {
        drawnFactions = new ArrayList();
        drawnMarkers = new HashMap();
        drawnAreas = new HashMap();
    }
}

