/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.integrations.dynmap;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.DynmapService;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.util.DynmapUtils;
import io.github.aquerr.eaglefactions.common.integrations.dynmap.util.TempAreaMarker;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsRunnableTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.World;

public class DynmapUpdateTask
implements EagleFactionsRunnableTask {
    @Override
    public String getName() {
        return "eaglefactions-dynmap-update-task";
    }

    @Override
    public void run() {
        Iterator<Faction> iterator = DynmapService.drawnFactions.iterator();
        while (iterator.hasNext()) {
            Faction drawnFaction = iterator.next();
            Faction faction = EagleFactionsPlugin.getPlugin().getFactionLogic().getFactionByName(drawnFaction.getName());
            if (faction != null && !this.hasNewClaims(drawnFaction, faction) && !this.hasNewHome(drawnFaction, faction)) continue;
            if (DynmapService.drawnMarkers.get(drawnFaction.getName()) != null) {
                DynmapService.drawnMarkers.get(drawnFaction.getName()).deleteMarker();
                DynmapService.drawnMarkers.remove(drawnFaction.getName());
            }
            if (DynmapService.drawnAreas.get(drawnFaction.getName()) != null) {
                for (AreaMarker drawFactionArea : DynmapService.drawnAreas.get(drawnFaction.getName())) {
                    drawFactionArea.deleteMarker();
                }
                DynmapService.drawnAreas.remove(drawnFaction.getName());
            }
            iterator.remove();
        }
        for (Faction faction : EagleFactionsPlugin.getPlugin().getFactionLogic().getFactions().values()) {
            if (faction.getClaims().size() < 1 || DynmapService.drawnFactions.contains(faction)) continue;
            if (faction.getHome() != null) {
                World factionHomeWorld;
                World world = factionHomeWorld = Sponge.getServer().getWorld(faction.getHome().getWorldUUID()).isPresent() ? (World)Sponge.getServer().getWorld(faction.getHome().getWorldUUID()).get() : null;
                if (factionHomeWorld != null) {
                    Vector3i blockPos = faction.getHome().getBlockPosition();
                    Marker marker = DynmapService.markerSet.createMarker(null, faction.getName() + " Home", factionHomeWorld.getName(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), DynmapService.markerapi.getMarkerIcon(EagleFactionsPlugin.getPlugin().getConfiguration().getDynmapConfig().getDynmapFactionHomeIcon()), false);
                    DynmapService.drawnMarkers.put(faction.getName(), marker);
                }
            }
            HashMap<UUID, Set> claimsWorld = new HashMap<UUID, Set>();
            Marker claims = new Claim[faction.getClaims().size()];
            for (Claim claim : claims = faction.getClaims().toArray((T[])claims)) {
                claimsWorld.computeIfAbsent(claim.getWorldUUID(), k -> new HashSet());
                ((Set)claimsWorld.get(claim.getWorldUUID())).add(claim);
            }
            HashMap areaMarkers = new HashMap();
            claimsWorld.forEach((k, v) -> {
                ArrayList<TempAreaMarker> tempMarkers = DynmapUtils.createAreas(v);
                areaMarkers.put(k, tempMarkers);
            });
            DynmapService.drawnAreas.put(faction.getName(), new ArrayList());
            for (Map.Entry entry : areaMarkers.entrySet()) {
                for (TempAreaMarker tempMarker : (ArrayList)entry.getValue()) {
                    World world;
                    World world2 = world = Sponge.getServer().getWorld((UUID)entry.getKey()).isPresent() ? (World)Sponge.getServer().getWorld((UUID)entry.getKey()).get() : null;
                    if (world == null) continue;
                    AreaMarker areaMarker = DynmapService.markerSet.createAreaMarker(null, faction.getName(), false, world.getName(), new double[1000], new double[1000], false);
                    areaMarker.setDescription(DynmapUtils.getFactionInfoWindow(faction));
                    int areaColor = DynmapUtils.getAreaColor(faction);
                    areaMarker.setLineStyle(3, 0.8, areaColor);
                    areaMarker.setFillStyle(0.35, areaColor);
                    areaMarker.setCornerLocations(tempMarker.x, tempMarker.z);
                    DynmapService.drawnAreas.get(faction.getName()).add(areaMarker);
                }
            }
            DynmapService.drawnFactions.add(faction);
        }
    }

    private boolean hasNewClaims(Faction drawnFaction, Faction faction) {
        return drawnFaction.getClaims().hashCode() != faction.getClaims().hashCode();
    }

    private boolean hasNewHome(Faction drawnFaction, Faction faction) {
        return !Objects.equals(drawnFaction.getHome(), faction.getHome());
    }
}

