/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.util.ModSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.command.source.CommandBlockSource;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.entity.hanging.ItemFrame;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;

public class BlockBreakListener
extends AbstractListener {
    private final FactionsConfig factionsConfig;
    private final ProtectionConfig protectionConfig;

    public BlockBreakListener(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onBlockPre(ChangeBlockEvent.Pre event) {
        block21: {
            boolean isLeafDecay;
            boolean isFireSource;
            boolean isLiquidSource;
            boolean pistonExtend;
            User user;
            block20: {
                Location sourceLocation;
                if (event.getCause().containsType(CommandBlockSource.class)) {
                    return;
                }
                user = null;
                if (event.getCause().containsType(Player.class)) {
                    user = (User)event.getCause().first(Player.class).get();
                } else if (event.getCause().containsType(User.class)) {
                    user = (User)event.getCause().first(User.class).get();
                }
                LocatableBlock locatableBlock = event.getCause().first(LocatableBlock.class).orElse(null);
                TileEntity tileEntity = event.getCause().first(TileEntity.class).orElse(null);
                pistonExtend = event.getContext().containsKey(EventContextKeys.PISTON_EXTEND);
                boolean pistonRetract = event.getContext().containsKey(EventContextKeys.PISTON_RETRACT);
                isLiquidSource = event.getContext().containsKey(EventContextKeys.LIQUID_FLOW) || locatableBlock != null && (locatableBlock.getBlockState().getType() == BlockTypes.FLOWING_WATER || locatableBlock.getBlockState().getType() == BlockTypes.FLOWING_LAVA);
                isFireSource = !isLiquidSource && event.getContext().containsKey(EventContextKeys.FIRE_SPREAD);
                isLeafDecay = event.getContext().containsKey(EventContextKeys.LEAVES_DECAY);
                boolean isForgePlayerBreak = event.getContext().containsKey(EventContextKeys.PLAYER_BREAK);
                Object object = locatableBlock != null ? locatableBlock.getLocation() : (sourceLocation = tileEntity != null ? tileEntity.getLocation() : null);
                if (isForgePlayerBreak) {
                    if (user == null) {
                        user = event.getContext().get(EventContextKeys.OWNER).orElse(event.getContext().get(EventContextKeys.NOTIFIER).orElse(null));
                    }
                    if (user == null) {
                        user = event.getContext().get(EventContextKeys.FAKE_PLAYER).orElse(null);
                    }
                    if (user instanceof Player) {
                        for (Location location : event.getLocations()) {
                            if (location.getBlockType() == BlockTypes.AIR || super.getPlugin().getProtectionManager().canBreak((Location<World>)location, user, true).hasAccess()) continue;
                            event.setCancelled(true);
                            return;
                        }
                    }
                }
                if (sourceLocation == null) break block20;
                ArrayList<Location> sourceLocations = event.getLocations();
                if (pistonExtend || pistonRetract) {
                    Location location;
                    sourceLocations = new ArrayList<Location>(event.getLocations());
                    location = (Location)sourceLocations.get(sourceLocations.size() - 1);
                    Direction direction = (Direction)locatableBlock.getLocation().getBlock().get(Keys.DIRECTION).get();
                    Location directionLocation = location.getBlockRelative(direction);
                    sourceLocations.add(directionLocation);
                    if (user == null) {
                        user = event.getContext().get(EventContextKeys.OWNER).orElse(null);
                    }
                }
                if (user == null) {
                    user = event.getContext().get(EventContextKeys.OWNER).orElse(event.getContext().get(EventContextKeys.NOTIFIER).orElse(null));
                }
                for (Location location : sourceLocations) {
                    Optional<Faction> optionalChunkFaction;
                    if (user != null && (pistonExtend || pistonRetract) && !super.getPlugin().getProtectionManager().canBreak((Location<World>)location, user, true).hasAccess()) {
                        event.setCancelled(true);
                        return;
                    }
                    if (isFireSource && (optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition())).isPresent() && optionalChunkFaction.get().isSafeZone()) {
                        event.setCancelled(true);
                        return;
                    }
                    if (isLeafDecay || !isLiquidSource && location.getBlock().getType() == BlockTypes.AIR) continue;
                    if (user != null && !super.getPlugin().getProtectionManager().canBreak((Location<World>)location, user, true).hasAccess()) {
                        event.setCancelled(true);
                        return;
                    }
                    if (user != null || super.getPlugin().getProtectionManager().canBreak((Location<World>)location).hasAccess()) continue;
                    event.setCancelled(true);
                    return;
                }
                break block21;
            }
            if (user == null) break block21;
            for (Location location : event.getLocations()) {
                if (pistonExtend && !super.getPlugin().getProtectionManager().canBreak((Location<World>)location, user, true).hasAccess()) {
                    event.setCancelled(true);
                }
                if (isFireSource) {
                    Optional<Faction> optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition());
                    if (this.protectionConfig.getSafeZoneWorldNames().contains(((World)location.getExtent()).getName()) || optionalChunkFaction.isPresent() && optionalChunkFaction.get().getName().equalsIgnoreCase("SafeZone")) {
                        event.setCancelled(true);
                        return;
                    }
                }
                if (isLiquidSource || isLeafDecay || super.getPlugin().getProtectionManager().canBreak((Location<World>)location, user, true).hasAccess()) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onBlockBreak(ChangeBlockEvent.Break event) {
        boolean isPlacementSpawnType;
        boolean isCustomSpawnType;
        if (event.getCause().containsType(CommandBlockSource.class)) {
            return;
        }
        boolean bl = isCustomSpawnType = event.getContext().get(EventContextKeys.SPAWN_TYPE).isPresent() && event.getContext().get(EventContextKeys.SPAWN_TYPE).get() == SpawnTypes.CUSTOM;
        if (event instanceof ExplosionEvent || event.getCause().containsType(Explosion.class)) {
            return;
        }
        boolean bl2 = isPlacementSpawnType = event.getContext().get(EventContextKeys.SPAWN_TYPE).isPresent() && event.getContext().get(EventContextKeys.SPAWN_TYPE).get() == SpawnTypes.PLACEMENT;
        if (isPlacementSpawnType) {
            return;
        }
        Object source = event.getSource();
        User user = null;
        if (source instanceof Entity) {
            if (ModSupport.isMekenism((Entity)source)) {
                Entity owner = ModSupport.getEntityOwnerFromMekanism((Entity)source);
                if (owner instanceof User) {
                    user = (User)owner;
                }
            } else {
                Entity entity = (Entity)source;
                String id = entity.getType().getId();
                String name = entity.getType().getName();
                if (id.startsWith("icbmclassic:missile") || id.startsWith("icbmclassic:grenade") || name.contains("missile") || name.contains("grenade")) {
                    return;
                }
            }
        }
        if (event.getCause().containsType(Player.class)) {
            user = (User)event.getCause().first(Player.class).get();
        } else if (event.getCause().containsType(User.class)) {
            user = (User)event.getCause().first(User.class).get();
        }
        if (user == null) {
            user = event.getContext().get(EventContextKeys.OWNER).orElse(null);
        }
        LocatableBlock locatableBlock = null;
        if (event.getSource() instanceof LocatableBlock) {
            locatableBlock = (LocatableBlock)event.getSource();
        }
        if (locatableBlock != null) {
            if (locatableBlock.getBlockState().getType() == BlockTypes.FLOWING_WATER || locatableBlock.getBlockState().getType() == BlockTypes.FLOWING_LAVA) {
                return;
            }
            Optional<Faction> optionalSourceChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(((World)locatableBlock.getLocation().getExtent()).getUniqueId(), locatableBlock.getLocation().getChunkPosition());
            if (!optionalSourceChunkFaction.isPresent()) {
                return;
            }
        }
        if (isCustomSpawnType) {
            return;
        }
        for (Transaction transaction : event.getTransactions()) {
            Location location = ((BlockSnapshot)transaction.getOriginal()).getLocation().orElse(null);
            if (location == null || ((BlockSnapshot)transaction.getOriginal()).getState().getType() == BlockTypes.AIR || ((BlockSnapshot)transaction.getOriginal()).getState().getType() == BlockTypes.FLOWING_WATER || ((BlockSnapshot)transaction.getOriginal()).getState().getType() == BlockTypes.FLOWING_LAVA) continue;
            BlockSnapshot blockSnapshot = (BlockSnapshot)transaction.getOriginal();
            if (user != null && !super.getPlugin().getProtectionManager().canBreak(blockSnapshot, user, true).hasAccess()) {
                event.setCancelled(true);
                return;
            }
            if (user != null || super.getPlugin().getProtectionManager().canBreak((Location<World>)location).hasAccess()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onBlockCollide(CollideBlockEvent event) {
        Living living;
        if (event instanceof CollideBlockEvent.Impact) {
            return;
        }
        if (event.getSource() instanceof FallingBlock) {
            return;
        }
        User user = null;
        Cause cause = event.getCause();
        EventContext context = event.getContext();
        user = cause.root() instanceof TileEntity ? (User)context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.CREATOR).orElse(null))) : (User)context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.CREATOR).orElse(null)));
        if (user == null && event instanceof ExplosionEvent && (living = (Living)context.get(EventContextKeys.IGNITER).orElse(null)) instanceof User) {
            user = (User)living;
        }
        if (user == null) {
            return;
        }
        BlockType blockType = event.getTargetBlock().getType();
        if (blockType.equals(BlockTypes.AIR)) {
            return;
        }
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(((World)event.getTargetLocation().getExtent()).getUniqueId(), event.getTargetLocation().getChunkPosition());
        if (optionalChunkFaction.isPresent() && optionalPlayerFaction.isPresent() && !optionalChunkFaction.get().getName().equalsIgnoreCase(optionalPlayerFaction.get().getName())) {
            event.setCancelled(true);
            return;
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onProjectileImpactBlock(CollideBlockEvent.Impact event) {
        Living living;
        if (!(event.getSource() instanceof Entity)) {
            return;
        }
        User user = null;
        Cause cause = event.getCause();
        EventContext context = event.getContext();
        user = cause.root() instanceof TileEntity ? (User)context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.CREATOR).orElse(null))) : (User)context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.CREATOR).orElse(null)));
        if (user == null && event instanceof ExplosionEvent && (living = (Living)context.get(EventContextKeys.IGNITER).orElse(null)) instanceof User) {
            user = (User)living;
        }
        if (user == null) {
            return;
        }
        Location impactPoint = event.getImpactPoint();
        Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(((World)impactPoint.getExtent()).getUniqueId(), impactPoint.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            if (StringUtils.containsIgnoreCase((CharSequence)event.getCause().root().getClass().getName(), (CharSequence)"Pokeball")) {
                return;
            }
            event.setCancelled(true);
            return;
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (playerFaction.getName().equalsIgnoreCase(chunkFaction.getName())) {
            return;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)event.getCause().root().getClass().getName(), (CharSequence)"Pokeball")) {
            return;
        }
        event.setCancelled(true);
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onEntityCollideEntity(CollideEntityEvent event) {
        ProjectileSource projectileSource;
        List entityList = event.getEntities();
        EventContext eventContext = event.getContext();
        Cause cause = event.getCause();
        Object source = event.getSource();
        Player user = null;
        boolean isProjectileSource = eventContext.containsKey(EventContextKeys.PROJECTILE_SOURCE);
        if (isProjectileSource && (projectileSource = (ProjectileSource)eventContext.get(EventContextKeys.PROJECTILE_SOURCE).get()) instanceof Player) {
            user = (Player)projectileSource;
        }
        for (Entity entity2 : entityList) {
            Entity sourceEntity;
            if (entity2 instanceof ItemFrame && isProjectileSource && user != null && !super.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)entity2.getLocation(), (User)user, true).hasAccess()) {
                event.setCancelled(true);
                return;
            }
            if (!(entity2 instanceof Player) || !(source instanceof Entity) || !(sourceEntity = (Entity)source).getType().getName().contains("projectile")) continue;
            if (this.protectionConfig.getSafeZoneWorldNames().contains(entity2.getWorld().getName())) {
                sourceEntity.remove();
                event.setCancelled(true);
                return;
            }
            Optional<Faction> optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(entity2.getWorld().getUniqueId(), entity2.getLocation().getChunkPosition());
            if (optionalChunkFaction.isPresent() && optionalChunkFaction.get().isSafeZone()) {
                sourceEntity.remove();
                event.setCancelled(true);
                return;
            }
            if (!sourceEntity.getType().getId().contains("techguns")) continue;
            Player player = (Player)entity2;
            Class<?> sourceEntityClass = sourceEntity.getClass();
            try {
                Field[] fields;
                Player shooterPlayer = null;
                for (Field field : fields = sourceEntityClass.getDeclaredFields()) {
                    if (!field.getName().equals("shooter")) continue;
                    field.setAccessible(true);
                    Object playerObject = field.get(sourceEntity);
                    if (playerObject instanceof Player) {
                        shooterPlayer = (Player)playerObject;
                    }
                    field.setAccessible(false);
                }
                if (shooterPlayer == null || shooterPlayer == player) continue;
                boolean isFactionFriendlyFireOn = this.factionsConfig.isFactionFriendlyFire();
                boolean isTruceFriendlyFireOn = this.factionsConfig.isTruceFriendlyFire();
                boolean isAllianceFriendlyFireOn = this.factionsConfig.isAllianceFriendlyFire();
                if (isFactionFriendlyFireOn && isAllianceFriendlyFireOn && isTruceFriendlyFireOn) continue;
                Optional<Faction> optionalAffectedPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
                Optional<Faction> optionalShooterPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(shooterPlayer.getUniqueId());
                if (!optionalAffectedPlayerFaction.isPresent() || !optionalShooterPlayerFaction.isPresent()) continue;
                Faction affectedPlayerFaction = optionalAffectedPlayerFaction.get();
                Faction shooterPlayerFaction = optionalShooterPlayerFaction.get();
                if (!isFactionFriendlyFireOn && affectedPlayerFaction.getName().equals(shooterPlayerFaction.getName())) {
                    sourceEntity.remove();
                    event.setCancelled(true);
                    return;
                }
                if (!isTruceFriendlyFireOn && affectedPlayerFaction.getTruces().contains(shooterPlayerFaction.getName())) {
                    sourceEntity.remove();
                    event.setCancelled(true);
                    return;
                }
                if (isAllianceFriendlyFireOn || !affectedPlayerFaction.getAlliances().contains(shooterPlayerFaction.getName())) continue;
                sourceEntity.remove();
                event.setCancelled(true);
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (event instanceof CollideEntityEvent.Impact) {
            return;
        }
        Object rootCause = cause.root();
        if (!(rootCause instanceof ItemFrame)) {
            return;
        }
        event.filterEntities(entity -> !(entity instanceof Living) || !(entity instanceof User) || this.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)entity.getLocation(), (User)entity, true).hasAccess());
    }
}

