/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ChatConfig;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PlayerMoveListener
extends AbstractListener {
    private final FactionsConfig factionsConfig;
    private final ChatConfig chatConfig;

    public PlayerMoveListener(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.chatConfig = plugin.getConfiguration().getChatConfig();
    }

    @Listener(order=Order.EARLY)
    public void onPlayerMove(MoveEntityEvent event, @Root Player player) {
        Location lastLocation = event.getFromTransform().getLocation();
        Location newLocation = event.getToTransform().getLocation();
        if (lastLocation.getChunkPosition().equals((Object)newLocation.getChunkPosition())) {
            return;
        }
        World world = player.getWorld();
        Vector3i oldChunk = lastLocation.getChunkPosition();
        Vector3i newChunk = newLocation.getChunkPosition();
        Optional<Faction> optionalOldChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), oldChunk);
        Optional<Faction> optionalNewChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), newChunk);
        String oldChunkFactionName = "Wilderness";
        String newChunkFactionName = "Wilderness";
        if (optionalOldChunkFaction.isPresent()) {
            oldChunkFactionName = optionalOldChunkFaction.get().getName();
        }
        if (optionalNewChunkFaction.isPresent()) {
            newChunkFactionName = optionalNewChunkFaction.get().getName();
        }
        if (!oldChunkFactionName.equals(newChunkFactionName)) {
            boolean isCancelled = EventRunner.runFactionAreaEnterEventPre(event, player, optionalNewChunkFaction, optionalOldChunkFaction);
            if (isCancelled) {
                event.setCancelled(true);
                return;
            }
            if (!(newChunkFactionName.equalsIgnoreCase("SafeZone") || newChunkFactionName.equalsIgnoreCase("WarZone") || newChunkFactionName.equalsIgnoreCase("Wilderness"))) {
                if (!super.getPlugin().getPlayerManager().hasAdminMode((User)player) && !this.getPlugin().getFactionLogic().hasOnlinePlayers(optionalNewChunkFaction.get()) && this.factionsConfig.getBlockEnteringFactions()) {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_ENTER_THIS_FACTION + " " + Messages.NONE_OF_THIS_FACTIONS_PLAYERS_ARE_ONLINE}));
                    event.setCancelled(true);
                    return;
                }
            } else if (oldChunkFactionName.equalsIgnoreCase("WarZone") && newChunkFactionName.equalsIgnoreCase("SafeZone") && !super.getPlugin().getPlayerManager().hasAdminMode((User)player) && this.factionsConfig.shouldBlockEnteringSafezoneFromWarzone()) {
                if (super.getPlugin().getPlayerManager().getFactionPlayer(player.getUniqueId()).get().diedInWarZone()) {
                    super.getPlugin().getPlayerManager().setDeathInWarZone(player.getUniqueId(), false);
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_ENTER_SAFEZONE_WHEN_YOU_ARE_IN_WARZONE}));
                    event.setCancelled(true);
                    return;
                }
            }
            if (this.chatConfig.shouldShowFactionEnterPhrase()) {
                Text information = optionalNewChunkFaction.isPresent() ? Text.builder().append(new Text[]{Text.of((Object[])new Object[]{MessageLoader.parseMessage(Messages.YOU_HAVE_ENTERED_FACTION, TextColors.RESET, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, newChunkFactionName})))})}).build() : Text.builder().append(new Text[]{Text.of((Object[])new Object[]{MessageLoader.parseMessage(Messages.YOU_HAVE_ENTERED_FACTION, TextColors.RESET, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, newChunkFactionName})))})}).build();
                player.sendMessage(ChatTypes.ACTION_BAR, information);
            }
            EventRunner.runFactionAreaEnterEventPost(event, player, optionalNewChunkFaction, optionalOldChunkFaction);
        }
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.delay(50L, TimeUnit.MILLISECONDS).execute(() -> {
            if (EagleFactionsPlugin.AUTO_CLAIM_LIST.contains(player.getUniqueId())) {
                Sponge.getCommandManager().process((CommandSource)player, "f claim");
            }
            if (EagleFactionsPlugin.AUTO_MAP_LIST.contains(player.getUniqueId())) {
                Sponge.getCommandManager().process((CommandSource)player, "f map");
            }
        }).submit((Object)super.getPlugin());
    }
}

