/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.logic;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.AttackLogic;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.scheduling.AttackClaimTask;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.util.ParticlesUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class AttackLogicImpl
implements AttackLogic {
    private final FactionsConfig factionsConfig;
    private final FactionLogic factionLogic;

    public AttackLogicImpl(FactionLogic factionLogic, FactionsConfig factionsConfig) {
        this.factionLogic = factionLogic;
        this.factionsConfig = factionsConfig;
    }

    @Override
    public void attack(Player player, Vector3i attackedChunk) {
        AttackClaimTask attackClaimTask = new AttackClaimTask(this.factionsConfig, this.factionLogic, this, player, attackedChunk);
        EagleFactionsScheduler.getInstance().scheduleWithDelayedIntervalAsync(attackClaimTask, 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void blockClaiming(String factionName) {
        EagleFactionsPlugin.ATTACKED_FACTIONS.put(factionName, 120);
        this.runClaimingRestorer(factionName);
    }

    @Override
    public void runClaimingRestorer(String factionName) {
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.interval(1L, TimeUnit.SECONDS).execute(task -> {
            if (EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(factionName)) {
                int seconds = EagleFactionsPlugin.ATTACKED_FACTIONS.get(factionName);
                if (seconds <= 0) {
                    EagleFactionsPlugin.ATTACKED_FACTIONS.remove(factionName);
                    task.cancel();
                } else {
                    EagleFactionsPlugin.ATTACKED_FACTIONS.replace(factionName, seconds, seconds - 1);
                }
            }
        }).submit((Object)EagleFactionsPlugin.getPlugin());
    }

    @Override
    public void informAboutAttack(Faction faction, Location<World> location) {
        if (!this.factionsConfig.shouldInformAboutAttack()) {
            return;
        }
        List<Player> playersList = this.factionLogic.getOnlinePlayers(faction);
        if (this.factionsConfig.shouldShowAttackedClaim()) {
            playersList.forEach(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.CLAIM_AT_COORDS_IS_BEING_ATTACKED_BY_ENEMY, TextColors.RED, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.COORDS, (Object)Text.of((Object[])new Object[]{TextColors.RED, Text.of((Object[])new Object[]{ParticlesUtil.getChunkCenter((World)location.getExtent(), location.getChunkPosition())})})))})));
        } else {
            playersList.forEach(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.YOUR_FACTION_IS_UNDER_ATTACK})));
        }
    }

    @Override
    public void informAboutDestroying(Faction faction, Location<World> location) {
        if (!this.factionsConfig.shouldInformAboutDestroy()) {
            return;
        }
        List<Player> playersList = this.factionLogic.getOnlinePlayers(faction);
        if (this.factionsConfig.shouldShowDestroyedClaim()) {
            playersList.forEach(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.CLAIM_AT_COORDS_HAS_BEEN_DESTROYED_BY_ENEMY, TextColors.RED, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.COORDS, (Object)Text.of((Object[])new Object[]{ParticlesUtil.getChunkCenter((World)location.getExtent(), location.getChunkPosition())})))})));
        } else {
            playersList.forEach(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.ONE_OF_YOUR_CLAIMS_HAS_BEEN_DESTROYED_BY_AN_ENEMY})));
        }
    }

    @Override
    public void blockHome(UUID playerUUID) {
        if (EagleFactionsPlugin.BLOCKED_HOME.containsKey(playerUUID)) {
            EagleFactionsPlugin.BLOCKED_HOME.replace(playerUUID, this.factionsConfig.getHomeBlockTimeAfterDeathInOwnFaction());
        } else {
            EagleFactionsPlugin.BLOCKED_HOME.put(playerUUID, this.factionsConfig.getHomeBlockTimeAfterDeathInOwnFaction());
            this.runHomeUsageRestorer(playerUUID);
        }
    }

    @Override
    public void runHomeUsageRestorer(UUID playerUUID) {
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.interval(1L, TimeUnit.SECONDS).execute(task -> {
            if (EagleFactionsPlugin.BLOCKED_HOME.containsKey(playerUUID)) {
                int seconds = EagleFactionsPlugin.BLOCKED_HOME.get(playerUUID);
                if (seconds <= 0) {
                    EagleFactionsPlugin.BLOCKED_HOME.remove(playerUUID);
                    task.cancel();
                } else {
                    EagleFactionsPlugin.BLOCKED_HOME.replace(playerUUID, seconds, seconds - 1);
                }
            }
        }).submit((Object)EagleFactionsPlugin.getPlugin());
    }
}

