/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.logic;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.exception.RequiredItemsNotFoundException;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.scheduling.ClaimDelayTask;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.util.ItemUtil;
import io.github.aquerr.eaglefactions.common.util.ParticlesUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class FactionLogicImpl
implements FactionLogic {
    private static final UUID DUMMY_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final StorageManager storageManager;
    private final FactionsConfig factionsConfig;
    private final PlayerManager playerManager;

    public FactionLogicImpl(PlayerManager playerManager, StorageManager storageManager, FactionsConfig factionsConfig) {
        this.storageManager = storageManager;
        this.playerManager = playerManager;
        this.factionsConfig = factionsConfig;
    }

    @Override
    public Optional<Faction> getFactionByPlayerUUID(UUID playerUUID) {
        Preconditions.checkNotNull((Object)playerUUID);
        return this.playerManager.getFactionPlayer(playerUUID).flatMap(FactionPlayer::getFactionName).map(this::getFactionByName);
    }

    @Override
    public Optional<Faction> getFactionByChunk(UUID worldUUID, Vector3i chunk) {
        Preconditions.checkNotNull((Object)worldUUID);
        Preconditions.checkNotNull((Object)chunk);
        Claim claim = new Claim(worldUUID, chunk);
        Optional<Faction> cachedOptional = FactionsCache.getClaimFaction(claim);
        if (cachedOptional != null) {
            return cachedOptional;
        }
        for (Faction faction : this.getFactions().values()) {
            if (!faction.getClaims().contains(claim)) continue;
            FactionsCache.updateClaimFaction(claim, Optional.of(faction));
            return Optional.of(faction);
        }
        FactionsCache.updateClaimFaction(claim, Optional.empty());
        return Optional.empty();
    }

    @Override
    @Nullable
    public Faction getFactionByName(String factionName) {
        Validate.notBlank((CharSequence)factionName);
        return this.storageManager.getFaction(factionName);
    }

    @Override
    public List<Player> getOnlinePlayers(Faction faction) {
        Preconditions.checkNotNull((Object)faction);
        ArrayList<Player> factionPlayers = new ArrayList<Player>();
        UUID factionLeader = faction.getLeader();
        if (!faction.getLeader().equals(DUMMY_UUID) && this.playerManager.isPlayerOnline(factionLeader)) {
            factionPlayers.add(this.playerManager.getPlayer(factionLeader).get());
        }
        for (UUID uuid : faction.getOfficers()) {
            if (!this.playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this.playerManager.getPlayer(uuid).get());
        }
        for (UUID uuid : faction.getMembers()) {
            if (!this.playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this.playerManager.getPlayer(uuid).get());
        }
        for (UUID uuid : faction.getRecruits()) {
            if (!this.playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this.playerManager.getPlayer(uuid).get());
        }
        return factionPlayers;
    }

    @Override
    public Set<String> getFactionsNames() {
        return this.getFactions().keySet();
    }

    @Override
    public Map<String, Faction> getFactions() {
        return new HashMap<String, Faction>(FactionsCache.getFactionsMap());
    }

    @Override
    public Map<Claim, Optional<Faction>> getAllClaims() {
        return new HashMap<Claim, Optional<Faction>>(FactionsCache.getClaims());
    }

    @Override
    public void addFaction(Faction faction) {
        Preconditions.checkNotNull((Object)faction);
        this.storageManager.saveFaction(faction);
    }

    @Override
    public boolean disbandFaction(String factionName) {
        Preconditions.checkNotNull((Object)factionName);
        Faction factionToDisband = this.storageManager.getFaction(factionName);
        Preconditions.checkNotNull((Object)factionToDisband, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), factionName));
        CompletableFuture.runAsync(() -> {
            Set<UUID> playerUUIDs = factionToDisband.getPlayers();
            for (UUID playerUUID : playerUUIDs) {
                FactionPlayer factionPlayer = this.playerManager.getFactionPlayer(playerUUID).get();
                FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), null, factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
                this.storageManager.savePlayer(updatedPlayer);
            }
        });
        CompletableFuture.runAsync(() -> {
            Set<String> alliances = factionToDisband.getAlliances();
            Set<String> truces = factionToDisband.getTruces();
            Set<String> enemies = factionToDisband.getEnemies();
            for (String alliance : alliances) {
                this.removeAlly(alliance, factionToDisband.getName());
            }
            for (String truce : truces) {
                this.removeTruce(truce, factionToDisband.getName());
            }
            for (String enemy : enemies) {
                this.removeEnemy(enemy, factionToDisband.getName());
            }
        });
        return this.storageManager.deleteFaction(factionName);
    }

    @Override
    public void leaveFaction(UUID playerUUID, String factionName) {
        Preconditions.checkNotNull((Object)playerUUID);
        Preconditions.checkNotNull((Object)factionName);
        Faction faction = this.getFactionByName(factionName);
        Preconditions.checkNotNull((Object)faction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), factionName));
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (faction.getRecruits().contains(playerUUID)) {
            recruits.remove(playerUUID);
        } else if (faction.getMembers().contains(playerUUID)) {
            members.remove(playerUUID);
        } else {
            officers.remove(playerUUID);
        }
        HashSet<Claim> updatedClaims = new HashSet<Claim>();
        for (Claim claim : faction.getClaims()) {
            HashSet<UUID> owners = new HashSet<UUID>(claim.getOwners());
            owners.remove(playerUUID);
            Claim updatedClaim = new Claim(claim.getWorldUUID(), claim.getChunkPosition(), owners, claim.isAccessibleByFaction());
            updatedClaims.add(updatedClaim);
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setMembers(members).setOfficers(officers).setClaims(updatedClaims).build();
        this.storageManager.saveFaction(updatedFaction);
        FactionPlayer factionPlayer = this.playerManager.getFactionPlayer(playerUUID).get();
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), null, factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
        this.storageManager.savePlayer(updatedPlayer);
    }

    @Override
    public void setFaction(UUID playerUUID, String factionName, FactionMemberType rank) {
        Preconditions.checkNotNull((Object)playerUUID);
        Preconditions.checkNotNull((Object)factionName);
        Preconditions.checkNotNull((Object)((Object)rank));
        this.getFactionByPlayerUUID(playerUUID).ifPresent(faction -> {
            if (playerUUID.equals(faction.getLeader())) {
                Faction updatedFaction = faction.toBuilder().setLeader(DUMMY_UUID).build();
                this.storageManager.saveFaction(updatedFaction);
            } else {
                this.leaveFaction(playerUUID, factionName);
            }
        });
        Faction faction2 = this.getFactionByName(factionName);
        Preconditions.checkNotNull((Object)faction2);
        HashSet<UUID> officers = new HashSet<UUID>(faction2.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction2.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction2.getRecruits());
        Faction.Builder factionBuilder = faction2.toBuilder();
        switch (rank) {
            case LEADER: {
                UUID leaderUUID = faction2.getLeader();
                if (leaderUUID != DUMMY_UUID) {
                    officers.add(leaderUUID);
                }
                factionBuilder.setLeader(playerUUID).setOfficers(officers);
                break;
            }
            case OFFICER: {
                officers.add(playerUUID);
                factionBuilder.setOfficers(officers);
                break;
            }
            case MEMBER: {
                members.add(playerUUID);
                factionBuilder.setMembers(members);
                break;
            }
            case RECRUIT: {
                recruits.add(playerUUID);
                factionBuilder.setRecruits(recruits);
                break;
            }
        }
        this.storageManager.saveFaction(factionBuilder.build());
        FactionPlayer factionPlayer = this.playerManager.getFactionPlayer(playerUUID).get();
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), faction2.getName(), factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
        this.storageManager.savePlayer(updatedPlayer);
    }

    @Override
    public void addTruce(String playerFactionName, String invitedFactionName) {
        Validate.notBlank((CharSequence)playerFactionName);
        Validate.notBlank((CharSequence)invitedFactionName);
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction invitedFaction = this.getFactionByName(invitedFactionName);
        Preconditions.checkNotNull((Object)playerFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), playerFactionName));
        Preconditions.checkNotNull((Object)invitedFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), invitedFactionName));
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getTruces());
        HashSet<String> invitedFactionAlliances = new HashSet<String>(invitedFaction.getTruces());
        playerFactionAlliances.add(invitedFactionName);
        invitedFactionAlliances.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setTruces(playerFactionAlliances).build();
        Faction updatedInvitedFaction = invitedFaction.toBuilder().setTruces(invitedFactionAlliances).build();
        this.storageManager.saveFaction(updatedPlayerFaction);
        this.storageManager.saveFaction(updatedInvitedFaction);
    }

    @Override
    public void removeTruce(String playerFactionName, String removedFactionName) {
        Validate.notBlank((CharSequence)playerFactionName);
        Validate.notBlank((CharSequence)removedFactionName);
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction removedFaction = this.getFactionByName(removedFactionName);
        Preconditions.checkNotNull((Object)playerFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), playerFactionName));
        Preconditions.checkNotNull((Object)removedFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), removedFactionName));
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getTruces());
        HashSet<String> removedFactionAlliances = new HashSet<String>(removedFaction.getTruces());
        playerFactionAlliances.remove(removedFactionName);
        removedFactionAlliances.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setTruces(playerFactionAlliances).build();
        Faction updatedRemovedFaction = removedFaction.toBuilder().setTruces(removedFactionAlliances).build();
        this.storageManager.saveFaction(updatedPlayerFaction);
        this.storageManager.saveFaction(updatedRemovedFaction);
    }

    @Override
    public void addAlly(String playerFactionName, String invitedFactionName) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)playerFactionName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)invitedFactionName) ? 1 : 0) != 0);
        if (StringUtils.isBlank((CharSequence)playerFactionName) || StringUtils.isBlank((CharSequence)invitedFactionName)) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction invitedFaction = this.getFactionByName(invitedFactionName);
        Preconditions.checkNotNull((Object)playerFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), playerFactionName));
        Preconditions.checkNotNull((Object)invitedFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), invitedFactionName));
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getAlliances());
        HashSet<String> invitedFactionAlliances = new HashSet<String>(invitedFaction.getAlliances());
        playerFactionAlliances.add(invitedFactionName);
        invitedFactionAlliances.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setAlliances(playerFactionAlliances).build();
        Faction updatedInvitedFaction = invitedFaction.toBuilder().setAlliances(invitedFactionAlliances).build();
        this.storageManager.saveFaction(updatedPlayerFaction);
        this.storageManager.saveFaction(updatedInvitedFaction);
    }

    @Override
    public void removeAlly(String playerFactionName, String removedFactionName) {
        Validate.notBlank((CharSequence)playerFactionName);
        Validate.notBlank((CharSequence)removedFactionName);
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction removedFaction = this.getFactionByName(removedFactionName);
        Preconditions.checkNotNull((Object)playerFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), playerFactionName));
        Preconditions.checkNotNull((Object)removedFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), removedFactionName));
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getAlliances());
        HashSet<String> removedFactionAlliances = new HashSet<String>(removedFaction.getAlliances());
        playerFactionAlliances.remove(removedFactionName);
        removedFactionAlliances.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setAlliances(playerFactionAlliances).build();
        Faction updatedRemovedFaction = removedFaction.toBuilder().setAlliances(removedFactionAlliances).build();
        this.storageManager.saveFaction(updatedPlayerFaction);
        this.storageManager.saveFaction(updatedRemovedFaction);
    }

    @Override
    public void addEnemy(String playerFactionName, String enemyFactionName) {
        Validate.notBlank((CharSequence)playerFactionName);
        Validate.notBlank((CharSequence)enemyFactionName);
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction enemyFaction = this.getFactionByName(enemyFactionName);
        Preconditions.checkNotNull((Object)playerFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), playerFactionName));
        Preconditions.checkNotNull((Object)enemyFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), enemyFactionName));
        HashSet<String> playerFactionEnemies = new HashSet<String>(playerFaction.getEnemies());
        HashSet<String> enemyFactionEnemies = new HashSet<String>(enemyFaction.getEnemies());
        playerFactionEnemies.add(enemyFactionName);
        enemyFactionEnemies.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setEnemies(playerFactionEnemies).build();
        Faction updatedEnemyFaction = enemyFaction.toBuilder().setEnemies(enemyFactionEnemies).build();
        this.storageManager.saveFaction(updatedPlayerFaction);
        this.storageManager.saveFaction(updatedEnemyFaction);
    }

    @Override
    public void removeEnemy(String playerFactionName, String enemyFactionName) {
        Validate.notBlank((CharSequence)playerFactionName);
        Validate.notBlank((CharSequence)enemyFactionName);
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction enemyFaction = this.getFactionByName(enemyFactionName);
        Preconditions.checkNotNull((Object)playerFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), playerFactionName));
        Preconditions.checkNotNull((Object)enemyFaction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), enemyFactionName));
        HashSet<String> playerFactionEnemies = new HashSet<String>(playerFaction.getEnemies());
        HashSet<String> enemyFactionEnemies = new HashSet<String>(enemyFaction.getEnemies());
        playerFactionEnemies.remove(enemyFactionName);
        enemyFactionEnemies.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setEnemies(playerFactionEnemies).build();
        Faction updatedEnemyFaction = enemyFaction.toBuilder().setEnemies(enemyFactionEnemies).build();
        this.storageManager.saveFaction(updatedPlayerFaction);
        this.storageManager.saveFaction(updatedEnemyFaction);
    }

    @Override
    public void addClaims(Faction faction, List<Claim> claims) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull(claims);
        HashSet<Claim> factionClaims = new HashSet<Claim>(faction.getClaims());
        for (Claim claim : claims) {
            factionClaims.add(claim);
            ParticlesUtil.spawnClaimParticles(claim);
        }
        Faction updatedFaction = faction.toBuilder().setClaims(factionClaims).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void addClaim(Faction faction, Claim claim) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claim);
        HashSet<Claim> claims = new HashSet<Claim>(faction.getClaims());
        claims.add(claim);
        Faction updatedFaction = faction.toBuilder().setClaims(claims).build();
        this.storageManager.saveFaction(updatedFaction);
        ParticlesUtil.spawnClaimParticles(claim);
    }

    @Override
    public void removeClaim(Faction faction, Claim claim) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claim);
        this.removeClaimInternal(faction, claim);
        ParticlesUtil.spawnUnclaimParticles(claim);
    }

    @Override
    public void destroyClaim(Faction faction, Claim claim) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claim);
        this.removeClaimInternal(faction, claim);
        ParticlesUtil.spawnDestroyClaimParticles(claim);
    }

    @Override
    public boolean isClaimed(UUID worldUUID, Vector3i chunk) {
        Preconditions.checkNotNull((Object)worldUUID);
        Preconditions.checkNotNull((Object)chunk);
        Optional<Faction> faction = this.getFactionByChunk(worldUUID, chunk);
        return faction.isPresent();
    }

    @Override
    public boolean isClaimConnected(Faction faction, Claim claimToCheck) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claimToCheck);
        if (faction.getClaims().size() == 0) {
            return true;
        }
        for (Claim claim : faction.getClaims()) {
            if (!claimToCheck.getWorldUUID().equals(claim.getWorldUUID())) continue;
            Vector3i chunkToCheck = claimToCheck.getChunkPosition();
            Vector3i claimChunk = claim.getChunkPosition();
            if (claimChunk.getX() == chunkToCheck.getX() && (claimChunk.getZ() + 1 == chunkToCheck.getZ() || claimChunk.getZ() - 1 == chunkToCheck.getZ())) {
                return true;
            }
            if (claimChunk.getZ() != chunkToCheck.getZ() || claimChunk.getX() + 1 != chunkToCheck.getX() && claimChunk.getX() - 1 != chunkToCheck.getX()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addClaimOwner(Faction faction, Claim claim, UUID owner) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claim);
        Preconditions.checkNotNull((Object)owner);
        HashSet<Claim> updatedClaims = new HashSet<Claim>(faction.getClaims());
        updatedClaims.remove(claim);
        HashSet<UUID> claimOwners = new HashSet<UUID>(claim.getOwners());
        claimOwners.add(owner);
        Claim updatedClaim = new Claim(claim.getWorldUUID(), claim.getChunkPosition(), claimOwners, claim.isAccessibleByFaction());
        updatedClaims.add(updatedClaim);
        Faction updatedFaction = faction.toBuilder().setClaims(updatedClaims).build();
        this.storageManager.saveFaction(updatedFaction);
        return true;
    }

    @Override
    public boolean removeClaimOwner(Faction faction, Claim claim, UUID owner) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claim);
        Preconditions.checkNotNull((Object)owner);
        HashSet<Claim> updatedClaims = new HashSet<Claim>(faction.getClaims());
        updatedClaims.remove(claim);
        HashSet<UUID> claimOwners = new HashSet<UUID>(claim.getOwners());
        claimOwners.remove(owner);
        Claim updatedClaim = new Claim(claim.getWorldUUID(), claim.getChunkPosition(), claimOwners, claim.isAccessibleByFaction());
        updatedClaims.add(updatedClaim);
        Faction updatedFaction = faction.toBuilder().setClaims(updatedClaims).build();
        this.storageManager.saveFaction(updatedFaction);
        return true;
    }

    @Override
    public void setClaimAccessibleByFaction(Faction faction, Claim claim, boolean isAccessibleByFaction) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)claim);
        HashSet<Claim> updatedClaims = new HashSet<Claim>(faction.getClaims());
        updatedClaims.remove(claim);
        Claim updatedClaim = new Claim(claim.getWorldUUID(), claim.getChunkPosition(), claim.getOwners(), isAccessibleByFaction);
        updatedClaims.add(updatedClaim);
        Faction updatedFaction = faction.toBuilder().setClaims(updatedClaims).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void setHome(Faction faction, @Nullable FactionHome home) {
        Preconditions.checkNotNull((Object)faction);
        faction = home != null && home.getBlockPosition() != null && home.getWorldUUID() != null ? faction.toBuilder().setHome(home).build() : faction.toBuilder().setHome(null).build();
        this.storageManager.saveFaction(faction);
    }

    @Override
    public List<String> getFactionsTags() {
        Collection<Faction> factionsList = this.getFactions().values();
        ArrayList<String> factionsTags = new ArrayList<String>();
        for (Faction faction : factionsList) {
            factionsTags.add(faction.getTag().toPlain());
        }
        return factionsTags;
    }

    @Override
    public boolean hasOnlinePlayers(Faction faction) {
        Preconditions.checkNotNull((Object)faction);
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("") && this.playerManager.isPlayerOnline(faction.getLeader())) {
            return true;
        }
        for (UUID playerUUID : faction.getOfficers()) {
            if (!this.playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        for (UUID playerUUID : faction.getMembers()) {
            if (!this.playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        for (UUID playerUUID : faction.getRecruits()) {
            if (!this.playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllClaims(Faction faction) {
        Preconditions.checkNotNull((Object)faction);
        for (Claim claim : faction.getClaims()) {
            FactionsCache.removeClaim(claim);
        }
        Faction updatedFaction = faction.toBuilder().setClaims(new HashSet<Claim>()).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void kickPlayer(UUID playerUUID, String factionName) {
        Preconditions.checkNotNull((Object)playerUUID);
        Validate.notBlank((CharSequence)factionName);
        Faction faction = this.getFactionByName(factionName);
        Preconditions.checkNotNull((Object)faction, (Object)Messages.THERE_IS_NO_FACTION_CALLED_FACTION_NAME.replace(Placeholders.FACTION_NAME.getPlaceholder(), factionName));
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        if (faction.getRecruits().contains(playerUUID)) {
            recruits.remove(playerUUID);
        } else if (faction.getMembers().contains(playerUUID)) {
            members.remove(playerUUID);
        } else {
            officers.remove(playerUUID);
        }
        HashSet<Claim> updatedClaims = new HashSet<Claim>();
        for (Claim claim : faction.getClaims()) {
            HashSet<UUID> owners = new HashSet<UUID>(claim.getOwners());
            owners.remove(playerUUID);
            Claim updatedClaim = new Claim(claim.getWorldUUID(), claim.getChunkPosition(), owners, claim.isAccessibleByFaction());
            updatedClaims.add(updatedClaim);
        }
        Faction updatedFaction = faction.toBuilder().setOfficers(officers).setMembers(members).setRecruits(recruits).setClaims(updatedClaims).build();
        this.storageManager.saveFaction(updatedFaction);
        FactionPlayer factionPlayer = this.storageManager.getPlayer(playerUUID);
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), null, factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
        this.storageManager.savePlayer(updatedPlayer);
    }

    @Override
    public void startClaiming(Player player, Faction faction, UUID worldUUID, Vector3i chunkPosition) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)worldUUID);
        Preconditions.checkNotNull((Object)chunkPosition);
        if (this.factionsConfig.shouldDelayClaim()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.STAY_IN_THE_CHUNK_FOR_NUMBER_SECONDS_TO_CLAIM_IT, TextColors.GREEN, Collections.singletonMap(Placeholders.NUMBER, Text.of((Object[])new Object[]{TextColors.GOLD, this.factionsConfig.getClaimDelay()})))}));
            EagleFactionsScheduler.getInstance().scheduleWithDelayedInterval(new ClaimDelayTask(player, chunkPosition), 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
        } else {
            if (this.factionsConfig.shouldClaimByItems()) {
                boolean didSucceed = this.addClaimByItems(player, faction, worldUUID, chunkPosition);
                if (didSucceed) {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, chunkPosition.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ENOUGH_RESOURCES_TO_CLAIM_A_TERRITORY}));
                }
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, chunkPosition.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
                this.addClaim(faction, new Claim(worldUUID, chunkPosition));
            }
            EventRunner.runFactionClaimEventPost(player, faction, player.getWorld(), chunkPosition);
        }
    }

    @Override
    public boolean addClaimByItems(Player player, Faction faction, UUID worldUUID, Vector3i chunkPosition) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)worldUUID);
        Preconditions.checkNotNull((Object)chunkPosition);
        try {
            ItemUtil.pollItemsNeededForClaimFromPlayer(player);
            this.addClaim(faction, new Claim(worldUUID, chunkPosition));
            return true;
        }
        catch (RequiredItemsNotFoundException e) {
            return false;
        }
    }

    @Override
    public void togglePerm(Faction faction, FactionMemberType factionMemberType, FactionPermType factionPermType, Boolean flagValue) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)((Object)factionMemberType));
        Preconditions.checkNotNull((Object)((Object)factionPermType));
        Preconditions.checkNotNull((Object)flagValue);
        HashMap<FactionMemberType, Map<FactionPermType, Boolean>> perms = new HashMap<FactionMemberType, Map<FactionPermType, Boolean>>(faction.getPerms());
        ((Map)perms.get((Object)factionMemberType)).replace(factionPermType, flagValue);
        Faction updatedFaction = faction.toBuilder().setPerms(perms).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void changeTagColor(Faction faction, TextColor textColor) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)textColor);
        Text text = Text.of((Object[])new Object[]{textColor, faction.getTag().toPlainSingle()});
        Faction updatedFaction = faction.toBuilder().setTag(text).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void setLastOnline(Faction faction, Instant instantTime) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)instantTime);
        Faction updatedFaction = faction.toBuilder().setLastOnline(instantTime).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void renameFaction(Faction faction, String newFactionName) {
        Preconditions.checkNotNull((Object)faction);
        Validate.notBlank((CharSequence)newFactionName);
        this.storageManager.deleteFaction(faction.getName());
        Faction updatedFaction = faction.toBuilder().setName(newFactionName).build();
        this.storageManager.saveFaction(updatedFaction);
        CompletableFuture.runAsync(() -> {
            Set<String> alliances = faction.getAlliances();
            Set<String> truces = faction.getTruces();
            Set<String> enemies = faction.getEnemies();
            for (String alliance : alliances) {
                this.removeAlly(alliance, faction.getName());
                this.addAlly(alliance, newFactionName);
            }
            for (String truce : truces) {
                this.removeTruce(truce, faction.getName());
                this.addTruce(truce, newFactionName);
            }
            for (String enemy : enemies) {
                this.removeEnemy(enemy, faction.getName());
                this.addEnemy(enemy, newFactionName);
            }
        });
        CompletableFuture.runAsync(() -> {
            Set<UUID> playerUUIDs = updatedFaction.getPlayers();
            for (UUID playerUUID : playerUUIDs) {
                FactionPlayer factionPlayer = this.storageManager.getPlayer(playerUUID);
                FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), updatedFaction.getName(), factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
                this.storageManager.savePlayer(updatedPlayer);
            }
        });
    }

    @Override
    public void changeTag(Faction faction, String newTag) {
        Preconditions.checkNotNull((Object)faction);
        Validate.notBlank((CharSequence)newTag);
        Faction updatedFaction = faction.toBuilder().setTag(Text.of((Object[])new Object[]{faction.getTag().getColor(), newTag})).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void setChest(Faction faction, FactionChest inventory) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)inventory);
        Faction updatedFaction = faction.toBuilder().setChest(inventory).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void setDescription(Faction faction, String description) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)description);
        Faction updatedFaction = faction.toBuilder().setDescription(description).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void setMessageOfTheDay(Faction faction, String motd) {
        Preconditions.checkNotNull((Object)faction);
        Preconditions.checkNotNull((Object)motd);
        Faction updatedFaction = faction.toBuilder().setMessageOfTheDay(motd).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    @Override
    public void setIsPublic(Faction faction, boolean isPublic) {
        Preconditions.checkNotNull((Object)faction);
        Faction updatedFaction = faction.toBuilder().setIsPublic(isPublic).build();
        this.storageManager.saveFaction(updatedFaction);
    }

    private void removeClaimInternal(Faction faction, Claim claim) {
        HashSet<Claim> claims = new HashSet<Claim>(faction.getClaims());
        claims.remove(claim);
        Faction updatedFaction = faction.toBuilder().setClaims(claims).build();
        FactionsCache.removeClaim(claim);
        this.storageManager.saveFaction(updatedFaction);
    }
}

