/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.entities.AllyRequest;
import io.github.aquerr.eaglefactions.api.entities.ArmisticeRequest;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionInvite;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.entities.TruceRequest;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.InvitationManager;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.entities.AllyRequestImpl;
import io.github.aquerr.eaglefactions.common.entities.ArmisticeRequestImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionInviteImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.entities.TruceRequestImpl;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.scheduling.RemoveInviteTask;
import io.github.aquerr.eaglefactions.common.scheduling.RemoveRelationRequestTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class InvitationManagerImpl
implements InvitationManager {
    private final StorageManager storageManager;
    private final FactionLogic factionLogic;
    private final PlayerManager playerManager;

    public InvitationManagerImpl(StorageManager storageManager, FactionLogic factionLogic, PlayerManager playerManager) {
        this.factionLogic = factionLogic;
        this.playerManager = playerManager;
        this.storageManager = storageManager;
    }

    @Override
    public boolean acceptInvitation(FactionInvite factionInvite) {
        Preconditions.checkNotNull((Object)factionInvite);
        Player player = this.playerManager.getPlayer(factionInvite.getInvitedPlayerUniqueId()).orElseThrow(() -> new IllegalArgumentException("Player with the given UUID does not exist!"));
        Faction faction = this.factionLogic.getFactionByName(factionInvite.getSenderFaction());
        Preconditions.checkNotNull((Object)faction);
        this.joinAndNotify(player, faction);
        EagleFactionsPlugin.INVITE_LIST.remove(factionInvite);
        return true;
    }

    @Override
    public boolean sendInvitation(Player senderPlayer, Player invitedPlayer, Faction senderFaction) {
        boolean isCancelled = EventRunner.runFactionInviteEventPre(senderPlayer, invitedPlayer, senderFaction);
        if (isCancelled) {
            return false;
        }
        FactionInviteImpl invite = new FactionInviteImpl(senderFaction.getName(), invitedPlayer.getUniqueId());
        EagleFactionsPlugin.INVITE_LIST.add(invite);
        invitedPlayer.sendMessage(this.getInviteReceivedMessage(senderFaction));
        senderPlayer.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.YOU_INVITED + " ", TextColors.GOLD, invitedPlayer.getName(), TextColors.GREEN, " " + Messages.TO_YOUR_FACTION}));
        EagleFactionsScheduler.getInstance().scheduleWithDelay(new RemoveInviteTask(invite), 2L, TimeUnit.MINUTES);
        EventRunner.runFactionInviteEventPost(senderPlayer, invitedPlayer, senderFaction);
        return true;
    }

    @Override
    public boolean joinAndNotify(Player player, Faction faction) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)faction);
        boolean isCancelled = EventRunner.runFactionJoinEventPre(player, faction);
        if (isCancelled) {
            return false;
        }
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        recruits.add(player.getUniqueId());
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).build();
        this.storageManager.saveFaction(updatedFaction);
        FactionPlayer factionPlayer = this.playerManager.getFactionPlayer(player.getUniqueId()).get();
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), faction.getName(), factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
        this.storageManager.savePlayer(updatedPlayer);
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.SUCCESSFULLY_JOINED_FACTION, TextColors.GREEN, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, faction.getName()})))}));
        EventRunner.runFactionJoinEventPost(player, this.factionLogic.getFactionByName(faction.getName()));
        return true;
    }

    @Override
    public boolean sendAllyRequest(Player player, Faction sourceFaction, Faction targetFaction) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)sourceFaction);
        Preconditions.checkNotNull((Object)targetFaction);
        if (sourceFaction.getName().equals(targetFaction.getName())) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANNOT_INVITE_YOURSELF_TO_THE_ALLIANCE}));
            return false;
        }
        if (targetFaction.isSafeZone() || targetFaction.isWarZone()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "You can't do this!"}));
            return false;
        }
        boolean hasAdminMode = this.playerManager.hasAdminMode((User)player);
        boolean isLeader = this.isLeader(sourceFaction, player);
        boolean isOfficer = this.isOfficer(sourceFaction, player);
        if (sourceFaction.isAlly(targetFaction) && (hasAdminMode || isLeader || isOfficer)) {
            this.factionLogic.removeAlly(sourceFaction.getName(), targetFaction.getName());
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DISBANDED_YOUR_ALLIANCE_WITH_FACTION, TextColors.GREEN, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
            return true;
        }
        if (hasAdminMode) {
            this.forceAllianceBetween(sourceFaction, targetFaction);
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage("You force set allinace between you and " + Placeholders.FACTION_NAME.getPlaceholder(), TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
            return true;
        }
        if (!isLeader && !isOfficer) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_THE_FACTIONS_LEADER_OR_OFFICER_TO_DO_THIS}));
            return false;
        }
        if (sourceFaction.isEnemy(targetFaction)) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_ARE_IN_WAR_WITH_THIS_FACTION + " " + Messages.SEND_THIS_FACTION_A_PEACE_REQUEST_FIRST_BEFORE_INVITING_THEM_TO_ALLIES}));
            return false;
        }
        if (sourceFaction.isTruce(targetFaction)) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.DISBAND_TRUCE_FIRST_TO_INVITE_FACTION_TO_THE_ALLIANCE}));
            return false;
        }
        AllyRequestImpl invite = new AllyRequestImpl(sourceFaction.getName(), targetFaction.getName());
        EagleFactionsPlugin.RELATION_INVITES.add(invite);
        Optional<Player> optionalInvitedFactionLeader = this.playerManager.getPlayer(targetFaction.getLeader());
        optionalInvitedFactionLeader.ifPresent(x -> ((Player)optionalInvitedFactionLeader.get()).sendMessage(this.getAllyInviteGetMessage(sourceFaction)));
        targetFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> this.getAllyInviteGetMessage(sourceFaction)));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_HAVE_INVITED_FACTION_TO_THE_ALLIANCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
        EagleFactionsScheduler.getInstance().scheduleWithDelay(new RemoveRelationRequestTask(invite), 2L, TimeUnit.MINUTES);
        return true;
    }

    @Override
    public boolean sendTruceRequest(Player player, Faction sourceFaction, Faction targetFaction) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)sourceFaction);
        Preconditions.checkNotNull((Object)targetFaction);
        if (sourceFaction.getName().equals(targetFaction.getName())) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANNOT_INVITE_YOURSELF_TO_THE_TRUCE}));
            return false;
        }
        if (targetFaction.isSafeZone() || targetFaction.isWarZone()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "You can't do this!"}));
            return false;
        }
        boolean hasAdminMode = this.playerManager.hasAdminMode((User)player);
        boolean isLeader = this.isLeader(sourceFaction, player);
        boolean isOfficer = this.isOfficer(sourceFaction, player);
        if (sourceFaction.isTruce(targetFaction) && (hasAdminMode || isLeader || isOfficer)) {
            this.factionLogic.removeAlly(sourceFaction.getName(), targetFaction.getName());
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DISBANDED_YOUR_TRUCE_WITH_FACTION, TextColors.GREEN, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
            return true;
        }
        if (hasAdminMode) {
            this.forceTruceBetween(sourceFaction, targetFaction);
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage("You force set truce between you and " + Placeholders.FACTION_NAME.getPlaceholder(), TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
            return true;
        }
        if (!isLeader && !isOfficer) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_THE_FACTIONS_LEADER_OR_OFFICER_TO_DO_THIS}));
            return false;
        }
        if (sourceFaction.isEnemy(targetFaction)) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_ARE_IN_WAR_WITH_THIS_FACTION + " " + Messages.SEND_THIS_FACTION_A_PEACE_REQUEST_FIRST_BEFORE_INVITING_THEM_TO_ALLIES}));
            return false;
        }
        if (sourceFaction.isAlly(targetFaction)) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.DISBAND_ALLIANCE_FIRST_TO_INVITE_FACTION_TO_THE_TRUCE}));
            return false;
        }
        TruceRequestImpl invite = new TruceRequestImpl(sourceFaction.getName(), targetFaction.getName());
        EagleFactionsPlugin.RELATION_INVITES.add(invite);
        Optional<Player> optionalInvitedFactionLeader = this.playerManager.getPlayer(targetFaction.getLeader());
        optionalInvitedFactionLeader.ifPresent(x -> ((Player)optionalInvitedFactionLeader.get()).sendMessage(this.getTruceInviteGetMessage(sourceFaction)));
        targetFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> this.getTruceInviteGetMessage(sourceFaction)));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_HAVE_INVITED_FACTION_TO_THE_TRUCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
        EagleFactionsScheduler.getInstance().scheduleWithDelay(new RemoveRelationRequestTask(invite), 2L, TimeUnit.MINUTES);
        return true;
    }

    @Override
    public boolean sendArmisticeOrWarRequest(Player player, Faction sourceFaction, Faction targetFaction) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)sourceFaction);
        Preconditions.checkNotNull((Object)targetFaction);
        if (sourceFaction.getName().equals(targetFaction.getName())) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANNOT_BE_IN_WAR_WITH_YOURSELF}));
            return false;
        }
        if (targetFaction.isSafeZone() || targetFaction.isWarZone()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "You can't do this!"}));
            return false;
        }
        boolean hasAdminMode = this.playerManager.hasAdminMode((User)player);
        boolean isLeader = this.isLeader(sourceFaction, player);
        boolean isOfficer = this.isOfficer(sourceFaction, player);
        if (hasAdminMode) {
            if (sourceFaction.isEnemy(targetFaction)) {
                this.forceArmisticeBetween(sourceFaction, targetFaction);
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage("You force set armistice between you and " + Placeholders.FACTION_NAME.getPlaceholder(), TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
            } else {
                this.forceWarBetween(sourceFaction, targetFaction);
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage("You force set war between you and " + Placeholders.FACTION_NAME.getPlaceholder(), TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
            }
            return true;
        }
        if (!isLeader && !isOfficer) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_THE_FACTIONS_LEADER_OR_OFFICER_TO_DO_THIS}));
            return false;
        }
        if (sourceFaction.isAlly(targetFaction) || sourceFaction.isTruce(targetFaction)) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_FACTION_IS_YOUR_ALLY + " " + Messages.DISBAND_ALLIANCE_FIRST_TO_DECLARE_A_WAR}));
            return false;
        }
        if (sourceFaction.isEnemy(targetFaction)) {
            return this.sendArmisticeRequest(player, sourceFaction, targetFaction);
        }
        return this.declareWar(player, sourceFaction, targetFaction);
    }

    @Override
    public void acceptAllyRequest(AllyRequest allyRequest) {
        this.factionLogic.addAlly(allyRequest.getInvitedFaction(), allyRequest.getSenderFaction());
        Faction senderFaction = this.factionLogic.getFactionByName(allyRequest.getSenderFaction());
        Optional<Player> optionalSenderFactionLeader = this.playerManager.getPlayer(senderFaction.getLeader());
        optionalSenderFactionLeader.ifPresent(x -> ((Player)optionalSenderFactionLeader.get()).sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_INVITE_TO_THE_ALLIANCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, allyRequest.getInvitedFaction()})))})));
        senderFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_INVITE_TO_THE_ALLIANCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, allyRequest.getInvitedFaction()})))})));
        EagleFactionsPlugin.RELATION_INVITES.remove(allyRequest);
    }

    @Override
    public void acceptTruceRequest(TruceRequest truceRequest) {
        this.factionLogic.addTruce(truceRequest.getInvitedFaction(), truceRequest.getSenderFaction());
        Faction senderFaction = this.factionLogic.getFactionByName(truceRequest.getSenderFaction());
        Optional<Player> optionalSenderFactionLeader = this.playerManager.getPlayer(senderFaction.getLeader());
        optionalSenderFactionLeader.ifPresent(x -> ((Player)optionalSenderFactionLeader.get()).sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_INVITE_TO_THE_TRUCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, truceRequest.getInvitedFaction()})))})));
        senderFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_INVITE_TO_THE_TRUCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, truceRequest.getInvitedFaction()})))})));
        EagleFactionsPlugin.RELATION_INVITES.remove(truceRequest);
    }

    @Override
    public void acceptArmisticeRequest(ArmisticeRequest armisticeRequest) {
        this.factionLogic.removeEnemy(armisticeRequest.getInvitedFaction(), armisticeRequest.getSenderFaction());
        Faction senderFaction = this.factionLogic.getFactionByName(armisticeRequest.getSenderFaction());
        Optional<Player> senderFactionLeader = this.playerManager.getPlayer(senderFaction.getLeader());
        senderFactionLeader.ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_ARMISTICE_REQUEST, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, armisticeRequest.getInvitedFaction()})))})));
        senderFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> y.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_ARMISTICE_REQUEST, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, armisticeRequest.getInvitedFaction()})))}))));
        EagleFactionsPlugin.RELATION_INVITES.remove(armisticeRequest);
    }

    private boolean isLeader(Faction faction, Player player) {
        return player.getUniqueId().equals(faction.getLeader());
    }

    private boolean isOfficer(Faction faction, Player player) {
        return faction.getOfficers().contains(player.getUniqueId());
    }

    private void forceAllianceBetween(Faction senderFaction, Faction selectedFaction) {
        this.factionLogic.removeEnemy(senderFaction.getName(), selectedFaction.getName());
        this.factionLogic.removeTruce(senderFaction.getName(), selectedFaction.getName());
        this.factionLogic.addAlly(senderFaction.getName(), selectedFaction.getName());
    }

    private void forceTruceBetween(Faction senderFaction, Faction targetFaction) {
        this.factionLogic.removeEnemy(senderFaction.getName(), targetFaction.getName());
        this.factionLogic.removeAlly(senderFaction.getName(), targetFaction.getName());
        this.factionLogic.addTruce(senderFaction.getName(), targetFaction.getName());
    }

    private void forceWarBetween(Faction senderFaction, Faction targetFaction) {
        this.factionLogic.removeAlly(senderFaction.getName(), targetFaction.getName());
        this.factionLogic.removeTruce(senderFaction.getName(), targetFaction.getName());
        this.factionLogic.addEnemy(senderFaction.getName(), targetFaction.getName());
    }

    private void forceArmisticeBetween(Faction senderFaction, Faction targetFaction) {
        this.factionLogic.removeEnemy(senderFaction.getName(), targetFaction.getName());
    }

    private boolean sendArmisticeRequest(Player player, Faction sourceFaction, Faction targetFaction) {
        ArmisticeRequestImpl armisticeRequest = new ArmisticeRequestImpl(sourceFaction.getName(), targetFaction.getName());
        if (EagleFactionsPlugin.RELATION_INVITES.contains(armisticeRequest)) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.YOU_HAVE_ALREADY_SENT_ARMISTICE_REQUEST}));
            return false;
        }
        EagleFactionsPlugin.RELATION_INVITES.add(armisticeRequest);
        Optional<Player> targetFactionLeader = this.playerManager.getPlayer(targetFaction.getLeader());
        targetFactionLeader.ifPresent(x -> x.sendMessage(this.getArmisticeRequestMessage(sourceFaction)));
        targetFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> y.sendMessage(this.getArmisticeRequestMessage(sourceFaction))));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_REQUESTED_ARMISTICE_WITH_FACTION, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
        EagleFactionsScheduler.getInstance().scheduleWithDelayAsync(new RemoveRelationRequestTask(armisticeRequest), 2L, TimeUnit.MINUTES);
        return true;
    }

    private boolean declareWar(Player player, Faction sourceFaction, Faction targetFaction) {
        this.factionLogic.addEnemy(sourceFaction.getName(), targetFaction.getName());
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, MessageLoader.parseMessage(Messages.YOUR_FACTION_IS_NOW_ENEMIES_WITH_FACTION, TextColors.RESET, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
        this.playerManager.getPlayer(targetFaction.getLeader()).ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_HAS_DECLARED_YOU_A_WAR, TextColors.RED, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, sourceFaction.getName()})))})));
        targetFaction.getOfficers().forEach(x -> this.playerManager.getPlayer((UUID)x).ifPresent(y -> y.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_HAS_DECLARED_YOU_A_WAR, TextColors.RED, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, sourceFaction.getName()})))}))));
        return true;
    }

    private Text getInviteReceivedMessage(Faction senderFaction) {
        Text clickHereText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "[", TextColors.GOLD, Messages.CLICK_HERE, TextColors.AQUA, "]"})}).onClick((ClickAction)TextActions.runCommand((String)("/f join " + senderFaction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, "/f join " + senderFaction.getName()}))).build();
        return Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_SENT_YOU_AN_INVITE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, senderFaction.getName()}))), Messages.YOU_HAVE_TWO_MINUTES_TO_ACCEPT_IT, "\n", clickHereText, TextColors.GREEN, " ", Messages.TO_ACCEPT_INVITATION_OR_TYPE, " ", TextColors.GOLD, "/f join " + senderFaction.getName()});
    }

    private Text getAllyInviteGetMessage(Faction senderFaction) {
        Text clickHereText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "[", TextColors.GOLD, Messages.CLICK_HERE, TextColors.AQUA, "]"})}).onClick((ClickAction)TextActions.runCommand((String)("/f ally " + senderFaction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, "/f ally " + senderFaction.getName()}))).build();
        return Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_SENT_YOU_AN_INVITE_TO_THE_ALLIANCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, senderFaction.getName()}))), "\n", Messages.YOU_HAVE_TWO_MINUTES_TO_ACCEPT_IT, "\n", clickHereText, TextColors.GREEN, " ", Messages.TO_ACCEPT_INVITATION_OR_TYPE, " ", TextColors.GOLD, "/f ally ", senderFaction.getName()});
    }

    private Text getTruceInviteGetMessage(Faction senderFaction) {
        Text clickHereText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "[", TextColors.GOLD, Messages.CLICK_HERE, TextColors.AQUA, "]"})}).onClick((ClickAction)TextActions.runCommand((String)("/f truce " + senderFaction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, "/f truce " + senderFaction.getName()}))).build();
        return Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_SENT_YOU_AN_INVITE_TO_THE_TRUCE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, senderFaction.getName()}))), "\n", Messages.YOU_HAVE_TWO_MINUTES_TO_ACCEPT_IT, "\n", clickHereText, TextColors.GREEN, " ", Messages.TO_ACCEPT_INVITATION_OR_TYPE, " ", TextColors.GOLD, "/f truce ", senderFaction.getName()});
    }

    private Text getArmisticeRequestMessage(Faction senderFaction) {
        Text clickHereText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "[", TextColors.GOLD, Messages.CLICK_HERE, TextColors.AQUA, "]"})}).onClick((ClickAction)TextActions.runCommand((String)("/f enemy " + senderFaction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, "/f enemy " + senderFaction.getName()}))).build();
        return Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_SENT_YOU_AN_ARMISTICE_REQUEST, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, senderFaction.getName(), "\n", Messages.YOU_HAVE_TWO_MINUTES_TO_ACCEPT_IT, "\n", clickHereText, TextColors.GREEN, " ", Messages.TO_ACCEPT_IT_OR_TYPE, " ", TextColors.GOLD, "/f enemy " + senderFaction.getName()})))});
    }
}

