/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.managers.PowerManager;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.scheduling.PowerIncrementTask;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Singleton
public class PowerManagerImpl
implements PowerManager {
    private final PlayerManager playerManager;
    private final PowerConfig powerConfig;
    private final UUID dummyUUID = new UUID(0L, 0L);

    public PowerManagerImpl(PlayerManager playerManager, PowerConfig powerConfig) {
        this.playerManager = playerManager;
        this.powerConfig = powerConfig;
    }

    @Override
    public int getFactionMaxClaims(Faction faction) {
        float power = this.getFactionPower(faction);
        return (int)power;
    }

    @Override
    public float getPlayerPower(@Nullable UUID playerUUID) {
        if (playerUUID == null || playerUUID.equals(this.dummyUUID)) {
            return 0.0f;
        }
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        return optionalFactionPlayer.map(FactionPlayer::getPower).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public float getFactionPower(Faction faction) {
        if (faction.isSafeZone() || faction.isWarZone()) {
            return 9999.0f;
        }
        float factionPower = 0.0f;
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("")) {
            factionPower += this.getPlayerPower(faction.getLeader());
        }
        if (faction.getOfficers() != null && !faction.getOfficers().isEmpty()) {
            for (UUID officer : faction.getOfficers()) {
                float officerPower = this.getPlayerPower(officer);
                factionPower += officerPower;
            }
        }
        if (faction.getMembers() != null && !faction.getMembers().isEmpty()) {
            for (UUID member : faction.getMembers()) {
                float memberPower = this.getPlayerPower(member);
                factionPower += memberPower;
            }
        }
        if (faction.getRecruits() != null && !faction.getRecruits().isEmpty()) {
            for (UUID recruit : faction.getRecruits()) {
                float recruitPower = this.getPlayerPower(recruit);
                factionPower += recruitPower;
            }
        }
        return PowerManagerImpl.round(factionPower, 2);
    }

    @Override
    public float getFactionMaxPower(Faction faction) {
        if (faction.isSafeZone() || faction.isWarZone()) {
            return 9999.0f;
        }
        float factionMaxPower = 0.0f;
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("")) {
            factionMaxPower += this.getPlayerMaxPower(faction.getLeader());
        }
        if (faction.getOfficers() != null && !faction.getOfficers().isEmpty()) {
            for (UUID officer : faction.getOfficers()) {
                factionMaxPower += this.getPlayerMaxPower(officer);
            }
        }
        if (faction.getMembers() != null && !faction.getMembers().isEmpty()) {
            for (UUID member : faction.getMembers()) {
                factionMaxPower += this.getPlayerMaxPower(member);
            }
        }
        if (faction.getRecruits() != null && !faction.getRecruits().isEmpty()) {
            for (UUID recruit : faction.getRecruits()) {
                factionMaxPower += this.getPlayerMaxPower(recruit);
            }
        }
        return PowerManagerImpl.round(factionMaxPower, 2);
    }

    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        if (playerUUID == null || playerUUID.equals(this.dummyUUID)) {
            return 0.0f;
        }
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        return optionalFactionPlayer.map(FactionPlayer::getMaxPower).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public boolean setPlayerPower(UUID playerUUID, float power) {
        if (playerUUID == null || playerUUID.equals(this.dummyUUID)) {
            return false;
        }
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        if (!optionalFactionPlayer.isPresent()) {
            return false;
        }
        FactionPlayer factionPlayer = optionalFactionPlayer.get();
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), factionPlayer.getFactionName().orElse(null), PowerManagerImpl.round(power, 2), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
        return this.playerManager.savePlayer(updatedPlayer);
    }

    @Override
    public boolean setPlayerMaxPower(UUID playerUUID, float maxpower) {
        if (playerUUID == null || playerUUID.equals(this.dummyUUID)) {
            return false;
        }
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        if (!optionalFactionPlayer.isPresent()) {
            return false;
        }
        FactionPlayer factionPlayer = optionalFactionPlayer.get();
        FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), factionPlayer.getFactionName().orElse(null), factionPlayer.getPower(), maxpower, factionPlayer.diedInWarZone());
        return this.playerManager.savePlayer(updatedPlayer);
    }

    @Override
    public void addPower(UUID playerUUID, boolean isKillAward) {
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        if (!optionalFactionPlayer.isPresent()) {
            return;
        }
        float playerPower = optionalFactionPlayer.get().getPower();
        float playerMaxPower = optionalFactionPlayer.get().getMaxPower();
        if (isKillAward) {
            this.setPlayerPower(playerUUID, PowerManagerImpl.round(Math.min(playerPower + this.powerConfig.getKillAward(), playerMaxPower), 2));
        } else {
            this.setPlayerPower(playerUUID, PowerManagerImpl.round(Math.min(playerPower + this.powerConfig.getPowerIncrement(), playerMaxPower), 2));
        }
    }

    public static float round(float number, int decimalPlace) {
        int pow = 10;
        for (int i = 1; i < decimalPlace; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }

    @Override
    public void startIncreasingPower(UUID playerUUID) {
        EagleFactionsScheduler eagleFactionsScheduler = EagleFactionsScheduler.getInstance();
        eagleFactionsScheduler.scheduleWithDelayedInterval(new PowerIncrementTask(this.playerManager, this, this.powerConfig, playerUUID), 0L, TimeUnit.SECONDS, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void decreasePower(UUID playerUUID) {
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        if (!optionalFactionPlayer.isPresent()) {
            return;
        }
        float playerPower = optionalFactionPlayer.get().getPower();
        if (playerPower - this.powerConfig.getPowerDecrement() > 0.0f) {
            this.setPlayerPower(playerUUID, playerPower - this.powerConfig.getPowerDecrement());
        } else {
            this.setPlayerPower(playerUUID, 0.0f);
        }
    }

    @Override
    public void penalty(UUID playerUUID) {
        float penalty;
        Optional<FactionPlayer> optionalFactionPlayer = this.playerManager.getFactionPlayer(playerUUID);
        if (!optionalFactionPlayer.isPresent()) {
            return;
        }
        float playerPower = optionalFactionPlayer.get().getPower();
        if (playerPower - (penalty = this.powerConfig.getPenalty()) > 0.0f) {
            this.setPlayerPower(playerUUID, playerPower - penalty);
        } else {
            this.setPlayerPower(playerUUID, 0.0f);
        }
    }
}

