/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.config.ChatConfig;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.EagleFeather;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionType;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.PermsManager;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.api.managers.ProtectionManager;
import io.github.aquerr.eaglefactions.api.managers.ProtectionResult;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class ProtectionManagerImpl
implements ProtectionManager {
    private static final String ITEM_IT_AND_FACTION_TYPE_MUST_BE_PROVIDED = "Item id and faction type must be provided";
    private final FactionLogic factionLogic;
    private final PermsManager permsManager;
    private final PlayerManager playerManager;
    private final ProtectionConfig protectionConfig;
    private final ChatConfig chatConfig;
    private final FactionsConfig factionsConfig;

    public ProtectionManagerImpl(FactionLogic factionLogic, PermsManager permsManager, PlayerManager playerManager, ProtectionConfig protectionConfig, ChatConfig chatConfig, FactionsConfig factionsConfig) {
        this.protectionConfig = protectionConfig;
        this.chatConfig = chatConfig;
        this.factionsConfig = factionsConfig;
        this.factionLogic = factionLogic;
        this.permsManager = permsManager;
        this.playerManager = playerManager;
    }

    @Override
    public ProtectionResult canInteractWithBlock(Location<World> location, User user, boolean shouldNotify) {
        ProtectionResult canInteract = this.canInteractWithBlock(location, user);
        if (shouldNotify && !canInteract.hasAccess()) {
            this.notifyPlayer(user);
        }
        return canInteract;
    }

    private ProtectionResult canInteractWithBlock(Location<World> location, User user) {
        boolean isBlockCarrierAtLocation;
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "BlockInteract:"})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Location: ", TextColors.RESET, ((World)location.getExtent()).getName() + " " + location.getBlockPosition().toString()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "User: ", TextColors.RESET, user.getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Block at location: ", TextColors.RESET, location.getBlock().getName()})));
        }
        World world = (World)location.getExtent();
        if (this.protectionConfig.getNotClaimableWorldNames().contains(world.getName())) {
            return ProtectionResult.ok();
        }
        if (this.playerManager.hasAdminMode(user)) {
            return ProtectionResult.okAdmin();
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        boolean bl = isBlockCarrierAtLocation = location.getTileEntity().isPresent() && location.getTileEntity().get() instanceof BlockCarrier;
        if (safeZoneWorlds.contains(world.getName())) {
            if (this.isBlockWhitelistedForInteraction(location.getBlock().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.builder().hasAccess(true).isSafeZone(true).build();
            }
            if (user.hasPermission("eaglefactions.safezone.interact")) {
                return ProtectionResult.builder().hasAccess(true).isSafeZone(true).build();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (warZoneWorlds.contains(world.getName())) {
            if (this.isBlockWhitelistedForInteraction(location.getBlock().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (user.hasPermission("eaglefactions.warzone.interact")) {
                return ProtectionResult.okWarZone();
            }
            if (isBlockCarrierAtLocation && this.isHoldingEagleFeather(user)) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalChunkFaction.isPresent()) {
            if (!this.protectionConfig.shouldProtectWildernessFromPlayers()) {
                return ProtectionResult.ok();
            }
            if (this.isBlockWhitelistedForInteraction(location.getBlock().getId(), FactionType.WILDERNESS)) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone()) {
            if (this.isBlockWhitelistedForInteraction(location.getBlock().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            if (user.hasPermission("eaglefactions.safezone.interact")) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (chunkFaction.isWarZone()) {
            if (this.isBlockWhitelistedForInteraction(location.getBlock().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (user.hasPermission("eaglefactions.warzone.interact")) {
                return ProtectionResult.okWarZone();
            }
            if (isBlockCarrierAtLocation && this.isHoldingEagleFeather(user)) {
                return ProtectionResult.okEagleFeather();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        if (this.isBlockWhitelistedForInteraction(location.getBlock().getId(), FactionType.FACTION)) {
            return ProtectionResult.ok();
        }
        if (!optionalPlayerFaction.isPresent()) {
            if (isBlockCarrierAtLocation && this.isHoldingEagleFeather(user)) {
                return ProtectionResult.okEagleFeather();
            }
            return ProtectionResult.forbidden();
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (this.permsManager.canInteract(user.getUniqueId(), playerFaction, chunkFaction, chunkFaction.getClaimAt(world.getUniqueId(), location.getChunkPosition()).get())) {
            return ProtectionResult.okFactionPerm();
        }
        if (isBlockCarrierAtLocation && this.isHoldingEagleFeather(user)) {
            return ProtectionResult.okEagleFeather();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public ProtectionResult canUseItem(Location<World> location, User user, ItemStackSnapshot usedItem, boolean shouldNotify) {
        ProtectionResult canUseItem = this.canUseItem(location, user, usedItem);
        if (shouldNotify && !canUseItem.hasAccess()) {
            this.notifyPlayer(user);
        }
        return canUseItem;
    }

    private ProtectionResult canUseItem(Location<World> location, User user, ItemStackSnapshot usedItem) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "ItemUsage:"})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Location: ", TextColors.RESET, ((World)location.getExtent()).getName() + " " + location.getBlockPosition().toString()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "User: ", TextColors.RESET, user.getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Block at location: ", TextColors.RESET, location.getBlock().getId()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Used item: ", TextColors.RESET, usedItem.getType().getId()})));
        }
        World world = (World)location.getExtent();
        if (this.protectionConfig.getNotClaimableWorldNames().contains(world.getName())) {
            return ProtectionResult.ok();
        }
        if (this.playerManager.hasAdminMode(user)) {
            return ProtectionResult.okAdmin();
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName())) {
            if (this.isItemWhitelisted(usedItem.getType().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            if (user.hasPermission("eaglefactions.safezone.interact")) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (warZoneWorlds.contains(world.getName())) {
            if (this.isItemWhitelisted(usedItem.getType().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (user.hasPermission("eaglefactions.warzone.interact")) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalChunkFaction.isPresent()) {
            if (!this.protectionConfig.shouldProtectWildernessFromPlayers()) {
                return ProtectionResult.ok();
            }
            if (this.isItemWhitelisted(usedItem.getType().getId(), FactionType.WILDERNESS)) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone()) {
            if (this.isItemWhitelisted(usedItem.getType().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            if (user.hasPermission("eaglefactions.safezone.interact")) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (chunkFaction.isWarZone()) {
            if (this.isItemWhitelisted(usedItem.getType().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (user.hasPermission("eaglefactions.warzone.interact")) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        if (this.isItemWhitelisted(usedItem.getType().getId(), FactionType.FACTION)) {
            return ProtectionResult.ok();
        }
        if (!optionalPlayerFaction.isPresent()) {
            return ProtectionResult.forbidden();
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (this.permsManager.canInteract(user.getUniqueId(), playerFaction, chunkFaction, chunkFaction.getClaimAt(world.getUniqueId(), location.getChunkPosition()).get())) {
            return ProtectionResult.okFactionPerm();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public ProtectionResult canBreak(BlockSnapshot blockSnapshot, User user, boolean shouldNotify) {
        ProtectionResult canBreak = this.canBreak(blockSnapshot, user);
        if (shouldNotify && !canBreak.hasAccess()) {
            this.notifyPlayer(user);
        }
        return canBreak;
    }

    private ProtectionResult canBreak(BlockSnapshot blockSnapshot, User user) {
        Location location = blockSnapshot.getLocation().orElse(null);
        if (location == null) {
            EagleFactionsPlugin.getPlugin().printInfo("Broken BlockSnapshot does not contain a location. This is not normal.");
            return ProtectionResult.forbidden();
        }
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "BlockBreak:"})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Location: ", TextColors.RESET, ((World)location.getExtent()).getName() + " " + blockSnapshot.getPosition().toString()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "User: ", TextColors.RESET, user.getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Block at location: ", TextColors.RESET, blockSnapshot.getState().getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Block id: ", TextColors.RESET, blockSnapshot.getState().getId()})));
        }
        World world = (World)location.getExtent();
        if (this.protectionConfig.getNotClaimableWorldNames().contains(world.getName())) {
            return ProtectionResult.ok();
        }
        if (this.playerManager.hasAdminMode(user)) {
            return ProtectionResult.okAdmin();
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName())) {
            if (this.isBlockWhitelistedForPlaceDestroy(blockSnapshot.getState().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            if (user.hasPermission("eaglefactions.safezone.build")) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (warZoneWorlds.contains(world.getName())) {
            if (this.isBlockWhitelistedForPlaceDestroy(blockSnapshot.getState().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (user.hasPermission("eaglefactions.warzone.build")) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (optionalChunkFaction.isPresent()) {
            if (optionalChunkFaction.get().isSafeZone() || optionalChunkFaction.get().isWarZone()) {
                if (optionalChunkFaction.get().isSafeZone()) {
                    if (this.isBlockWhitelistedForPlaceDestroy(blockSnapshot.getState().getId(), FactionType.SAFE_ZONE)) {
                        return ProtectionResult.okSafeZone();
                    }
                    if (user.hasPermission("eaglefactions.safezone.build")) {
                        return ProtectionResult.okSafeZone();
                    }
                    return ProtectionResult.forbiddenSafeZone();
                }
                if (this.isBlockWhitelistedForPlaceDestroy(blockSnapshot.getState().getId(), FactionType.WAR_ZONE)) {
                    return ProtectionResult.okWarZone();
                }
                if (user.hasPermission("eaglefactions.warzone.build")) {
                    return ProtectionResult.okWarZone();
                }
                return ProtectionResult.forbiddenWarZone();
            }
            if (this.isBlockWhitelistedForPlaceDestroy(blockSnapshot.getState().getId(), FactionType.FACTION)) {
                return ProtectionResult.ok();
            }
            Faction chunkFaction = optionalChunkFaction.get();
            Optional<Claim> optionalClaim = chunkFaction.getClaimAt(world.getUniqueId(), location.getChunkPosition());
            if (optionalPlayerFaction.filter(faction -> this.permsManager.canBreakBlock(user.getUniqueId(), (Faction)faction, (Faction)optionalChunkFaction.get(), (Claim)optionalClaim.get())).isPresent()) {
                return ProtectionResult.okFactionPerm();
            }
            return ProtectionResult.forbidden();
        }
        if (!this.protectionConfig.shouldProtectWildernessFromPlayers()) {
            return ProtectionResult.ok();
        }
        if (this.isBlockWhitelistedForPlaceDestroy(blockSnapshot.getState().getId(), FactionType.WILDERNESS)) {
            return ProtectionResult.ok();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public ProtectionResult canBreak(BlockSnapshot blockSnapshot) {
        Location location = blockSnapshot.getLocation().orElse(null);
        if (location == null) {
            EagleFactionsPlugin.getPlugin().printInfo("Broken BlockSnapshot does not contain a location. This is not normal.");
            return ProtectionResult.forbidden();
        }
        World world = (World)location.getExtent();
        if (this.protectionConfig.getNotClaimableWorldNames().contains(world.getName())) {
            return ProtectionResult.ok();
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(world.getName()) && this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
            if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return ProtectionResult.ok();
        }
        if (optionalChunkFaction.get().isSafeZone()) {
            if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (optionalChunkFaction.get().isWarZone() && this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
            if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        if (this.protectionConfig.shouldProtectClaimFromMobGrief()) {
            if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.FACTION)) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        return ProtectionResult.ok();
    }

    @Override
    public ProtectionResult canPlace(BlockSnapshot blockSnapshot, User player, boolean shouldNotify) {
        ProtectionResult canPlace = this.canPlace(blockSnapshot, player);
        if (shouldNotify && !canPlace.hasAccess()) {
            this.notifyPlayer(player);
        }
        return canPlace;
    }

    private ProtectionResult canPlace(BlockSnapshot blockSnapshot, User user) {
        String itemId;
        Location location = blockSnapshot.getLocation().orElse(null);
        if (location == null) {
            EagleFactionsPlugin.getPlugin().printInfo("Placed BlockSnapshot does not contain a location. This is not normal.");
            return ProtectionResult.forbidden();
        }
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "BlockPlace:"})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Location: ", TextColors.RESET, ((World)location.getExtent()).getName() + " " + blockSnapshot.getPosition().toString()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "User: ", TextColors.RESET, user.getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Block at location: ", TextColors.RESET, blockSnapshot.getState().getType().getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Item in hand: ", TextColors.RESET, user.getItemInHand(HandTypes.MAIN_HAND).isPresent() ? ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getName() : ""})));
        }
        World world = (World)location.getExtent();
        String string = itemId = user.getItemInHand(HandTypes.MAIN_HAND).isPresent() ? ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getId() : "";
        if (this.protectionConfig.getNotClaimableWorldNames().contains(world.getName())) {
            return ProtectionResult.ok();
        }
        if (this.playerManager.hasAdminMode(user)) {
            return ProtectionResult.okAdmin();
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName())) {
            if (this.isBlockWhitelistedForPlaceDestroy(itemId, FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            if (user.hasPermission("eaglefactions.safezone.build")) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (warZoneWorlds.contains(world.getName())) {
            if (this.isBlockWhitelistedForPlaceDestroy(itemId, FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (user.hasPermission("eaglefactions.warzone.build")) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (optionalChunkFaction.isPresent()) {
            if (optionalChunkFaction.get().isSafeZone() || optionalChunkFaction.get().isWarZone()) {
                if (optionalChunkFaction.get().isSafeZone()) {
                    if (this.isBlockWhitelistedForPlaceDestroy(itemId, FactionType.SAFE_ZONE)) {
                        return ProtectionResult.okSafeZone();
                    }
                    if (user.hasPermission("eaglefactions.safezone.build")) {
                        return ProtectionResult.okSafeZone();
                    }
                    return ProtectionResult.forbiddenSafeZone();
                }
                if (this.isBlockWhitelistedForPlaceDestroy(itemId, FactionType.WAR_ZONE)) {
                    return ProtectionResult.okWarZone();
                }
                if (user.hasPermission("eaglefactions.warzone.build")) {
                    return ProtectionResult.okWarZone();
                }
                return ProtectionResult.forbiddenWarZone();
            }
            if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.FACTION)) {
                return ProtectionResult.ok();
            }
            Faction chunkFaction = optionalChunkFaction.get();
            if (optionalPlayerFaction.filter(faction -> this.permsManager.canPlaceBlock(user.getUniqueId(), (Faction)faction, chunkFaction, chunkFaction.getClaimAt(world.getUniqueId(), location.getChunkPosition()).get())).isPresent()) {
                return ProtectionResult.okFactionPerm();
            }
            return ProtectionResult.forbidden();
        }
        if (!this.protectionConfig.shouldProtectWildernessFromPlayers()) {
            return ProtectionResult.ok();
        }
        if (this.isBlockWhitelistedForPlaceDestroy(location.getBlock().getId(), FactionType.WILDERNESS)) {
            return ProtectionResult.ok();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public ProtectionResult canExplode(Location<World> location, User user, boolean shouldNotify) {
        ProtectionResult canExplode = this.canExplode(location, user);
        if (shouldNotify && !canExplode.hasAccess()) {
            this.notifyPlayer(user);
        }
        return canExplode;
    }

    private ProtectionResult canExplode(Location<World> location, User user) {
        World world = (World)location.getExtent();
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Explosion:"})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Location: ", TextColors.RESET, location.toString()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "User: ", TextColors.RESET, user.getName()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Block at location: ", TextColors.RESET, location.getBlock().getName()})));
        }
        if (this.protectionConfig.getNotClaimableWorldNames().contains(world.getName())) {
            return ProtectionResult.ok();
        }
        boolean shouldProtectWarZoneFromPlayers = this.protectionConfig.shouldProtectWarzoneFromPlayers();
        boolean allowExplosionsByOtherPlayersInClaims = this.protectionConfig.shouldAllowExplosionsByOtherPlayersInClaims();
        if (this.playerManager.hasAdminMode(user)) {
            return ProtectionResult.okAdmin();
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            return ProtectionResult.forbiddenSafeZone();
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(world.getName())) {
            if (!shouldProtectWarZoneFromPlayers) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            if (!this.protectionConfig.shouldProtectWildernessFromPlayers()) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone() || chunkFaction.isWarZone()) {
            if (chunkFaction.isSafeZone()) {
                if (user.hasPermission("eaglefactions.safezone.build")) {
                    return ProtectionResult.okSafeZone();
                }
                return ProtectionResult.forbiddenSafeZone();
            }
            if (chunkFaction.isWarZone() && user.hasPermission("eaglefactions.warzone.build")) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalPlayerFaction = this.factionLogic.getFactionByPlayerUUID(user.getUniqueId());
        if (optionalPlayerFaction.isPresent()) {
            Faction playerFaction = optionalPlayerFaction.get();
            if (chunkFaction.getName().equalsIgnoreCase(playerFaction.getName())) {
                if (this.permsManager.canPlaceBlock(user.getUniqueId(), playerFaction, chunkFaction, chunkFaction.getClaimAt(world.getUniqueId(), location.getChunkPosition()).get())) {
                    return ProtectionResult.okFactionPerm();
                }
                return ProtectionResult.forbidden();
            }
        }
        if (allowExplosionsByOtherPlayersInClaims) {
            return ProtectionResult.ok();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public ProtectionResult canExplode(Location<World> location) {
        if (this.protectionConfig.getNotClaimableWorldNames().contains(((World)location.getExtent()).getName())) {
            return ProtectionResult.ok();
        }
        boolean shouldProtectWarZoneFromMobGrief = this.protectionConfig.shouldProtectWarZoneFromMobGrief();
        boolean shouldProtectClaimsFromMobGrief = this.protectionConfig.shouldProtectClaimFromMobGrief();
        if (this.protectionConfig.getSafeZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return ProtectionResult.forbiddenSafeZone();
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            if (!shouldProtectWarZoneFromMobGrief) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return ProtectionResult.ok();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone()) {
            return ProtectionResult.forbiddenSafeZone();
        }
        if (chunkFaction.isWarZone() && shouldProtectWarZoneFromMobGrief) {
            return ProtectionResult.forbiddenWarZone();
        }
        if (!shouldProtectClaimsFromMobGrief) {
            return ProtectionResult.ok();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public ProtectionResult canHitEntity(Entity attackedEntity, Player player, boolean shouldNotify) {
        ProtectionResult canAttack = this.canAttackEntity(attackedEntity, player);
        if (shouldNotify && !canAttack.hasAccess()) {
            this.notifyPlayer((User)player);
        }
        return canAttack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProtectionResult canAttackEntity(Entity attackedEntity, Player player) {
        boolean notClaimableWorld;
        boolean isMob;
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(player.getUniqueId())) {
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "EntityAttack:"})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Location: ", TextColors.RESET, ((World)attackedEntity.getLocation().getExtent()).getName() + " " + attackedEntity.getLocation().getBlockPosition().toString()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "Entity at location: ", TextColors.RESET, attackedEntity.getType().getId()})));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.GOLD, "User: ", TextColors.RESET, player.getName()})));
        }
        if (this.playerManager.hasAdminMode((User)player)) {
            return ProtectionResult.okAdmin();
        }
        boolean isPlayer = attackedEntity instanceof Player;
        boolean bl = isMob = !isPlayer && attackedEntity instanceof Living && !(attackedEntity instanceof ArmorStand);
        if (isMob) {
            return ProtectionResult.ok();
        }
        Location entityLocation = attackedEntity.getLocation();
        Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(((World)entityLocation.getExtent()).getUniqueId(), entityLocation.getChunkPosition());
        Optional<Faction> optionalAttackerPlayerFaction = this.factionLogic.getFactionByPlayerUUID(player.getUniqueId());
        Optional<Faction> optionalSourceChunkFaction = this.factionLogic.getFactionByChunk(player.getWorld().getUniqueId(), player.getLocation().getChunkPosition());
        boolean isSafeZoneWorld = this.protectionConfig.getSafeZoneWorldNames().contains(((World)entityLocation.getExtent()).getName());
        boolean isWarZoneWorld = !isSafeZoneWorld && this.protectionConfig.getWarZoneWorldNames().contains(((World)entityLocation.getExtent()).getName());
        boolean bl2 = notClaimableWorld = !isSafeZoneWorld && !isWarZoneWorld && this.protectionConfig.getNotClaimableWorldNames().contains(((World)entityLocation.getExtent()).getName());
        if (isPlayer) {
            Player attackedPlayer = (Player)attackedEntity;
            Optional<Faction> optionalAttackedPlayerFaction = this.factionLogic.getFactionByPlayerUUID(attackedPlayer.getUniqueId());
            if (isSafeZoneWorld) {
                return ProtectionResult.forbiddenSafeZone();
            }
            if (optionalChunkFaction.isPresent() && optionalChunkFaction.get().isSafeZone()) {
                return ProtectionResult.forbiddenSafeZone();
            }
            if (attackedEntity.equals(player)) {
                return ProtectionResult.ok();
            }
            if (optionalSourceChunkFaction.isPresent() && optionalSourceChunkFaction.get().isSafeZone()) {
                return ProtectionResult.forbiddenSafeZone();
            }
            if (!optionalAttackerPlayerFaction.isPresent()) {
                return ProtectionResult.ok();
            }
            if (!optionalAttackedPlayerFaction.isPresent()) {
                return ProtectionResult.ok();
            }
            Faction attackedFaction = optionalAttackedPlayerFaction.get();
            Faction attackerFaction = optionalAttackerPlayerFaction.get();
            if (!attackerFaction.getName().equals(attackedFaction.getName())) {
                if (attackerFaction.isAlly(attackedFaction) && !this.factionsConfig.isAllianceFriendlyFire()) {
                    return ProtectionResult.forbidden();
                }
                if (!attackerFaction.isTruce(attackedFaction) || this.factionsConfig.isTruceFriendlyFire()) return ProtectionResult.ok();
                return ProtectionResult.forbidden();
            }
            if (!this.factionsConfig.isFactionFriendlyFire()) return ProtectionResult.forbidden();
            return ProtectionResult.ok();
        }
        if (notClaimableWorld) {
            return ProtectionResult.ok();
        }
        if (isSafeZoneWorld) {
            return ProtectionResult.forbiddenSafeZone();
        }
        if (isWarZoneWorld) {
            if (this.protectionConfig.shouldProtectWarzoneFromPlayers()) return ProtectionResult.forbiddenWarZone();
            return ProtectionResult.okWarZone();
        }
        if (!optionalChunkFaction.isPresent()) {
            return ProtectionResult.ok();
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.isSafeZone()) {
            return ProtectionResult.forbiddenSafeZone();
        }
        if (chunkFaction.isWarZone()) {
            if (this.protectionConfig.shouldProtectWarzoneFromPlayers()) return ProtectionResult.forbiddenWarZone();
            return ProtectionResult.okWarZone();
        }
        if (!optionalAttackerPlayerFaction.isPresent()) {
            return ProtectionResult.forbidden();
        }
        Faction attackerFaction = optionalAttackerPlayerFaction.get();
        if (!this.permsManager.canBreakBlock(player.getUniqueId(), attackerFaction, chunkFaction, chunkFaction.getClaimAt(((World)entityLocation.getExtent()).getUniqueId(), entityLocation.getChunkPosition()).get())) return ProtectionResult.forbidden();
        return ProtectionResult.okFactionPerm();
    }

    @Override
    public ProtectionResult canNotifyBlock(Location<World> notifier, Location<World> notifiedLocation) {
        boolean notClaimableWorld;
        boolean isSafeZoneWorld = this.protectionConfig.getSafeZoneWorldNames().contains(((World)notifiedLocation.getExtent()).getName());
        boolean isWarZoneWorld = !isSafeZoneWorld && this.protectionConfig.getWarZoneWorldNames().contains(((World)notifiedLocation.getExtent()).getName());
        boolean bl = notClaimableWorld = !isSafeZoneWorld && !isWarZoneWorld && this.protectionConfig.getNotClaimableWorldNames().contains(((World)notifiedLocation.getExtent()).getName());
        if (isSafeZoneWorld || isWarZoneWorld || notClaimableWorld) {
            return ProtectionResult.ok();
        }
        Optional<Faction> notifierFaction = this.factionLogic.getFactionByChunk(((World)notifier.getExtent()).getUniqueId(), notifier.getChunkPosition());
        Optional<Faction> notifiedFaction = this.factionLogic.getFactionByChunk(((World)notifiedLocation.getExtent()).getUniqueId(), notifiedLocation.getChunkPosition());
        if (!notifierFaction.isPresent()) {
            if (!notifiedFaction.isPresent()) {
                return ProtectionResult.ok();
            }
            Faction faction = notifiedFaction.get();
            if (faction.isSafeZone()) {
                return ProtectionResult.forbiddenSafeZone();
            }
            if (faction.isWarZone()) {
                if (!this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
                    return ProtectionResult.okWarZone();
                }
                return ProtectionResult.forbiddenWarZone();
            }
            if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.FACTION)) {
                return ProtectionResult.ok();
            }
            if (!this.protectionConfig.shouldProtectClaimFromMobGrief()) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        Faction sourceFaction = notifierFaction.get();
        if (!notifiedFaction.isPresent()) {
            return ProtectionResult.ok();
        }
        Faction targetFaction = notifiedFaction.get();
        if (targetFaction.equals(sourceFaction)) {
            return ProtectionResult.ok();
        }
        if (sourceFaction.isSafeZone()) {
            if (targetFaction.isWarZone()) {
                if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.WAR_ZONE)) {
                    return ProtectionResult.okWarZone();
                }
                if (!this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
                    return ProtectionResult.okWarZone();
                }
                return ProtectionResult.forbiddenWarZone();
            }
            if (!this.protectionConfig.shouldProtectClaimFromMobGrief()) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        if (sourceFaction.isWarZone()) {
            if (targetFaction.isSafeZone()) {
                if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.SAFE_ZONE)) {
                    return ProtectionResult.okSafeZone();
                }
                return ProtectionResult.forbiddenSafeZone();
            }
            if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.FACTION)) {
                return ProtectionResult.ok();
            }
            if (!this.protectionConfig.shouldProtectClaimFromMobGrief()) {
                return ProtectionResult.ok();
            }
            return ProtectionResult.forbidden();
        }
        if (targetFaction.isSafeZone()) {
            if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.SAFE_ZONE)) {
                return ProtectionResult.okSafeZone();
            }
            return ProtectionResult.forbiddenSafeZone();
        }
        if (targetFaction.isWarZone()) {
            if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.WAR_ZONE)) {
                return ProtectionResult.okWarZone();
            }
            if (!this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
                return ProtectionResult.okWarZone();
            }
            return ProtectionResult.forbiddenWarZone();
        }
        if (this.isBlockWhitelistedForPlaceDestroy(notifiedLocation.getBlock().getId(), FactionType.FACTION)) {
            return ProtectionResult.ok();
        }
        if (!this.protectionConfig.shouldProtectClaimFromMobGrief()) {
            return ProtectionResult.ok();
        }
        return ProtectionResult.forbidden();
    }

    @Override
    public boolean isItemWhitelisted(String itemId, FactionType factionType) {
        if (StringUtils.isBlank((CharSequence)itemId) || Objects.isNull((Object)factionType)) {
            throw new IllegalArgumentException(ITEM_IT_AND_FACTION_TYPE_MUST_BE_PROVIDED);
        }
        switch (factionType) {
            case FACTION: {
                return this.protectionConfig.getFactionWhitelists().isItemWhiteListed(itemId);
            }
            case WAR_ZONE: {
                return this.protectionConfig.getWarZoneWhitelists().isItemWhiteListed(itemId);
            }
            case SAFE_ZONE: {
                return this.protectionConfig.getSafeZoneWhitelists().isItemWhiteListed(itemId);
            }
            case WILDERNESS: {
                return this.protectionConfig.getWildernessWhitelists().isItemWhiteListed(itemId);
            }
        }
        return false;
    }

    @Override
    public boolean isBlockWhitelistedForInteraction(String blockId, FactionType factionType) {
        if (StringUtils.isBlank((CharSequence)blockId) || Objects.isNull((Object)factionType)) {
            throw new IllegalArgumentException(ITEM_IT_AND_FACTION_TYPE_MUST_BE_PROVIDED);
        }
        switch (factionType) {
            case FACTION: {
                return this.protectionConfig.getFactionWhitelists().isBlockWhiteListedForInteraction(blockId);
            }
            case WAR_ZONE: {
                return this.protectionConfig.getWarZoneWhitelists().isBlockWhiteListedForInteraction(blockId);
            }
            case SAFE_ZONE: {
                return this.protectionConfig.getSafeZoneWhitelists().isBlockWhiteListedForInteraction(blockId);
            }
            case WILDERNESS: {
                return this.protectionConfig.getWildernessWhitelists().isBlockWhiteListedForInteraction(blockId);
            }
        }
        return false;
    }

    @Override
    public boolean isBlockWhitelistedForPlaceDestroy(String blockOrItemId, FactionType factionType) {
        if (StringUtils.isBlank((CharSequence)blockOrItemId) || Objects.isNull((Object)factionType)) {
            throw new IllegalArgumentException(ITEM_IT_AND_FACTION_TYPE_MUST_BE_PROVIDED);
        }
        switch (factionType) {
            case FACTION: {
                return this.protectionConfig.getFactionWhitelists().isBlockWhitelistedForPlaceDestroy(blockOrItemId);
            }
            case WAR_ZONE: {
                return this.protectionConfig.getWarZoneWhitelists().isBlockWhitelistedForPlaceDestroy(blockOrItemId);
            }
            case SAFE_ZONE: {
                return this.protectionConfig.getSafeZoneWhitelists().isBlockWhitelistedForPlaceDestroy(blockOrItemId);
            }
            case WILDERNESS: {
                return this.protectionConfig.getWildernessWhitelists().isBlockWhitelistedForPlaceDestroy(blockOrItemId);
            }
        }
        return false;
    }

    private boolean isHoldingEagleFeather(User user) {
        return user.getItemInHand(HandTypes.MAIN_HAND).filter(itemStack -> ItemTypes.FEATHER == itemStack.getType()).filter(itemStack -> itemStack.get(Keys.DISPLAY_NAME).isPresent()).flatMap(itemStack -> itemStack.get(Keys.DISPLAY_NAME)).map(arg_0 -> ((Text)EagleFeather.getDisplayName()).equals(arg_0)).orElse(false);
    }

    private void notifyPlayer(User user) {
        if (this.chatConfig.shouldDisplayProtectionSystemMessages()) {
            user.getPlayer().ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS})));
        }
    }
}

