/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.common.base.Preconditions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.exception.PlayerNotInFactionException;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.managers.RankManager;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.Player;

public class RankManagerImpl
implements RankManager {
    private final FactionLogic factionLogic;
    private final StorageManager storageManager;

    public RankManagerImpl(FactionLogic factionLogic, StorageManager storageManager) {
        this.factionLogic = factionLogic;
        this.storageManager = storageManager;
    }

    @Override
    public FactionMemberType demotePlayer(@Nullable Player player, FactionPlayer targetPlayer) throws PlayerNotInFactionException {
        Preconditions.checkNotNull((Object)targetPlayer);
        Faction faction = targetPlayer.getFaction().orElseThrow(() -> new PlayerNotInFactionException(targetPlayer));
        boolean isCancelled = EventRunner.runFactionDemoteEventPre(player, targetPlayer, faction);
        if (isCancelled) {
            return targetPlayer.getFactionRole();
        }
        FactionMemberType demotedTo = FactionMemberType.RECRUIT;
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (members.contains(targetPlayer.getUniqueId())) {
            recruits.add(targetPlayer.getUniqueId());
            members.remove(targetPlayer.getUniqueId());
        } else if (officers.contains(targetPlayer.getUniqueId())) {
            members.add(targetPlayer.getUniqueId());
            officers.remove(targetPlayer.getUniqueId());
            demotedTo = FactionMemberType.MEMBER;
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setOfficers(officers).setMembers(members).build();
        this.storageManager.saveFaction(updatedFaction);
        FactionPlayer factionPlayer = this.storageManager.getPlayer(targetPlayer.getUniqueId());
        if (factionPlayer != null) {
            this.storageManager.savePlayer(new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), updatedFaction.getName(), factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone()));
            EventRunner.runFactionDemoteEventPost(player, targetPlayer, demotedTo, updatedFaction);
        }
        return demotedTo;
    }

    @Override
    public FactionMemberType promotePlayer(@Nullable Player player, FactionPlayer targetPlayer) throws PlayerNotInFactionException {
        Preconditions.checkNotNull((Object)targetPlayer);
        Faction faction = targetPlayer.getFaction().orElseThrow(() -> new PlayerNotInFactionException(targetPlayer));
        boolean isCancelled = EventRunner.runFactionPromoteEventPre(player, targetPlayer, faction);
        if (isCancelled) {
            return targetPlayer.getFactionRole();
        }
        FactionMemberType promotedTo = FactionMemberType.MEMBER;
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (recruits.contains(targetPlayer.getUniqueId())) {
            members.add(targetPlayer.getUniqueId());
            recruits.remove(targetPlayer.getUniqueId());
        } else if (members.contains(targetPlayer.getUniqueId())) {
            officers.add(targetPlayer.getUniqueId());
            members.remove(targetPlayer.getUniqueId());
            promotedTo = FactionMemberType.OFFICER;
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setOfficers(officers).setMembers(members).build();
        this.storageManager.saveFaction(updatedFaction);
        FactionPlayer factionPlayer = this.storageManager.getPlayer(targetPlayer.getUniqueId());
        if (factionPlayer != null) {
            FactionPlayerImpl updatedPlayer = new FactionPlayerImpl(factionPlayer.getName(), factionPlayer.getUniqueId(), updatedFaction.getName(), factionPlayer.getPower(), factionPlayer.getMaxPower(), factionPlayer.diedInWarZone());
            this.storageManager.savePlayer(updatedPlayer);
            EventRunner.runFactionPromoteEventPost(player, factionPlayer, promotedTo, updatedFaction);
        }
        return promotedTo;
    }

    @Override
    public boolean setLeader(@Nullable FactionPlayer targetPlayer, Faction faction) {
        UUID newLeaderUUID;
        Preconditions.checkNotNull((Object)faction);
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        if (!faction.getLeader().equals(new UUID(0L, 0L))) {
            officers.add(faction.getLeader());
        }
        if (targetPlayer == null) {
            newLeaderUUID = new UUID(0L, 0L);
        } else {
            newLeaderUUID = targetPlayer.getUniqueId();
            if (faction.getOfficers().contains(targetPlayer.getUniqueId())) {
                officers.remove(targetPlayer.getUniqueId());
            } else if (faction.getMembers().contains(targetPlayer.getUniqueId())) {
                members.remove(targetPlayer.getUniqueId());
            } else if (faction.getRecruits().contains(targetPlayer.getUniqueId())) {
                recruits.remove(targetPlayer.getUniqueId());
            }
        }
        Faction updatedFaction = faction.toBuilder().setLeader(newLeaderUUID).setOfficers(officers).setMembers(members).setRecruits(recruits).build();
        this.storageManager.saveFaction(updatedFaction);
        return true;
    }
}

