/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.scheduling;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsRunnableTask;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.scheduling.WorldRegenTask;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class FactionRemoverTask
implements EagleFactionsRunnableTask {
    private final FactionLogic factionLogic;
    private final FactionsConfig factionsConfig;
    private final EagleFactionsScheduler scheduler = EagleFactionsScheduler.getInstance();

    public FactionRemoverTask(EagleFactions plugin) {
        this.factionLogic = plugin.getFactionLogic();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public String getName() {
        return "eaglefactions-factions-remover-task";
    }

    @Override
    public void run() {
        long maxInactiveTimeInSeconds = this.factionsConfig.getMaxInactiveTime();
        Map<String, Faction> factionsList = this.factionLogic.getFactions();
        boolean shouldNotifyWhenRemoved = this.factionsConfig.shouldNotifyWhenFactionRemoved();
        boolean shouldRegenerateWhenRemoved = this.factionsConfig.shouldRegenerateChunksWhenFactionRemoved();
        for (Faction faction : factionsList.values()) {
            boolean didSucceed;
            boolean isCancelled;
            Duration inactiveTime;
            if (this.factionLogic.hasOnlinePlayers(faction) || faction.isSafeZone() || faction.isWarZone() || (inactiveTime = Duration.between(faction.getLastOnline(), Instant.now())).getSeconds() < maxInactiveTimeInSeconds || (isCancelled = EventRunner.runFactionDisbandEventPre(null, faction, false, true)) || !(didSucceed = this.factionLogic.disbandFaction(faction.getName()))) continue;
            if (shouldNotifyWhenRemoved) {
                Sponge.getServer().getBroadcastChannel().send(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.FACTION_HAS_BEEN_REMOVED_DUE_TO_INACTIVITY_TIME, TextColors.RED, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, faction.getName()})))}));
            }
            if (shouldRegenerateWhenRemoved) {
                for (Claim claim : faction.getClaims()) {
                    this.scheduler.scheduleWithDelay(new WorldRegenTask(claim), 0L, TimeUnit.SECONDS);
                }
            }
            EventRunner.runFactionDisbandEventPost(null, faction, false, true);
        }
    }
}

