/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.file.hocon;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.entities.FactionChestImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.storage.serializers.EFTypeSerializers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.TypeTokens;

public class ConfigurateHelper {
    public static boolean putFactionInNode(ConfigurationNode configNode, Faction faction) {
        try {
            configNode.getNode(new Object[]{"name"}).setValue((Object)faction.getName());
            configNode.getNode(new Object[]{"tag"}).setValue(TypeTokens.TEXT_TOKEN, (Object)faction.getTag());
            configNode.getNode(new Object[]{"leader"}).setValue((Object)faction.getLeader().toString());
            configNode.getNode(new Object[]{"description"}).setValue((Object)faction.getDescription());
            configNode.getNode(new Object[]{"motd"}).setValue((Object)faction.getMessageOfTheDay());
            configNode.getNode(new Object[]{"officers"}).setValue((TypeToken)new TypeToken<ArrayList<UUID>>(){}, new ArrayList<UUID>(faction.getOfficers()));
            configNode.getNode(new Object[]{"members"}).setValue((TypeToken)new TypeToken<ArrayList<UUID>>(){}, new ArrayList<UUID>(faction.getMembers()));
            configNode.getNode(new Object[]{"recruits"}).setValue((TypeToken)new TypeToken<ArrayList<UUID>>(){}, new ArrayList<UUID>(faction.getRecruits()));
            configNode.getNode(new Object[]{"truces"}).setValue(faction.getTruces());
            configNode.getNode(new Object[]{"alliances"}).setValue(faction.getAlliances());
            configNode.getNode(new Object[]{"enemies"}).setValue(faction.getEnemies());
            configNode.getNode(new Object[]{"claims"}).setValue(EFTypeSerializers.CLAIM_SET_TYPE_TOKEN, faction.getClaims());
            configNode.getNode(new Object[]{"last_online"}).setValue((Object)faction.getLastOnline().toString());
            configNode.getNode(new Object[]{"perms"}).setValue(faction.getPerms());
            configNode.getNode(new Object[]{"chest"}).setValue((TypeToken)new TypeToken<List<FactionChest.SlotItem>>(){}, faction.getChest().getItems());
            configNode.getNode(new Object[]{"isPublic"}).setValue((Object)faction.isPublic());
            if (faction.getHome() == null) {
                configNode.getNode(new Object[]{"home"}).setValue((Object)faction.getHome());
            } else {
                configNode.getNode(new Object[]{"home"}).setValue((Object)(faction.getHome().getWorldUUID().toString() + '|' + faction.getHome().getBlockPosition().toString()));
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean putPlayerInNode(ConfigurationNode configNode, FactionPlayer factionPlayer) {
        try {
            configNode.getNode(new Object[]{"faction"}).setValue((Object)factionPlayer.getFactionName().orElse(""));
            configNode.getNode(new Object[]{"faction-member-type"}).setValue((Object)factionPlayer.getFactionRole().toString());
            configNode.getNode(new Object[]{"name"}).setValue((Object)factionPlayer.getName());
            configNode.getNode(new Object[]{"power"}).setValue((Object)Float.valueOf(factionPlayer.getPower()));
            configNode.getNode(new Object[]{"maxpower"}).setValue((Object)Float.valueOf(factionPlayer.getMaxPower()));
            configNode.getNode(new Object[]{"death-in-warzone"}).setValue((Object)factionPlayer.diedInWarZone());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static List<Faction> getFactionsFromNode(ConfigurationNode configNode) {
        ArrayList<Faction> factions = new ArrayList<Faction>();
        Set keySet = configNode.getChildrenMap().keySet();
        for (Object object : keySet) {
            if (!(object instanceof String)) continue;
            try {
                Faction faction = ConfigurateHelper.getFactionFromNode(configNode.getNode(new Object[]{object}));
                factions.add(faction);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return factions;
    }

    public static Faction getFactionFromNode(ConfigurationNode configNode) throws ObjectMappingException {
        String factionName = configNode.getNode(new Object[]{"name"}).getString();
        if (configNode.getKey() != null) {
            factionName = (String)configNode.getKey();
        }
        Text tag = (Text)configNode.getNode(new Object[]{"tag"}).getValue(TypeTokens.TEXT_TOKEN);
        String description = configNode.getNode(new Object[]{"description"}).getString();
        String messageOfTheDay = configNode.getNode(new Object[]{"motd"}).getString();
        Object leaderValue = configNode.getNode(new Object[]{"leader"}).getValue();
        if (leaderValue == null || leaderValue instanceof String && ((String)leaderValue).trim().equals("")) {
            configNode.getNode(new Object[]{"leader"}).setValue(TypeTokens.UUID_TOKEN, (Object)new UUID(0L, 0L));
        }
        UUID leader = (UUID)configNode.getNode(new Object[]{"leader"}).getValue(TypeToken.of(UUID.class), (Object)new UUID(0L, 0L));
        FactionHome home = FactionHome.from(String.valueOf(configNode.getNode(new Object[]{"home"}).getValue((Object)"")));
        Set officers = (Set)configNode.getNode(new Object[]{"officers"}).getValue(EFTypeSerializers.UUID_SET_TYPE_TOKEN, (Object)Collections.EMPTY_SET);
        Set members = (Set)configNode.getNode(new Object[]{"members"}).getValue(EFTypeSerializers.UUID_SET_TYPE_TOKEN, (Object)Collections.EMPTY_SET);
        Set recruits = (Set)configNode.getNode(new Object[]{"recruits"}).getValue(EFTypeSerializers.UUID_SET_TYPE_TOKEN, (Object)Collections.EMPTY_SET);
        Set<String> alliances = new HashSet(configNode.getNode(new Object[]{"alliances"}).getList(TypeToken.of(String.class), Collections.emptyList())).stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Set<String> enemies = new HashSet(configNode.getNode(new Object[]{"enemies"}).getList(TypeToken.of(String.class), Collections.emptyList())).stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Set<String> truces = new HashSet(configNode.getNode(new Object[]{"truces"}).getList(TypeToken.of(String.class), Collections.emptyList())).stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Set claims = (Set)configNode.getNode(new Object[]{"claims"}).getValue(EFTypeSerializers.CLAIM_SET_TYPE_TOKEN, (Object)Collections.EMPTY_SET);
        Instant lastOnline = configNode.getNode(new Object[]{"last_online"}).getValue() != null ? Instant.parse(configNode.getNode(new Object[]{"last_online"}).getString()) : Instant.now();
        Map<FactionMemberType, Map<FactionPermType, Boolean>> perms = ConfigurateHelper.getFactionPermsFromNode(configNode.getNode(new Object[]{"perms"}));
        List slotItems = (List)configNode.getNode(new Object[]{"chest"}).getValue((TypeToken)new TypeToken<List<FactionChest.SlotItem>>(){});
        FactionChestImpl chest = slotItems == null ? new FactionChestImpl(factionName) : new FactionChestImpl(factionName, slotItems);
        boolean isPublic = configNode.getNode(new Object[]{"isPublic"}).getBoolean(false);
        return FactionImpl.builder(factionName, tag, leader).setDescription(description).setMessageOfTheDay(messageOfTheDay).setHome(home).setOfficers(officers).setMembers(members).setRecruits(recruits).setAlliances(alliances).setEnemies(enemies).setTruces(truces).setClaims(claims).setLastOnline(lastOnline).setPerms(perms).setChest(chest).setIsPublic(isPublic).build();
    }

    public static FactionPlayer getPlayerFromFile(File file) {
        HoconConfigurationLoader playerConfigLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(file)).build();
        try {
            UUID playerUUID;
            ConfigurationNode playerNode = playerConfigLoader.load();
            String playerName = playerNode.getNode(new Object[]{"name"}).getString("");
            try {
                playerUUID = UUID.fromString(file.getName().substring(0, file.getName().indexOf(46)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Files.delete(file.toPath());
                return null;
            }
            String factionName = playerNode.getNode(new Object[]{"faction"}).getString("");
            String factionMemberTypeString = playerNode.getNode(new Object[]{"faction-member-type"}).getString("");
            float power = playerNode.getNode(new Object[]{"power"}).getFloat(0.0f);
            float maxpower = playerNode.getNode(new Object[]{"maxpower"}).getFloat(0.0f);
            boolean diedInWarZone = playerNode.getNode(new Object[]{"death-in-warzone"}).getBoolean(false);
            return new FactionPlayerImpl(playerName, playerUUID, factionName, power, maxpower, diedInWarZone);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<FactionMemberType, Map<FactionPermType, Boolean>> getFactionPermsFromNode(ConfigurationNode factionNode) {
        LinkedHashMap<FactionMemberType, Map<FactionPermType, Boolean>> flagMap = new LinkedHashMap<FactionMemberType, Map<FactionPermType, Boolean>>();
        LinkedHashMap<FactionPermType, Boolean> officerMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> membersMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> recruitMap = new LinkedHashMap<FactionPermType, Boolean>();
        LinkedHashMap<FactionPermType, Boolean> allyMap = new LinkedHashMap<FactionPermType, Boolean>();
        boolean officerUSE = factionNode.getNode(new Object[]{"OFFICER", "USE"}).getBoolean(true);
        boolean officerPLACE = factionNode.getNode(new Object[]{"OFFICER", "PLACE"}).getBoolean(true);
        boolean officerDESTROY = factionNode.getNode(new Object[]{"OFFICER", "DESTROY"}).getBoolean(true);
        boolean officerCLAIM = factionNode.getNode(new Object[]{"OFFICER", "CLAIM"}).getBoolean(true);
        boolean officerATTACK = factionNode.getNode(new Object[]{"LEADER", "ATTACK"}).getBoolean(true);
        boolean officerINVITE = factionNode.getNode(new Object[]{"OFFICER", "INVITE"}).getBoolean(true);
        boolean memberUSE = factionNode.getNode(new Object[]{"MEMBER", "USE"}).getBoolean(true);
        boolean memberPLACE = factionNode.getNode(new Object[]{"MEMBER", "PLACE"}).getBoolean(true);
        boolean memberDESTROY = factionNode.getNode(new Object[]{"MEMBER", "DESTROY"}).getBoolean(true);
        boolean memberCLAIM = factionNode.getNode(new Object[]{"MEMBER", "CLAIM"}).getBoolean(false);
        boolean memberATTACK = factionNode.getNode(new Object[]{"LEADER", "ATTACK"}).getBoolean(false);
        boolean memberINVITE = factionNode.getNode(new Object[]{"MEMBER", "INVITE"}).getBoolean(true);
        boolean recruitUSE = factionNode.getNode(new Object[]{"RECRUIT", "USE"}).getBoolean(true);
        boolean recruitPLACE = factionNode.getNode(new Object[]{"RECRUIT", "PLACE"}).getBoolean(true);
        boolean recruitDESTROY = factionNode.getNode(new Object[]{"RECRUIT", "DESTROY"}).getBoolean(true);
        boolean recruitCLAIM = factionNode.getNode(new Object[]{"RECRUIT", "CLAIM"}).getBoolean(false);
        boolean recruitATTACK = factionNode.getNode(new Object[]{"RECRUIT", "ATTACK"}).getBoolean(false);
        boolean recruitINVITE = factionNode.getNode(new Object[]{"RECRUIT", "INVITE"}).getBoolean(false);
        boolean allyUSE = factionNode.getNode(new Object[]{"ALLY", "USE"}).getBoolean(true);
        boolean allyPLACE = factionNode.getNode(new Object[]{"ALLY", "PLACE"}).getBoolean(false);
        boolean allyDESTROY = factionNode.getNode(new Object[]{"ALLY", "DESTROY"}).getBoolean(false);
        officerMap.put(FactionPermType.USE, officerUSE);
        officerMap.put(FactionPermType.PLACE, officerPLACE);
        officerMap.put(FactionPermType.DESTROY, officerDESTROY);
        officerMap.put(FactionPermType.CLAIM, officerCLAIM);
        officerMap.put(FactionPermType.ATTACK, officerATTACK);
        officerMap.put(FactionPermType.INVITE, officerINVITE);
        membersMap.put(FactionPermType.USE, memberUSE);
        membersMap.put(FactionPermType.PLACE, memberPLACE);
        membersMap.put(FactionPermType.DESTROY, memberDESTROY);
        membersMap.put(FactionPermType.CLAIM, memberCLAIM);
        membersMap.put(FactionPermType.ATTACK, memberATTACK);
        membersMap.put(FactionPermType.INVITE, memberINVITE);
        recruitMap.put(FactionPermType.USE, recruitUSE);
        recruitMap.put(FactionPermType.PLACE, recruitPLACE);
        recruitMap.put(FactionPermType.DESTROY, recruitDESTROY);
        recruitMap.put(FactionPermType.CLAIM, recruitCLAIM);
        recruitMap.put(FactionPermType.ATTACK, recruitATTACK);
        recruitMap.put(FactionPermType.INVITE, recruitINVITE);
        allyMap.put(FactionPermType.USE, allyUSE);
        allyMap.put(FactionPermType.PLACE, allyPLACE);
        allyMap.put(FactionPermType.DESTROY, allyDESTROY);
        flagMap.put(FactionMemberType.OFFICER, officerMap);
        flagMap.put(FactionMemberType.MEMBER, membersMap);
        flagMap.put(FactionMemberType.RECRUIT, recruitMap);
        flagMap.put(FactionMemberType.ALLY, allyMap);
        return flagMap;
    }

    public static ConfigurationOptions getDefaultOptions() {
        ConfigurationOptions configurationOptions = ConfigurationOptions.defaults();
        return configurationOptions.setAcceptedTypes((Set)ImmutableSet.of(Map.class, Set.class, List.class, Double.class, Float.class, Long.class, (Object[])new Class[]{Integer.class, Boolean.class, String.class, Short.class, Byte.class, Number.class}));
    }
}

